/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.jaas;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class CallbackHandlerImpl
implements CallbackHandler {
    private static boolean DEBUG = false;
    private BrokerResources rb = Globals.getBrokerResources();
    private transient Logger logger = Globals.getLogger();
    private Properties authProps = null;
    private String userName = null;
    private String password = null;

    private CallbackHandlerImpl() {
    }

    public CallbackHandlerImpl(Properties properties, String string, String string2) {
        this.authProps = properties;
        this.userName = string;
        this.password = string2;
    }

    protected synchronized void destroy() {
        this.authProps = null;
        this.userName = null;
        this.password = null;
    }

    public synchronized void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbackArray.length; ++i) {
            Object object;
            if (callbackArray[i] instanceof LanguageCallback) {
                LanguageCallback languageCallback = (LanguageCallback)callbackArray[i];
                if (DEBUG) {
                    this.logger.log(8, "JAAS CallbackHander handle LanguageCallback - returning " + this.rb.getLocale());
                }
                languageCallback.setLocale(this.rb.getLocale());
                continue;
            }
            if (callbackArray[i] instanceof NameCallback) {
                if (this.userName == null) {
                    String string = Globals.getBrokerResources().getKString("B4299", "NameCallback");
                    this.logger.log(32, string);
                    throw new UnsupportedCallbackException(callbackArray[i], string);
                }
                NameCallback nameCallback = (NameCallback)callbackArray[i];
                if (DEBUG) {
                    this.logger.log(8, "JAAS CallbackHander handle NameCallback prompt: " + ((NameCallback)callbackArray[i]).getPrompt() + " - returning " + this.userName);
                }
                nameCallback.setName(this.userName);
                continue;
            }
            if (callbackArray[i] instanceof PasswordCallback) {
                if (this.password == null) {
                    String string = Globals.getBrokerResources().getKString("B4299", "PasswordCallback");
                    this.logger.log(32, string);
                    throw new UnsupportedCallbackException(callbackArray[i], string);
                }
                PasswordCallback passwordCallback = (PasswordCallback)callbackArray[i];
                if (DEBUG) {
                    this.logger.log(8, "JAAS CallbackHander handle PasswordCallback [" + passwordCallback.getClass().getName() + "] prompt:" + passwordCallback.getPrompt());
                }
                passwordCallback.setPassword(this.password.toCharArray());
                continue;
            }
            if (callbackArray[i] instanceof TextInputCallback) {
                if (this.authProps == null) {
                    String string = Globals.getBrokerResources().getKString("B4299", "TextInputCallback");
                    this.logger.log(32, string);
                    throw new UnsupportedCallbackException(callbackArray[i], string);
                }
                TextInputCallback textInputCallback = (TextInputCallback)callbackArray[i];
                object = null;
                if (textInputCallback.getPrompt().equals("imq.authentication.type")) {
                    object = this.authProps.getProperty("imq.authentication.type");
                } else if (textInputCallback.getPrompt().equals("imq.accesscontrol.type")) {
                    object = this.authProps.getProperty("imq.accesscontrol.type");
                } else if (textInputCallback.getPrompt().equals("imq.authentication.clientip")) {
                    object = this.authProps.getProperty("imq.authentication.clientip");
                } else if (textInputCallback.getPrompt().equals("imq.servicename")) {
                    object = this.authProps.getProperty("imq.servicename");
                } else if (textInputCallback.getPrompt().equals("imq.servicetype")) {
                    object = this.authProps.getProperty("imq.servicetype");
                } else {
                    String string = Globals.getBrokerResources().getKString("B2199", textInputCallback.getClass().getName(), textInputCallback.getPrompt());
                    this.logger.log(16, string);
                    throw new UnsupportedCallbackException(callbackArray[i], string);
                }
                if (DEBUG) {
                    this.logger.log(8, "JAAS CallbackHander handle TextInputCallback prompt: " + ((TextInputCallback)callbackArray[i]).getPrompt() + " - returning " + (String)object);
                }
                textInputCallback.setText((String)object);
                continue;
            }
            if (callbackArray[i] instanceof TextOutputCallback) {
                int n = Integer.MAX_VALUE;
                object = (TextOutputCallback)callbackArray[i];
                switch (((TextOutputCallback)object).getMessageType()) {
                    case 0: {
                        n = 8;
                        break;
                    }
                    case 1: {
                        n = 16;
                        break;
                    }
                    case 2: {
                        n = 32;
                        break;
                    }
                    default: {
                        String string = Globals.getBrokerResources().getKString("B2200", object.getClass().getName(), ((TextOutputCallback)object).getMessageType());
                        this.logger.log(16, string);
                        throw new UnsupportedCallbackException(callbackArray[i], string);
                    }
                }
                this.logger.log(n, object.getClass().getName() + ": " + ((TextOutputCallback)object).getMessage());
                continue;
            }
            String string = Globals.getBrokerResources().getKString("B2201", callbackArray[i].getClass().getName());
            throw new UnsupportedCallbackException(callbackArray[i], string);
        }
    }
}

