/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth;

import com.sun.messaging.jmq.auth.api.server.AccessControlContext;
import com.sun.messaging.jmq.auth.api.server.model.AccessControlModel;
import com.sun.messaging.jmq.auth.jaas.MQUser;
import com.sun.messaging.jmq.jmsserver.Globals;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class JMQAccessControlContext
implements AccessControlContext {
    private MQUser mquser;
    private Subject subject;
    private Properties authProps;
    private AccessControlModel acs = null;

    public JMQAccessControlContext(MQUser mQUser, Subject subject, Properties properties) throws LoginException {
        this.mquser = mQUser;
        this.subject = subject;
        this.authProps = properties;
        String string = this.authProps.getProperty("imq.accesscontrol.enabled");
        if (string != null && string.equals("false")) {
            return;
        }
        try {
            this.loadAccessControlModel();
        }
        catch (AccessControlException accessControlException) {
            throw new LoginException(accessControlException.getMessage());
        }
    }

    private void loadAccessControlModel() throws AccessControlException {
        String string = this.authProps.getProperty("imq.accesscontrol.type");
        if (string == null || string.trim().equals("")) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4044"));
        }
        String string2 = this.authProps.getProperty("imq.accesscontrol." + string + ".class");
        if (string2 == null) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4045", string));
        }
        try {
            this.acs = (AccessControlModel)Class.forName(string2).newInstance();
            this.acs.initialize(string, this.authProps);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AccessControlException(Globals.getBrokerResources().getString("B4117", "ClassNotFoundException: " + classNotFoundException.getMessage()));
        }
        catch (InstantiationException instantiationException) {
            throw new AccessControlException(Globals.getBrokerResources().getString("B4117", "InstantiationExcetpion: " + instantiationException.getMessage()));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AccessControlException(Globals.getBrokerResources().getString("B4117", "IllegalAccessException: " + illegalAccessException.getMessage()));
        }
        catch (ClassCastException classCastException) {
            throw new AccessControlException(Globals.getBrokerResources().getString("B4117", "ClassCastException: " + classCastException.getMessage()));
        }
    }

    public Principal getClientUser() {
        return this.mquser;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void checkConnectionPermission(String string, String string2) throws AccessControlException {
        String string3;
        if (string2.equals("ADMIN") && (string3 = this.authProps.getProperty("imq.accesscontrol.enabled")) != null && string3.equals("false")) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.sun.messaging.jmq.auth.jaas.MQAdminGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AccessControlException(Globals.getBrokerResources().getKString("B4117", "ClassNotFoundException: " + classNotFoundException.getMessage()));
            }
            Set<?> set = this.subject.getPrincipals(clazz);
            if (set == null || set.size() == 0) {
                throw new AccessControlException(Globals.getBrokerResources().getKString("B4052", this.mquser.getName()));
            }
            return;
        }
        if (this.acs == null) {
            this.loadAccessControlModel();
        }
        this.acs.checkConnectionPermission(this.mquser, string, string2, this.subject);
    }

    public void checkDestinationPermission(String string, String string2, String string3, String string4, String string5) throws AccessControlException {
        if (this.acs == null) {
            this.loadAccessControlModel();
        }
        this.acs.checkDestinationPermission(this.mquser, string, string2, this.subject, string3, string4, string5);
    }
}

