/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.grizzly.Context;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.async.AsyncQueueWriteUnit;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.util.SSLOutputWriter;
import com.sun.messaging.bridge.service.BridgeContext;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompOutputHandler;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

public class AsyncStompOutputHandler
implements StompOutputHandler {
    private Logger _logger = StompServer.getLogger();
    private SelectionKey _selectionkey = null;
    private SelectorHandler _selectorhandler = null;
    private SSLEngine _sslengine = null;
    private StompProtocolHandler _sph = null;
    private BridgeContext _bc = null;
    private StompBridgeResources _sbr = null;

    public AsyncStompOutputHandler(SelectionKey selectionKey, SelectorHandler selectorHandler, SSLEngine sSLEngine, StompProtocolHandler stompProtocolHandler, BridgeContext bridgeContext) {
        this._selectionkey = selectionKey;
        this._selectorhandler = selectorHandler;
        this._sslengine = sSLEngine;
        this._sbr = StompServer.getStompBridgeResources();
        this._sph = stompProtocolHandler;
        this._bc = bridgeContext;
    }

    public void sendToClient(StompFrameMessage stompFrameMessage, Context context, StompProtocolHandler stompProtocolHandler) throws Exception {
        throw new UnsupportedOperationException("sendToClient(msg, ctx)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToClient(final StompFrameMessage stompFrameMessage) throws Exception {
        block10: {
            boolean bl = false;
            if (stompFrameMessage.getCommand() == StompFrameMessage.Command.ERROR && stompFrameMessage.isFatalERROR()) {
                bl = true;
            }
            try {
                SelectableChannel selectableChannel;
                ByteBuffer byteBuffer = stompFrameMessage.marshall();
                if (this._sslengine == null) {
                    if (!bl) {
                        this._selectorhandler.getAsyncQueueWriter().write(this._selectionkey, byteBuffer);
                    } else {
                        AsyncWriteCallbackHandler asyncWriteCallbackHandler = new AsyncWriteCallbackHandler(){

                            public void onWriteCompleted(SelectionKey selectionKey, AsyncQueueWriteUnit asyncQueueWriteUnit) {
                                AsyncStompOutputHandler.this._logger.log(Level.FINE, "Completed sending " + stompFrameMessage + ", canceling key " + selectionKey);
                                AsyncStompOutputHandler.this._selectorhandler.getSelectionKeyHandler().cancel(selectionKey);
                            }

                            public void onException(Exception exception, SelectionKey selectionKey, ByteBuffer byteBuffer, Queue<AsyncQueueWriteUnit> queue) {
                            }
                        };
                        this._selectorhandler.getAsyncQueueWriter().write(this._selectionkey, byteBuffer, asyncWriteCallbackHandler);
                    }
                    break block10;
                }
                int n = Math.max(8192, this._sslengine.getSession().getPacketBufferSize());
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n);
                byteBuffer2.position(0);
                SelectableChannel selectableChannel2 = selectableChannel = this._selectionkey.channel();
                synchronized (selectableChannel2) {
                    SSLOutputWriter.flushChannel((SelectableChannel)selectableChannel, (ByteBuffer)byteBuffer, (ByteBuffer)byteBuffer2, (SSLEngine)this._sslengine);
                }
                if (bl) {
                    this._logger.log(Level.INFO, this._sbr.getKString("BSS1007", stompFrameMessage.toString(), this._selectionkey));
                    this._selectorhandler.getSelectionKeyHandler().cancel(this._selectionkey);
                }
            }
            catch (ClosedChannelException closedChannelException) {
                StompBridgeResources stompBridgeResources = StompServer.getStompBridgeResources();
                StompServer.getStompBridgeResources();
                this._logger.log(Level.WARNING, stompBridgeResources.getKString("BSS2000", stompFrameMessage.toString(), closedChannelException.toString()));
                this._sph.close(true);
                throw closedChannelException;
            }
        }
    }
}

