/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StaxParser {
    private InputStream xmlStream;
    protected XMLStreamReader parser;

    protected abstract void read() throws XMLStreamException, EndDocumentException;

    public StaxParser(File f) throws XMLStreamException {
        try {
            this.xmlStream = new FileInputStream(f);
            this.createParser();
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public StaxParser(String resource, ClassLoader cl) throws XMLStreamException {
        this.xmlStream = cl.getResourceAsStream(resource);
        this.createParser();
    }

    public StaxParser(InputStream is) throws XMLStreamException {
        this.xmlStream = is;
        this.createParser();
    }

    protected int next() throws XMLStreamException, EndDocumentException {
        int event = this.parser.next();
        if (event == 8) {
            this.parser.close();
            throw new EndDocumentException();
        }
        return event;
    }

    protected void skipTo(String name) throws XMLStreamException, EndDocumentException {
        while (true) {
            this.nextStart();
            String localName = this.parser.getLocalName();
            if (name.equals(localName)) {
                return;
            }
            this.skipTree(localName);
        }
    }

    protected Map<String, String> parseAttributes() {
        int num = this.parser.getAttributeCount();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < num; ++i) {
            map.put(this.parser.getAttributeName(i).getLocalPart(), this.parser.getAttributeValue(i));
        }
        return map;
    }

    protected void skipPast(String name) throws XMLStreamException, EndDocumentException {
        this.skipTo(name);
        this.nextStart();
    }

    protected void nextStart() throws XMLStreamException, EndDocumentException {
        while (this.next() != 1) {
        }
    }

    protected void close() {
        try {
            if (this.parser != null) {
                this.parser.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.xmlStream != null) {
                this.xmlStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createParser() throws XMLStreamException {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        this.parser = xif.createXMLStreamReader(this.xmlStream);
    }

    private void skipTree(String name) throws XMLStreamException, EndDocumentException {
        int event;
        while ((event = this.next()) != 2 || !name.equals(this.parser.getLocalName())) {
        }
    }

    protected static class EndDocumentException
    extends Exception {
        EndDocumentException() {
        }
    }
}

