/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import com.sun.messaging.jmq.util.MD5;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.Properties;

public class FileUtil {
    private static String magicNumberString = "%947634%";
    private static String mqversion = "4.2";
    private static String formatversion = "1.0";
    private static char[] fseq = new char[]{'\u0000', '\u0001', '\u0001', '\u0002', '\u0003', '\u0005', '\b'};

    FileUtil() {
    }

    public static void removeFiles(File file, boolean bl) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            if (!file.delete()) {
                throw new IOException("failed to delete " + file);
            }
        } else {
            String[] stringArray = file.list();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    FileUtil.removeFiles(new File(file, stringArray[i]), true);
                }
            }
            if (bl && !file.delete()) {
                throw new IOException("failed to delete " + file);
            }
        }
    }

    public static String getCanonicalPath(String string) {
        File file = new File(string);
        try {
            return file.getCanonicalPath();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                FileUtil.copyDirectory(new File(file, stringArray[i]), new File(file2, stringArray[i]));
            }
        } else {
            FileUtil.copyFile(file, file2);
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
        fileChannel.close();
        fileChannel2.close();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("obfuscating file");
            FileUtil.obfuscateFile("myfile", "myfile2");
            System.out.println("deobfuscating file");
            FileUtil.deobfuscateFile("myfile2", "myfile3");
            System.out.println("Reading normal file");
            InputStream inputStream = FileUtil.retrieveObfuscatedFile("myfile");
            FileWriter fileWriter = new FileWriter("myfile4");
            Properties properties = new Properties();
            properties.load(inputStream);
            fileWriter.close();
            inputStream.close();
            System.out.println(properties);
            System.out.println("Reading modified file");
            inputStream = FileUtil.retrieveObfuscatedFile("myfile2");
            Properties properties2 = new Properties();
            properties2.load(inputStream);
            System.out.println(properties2);
            System.out.println("DONE");
            fileWriter.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void obfuscateFile(String string, String string2) throws IOException {
        String string3;
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        int n = fileInputStream.read(byArray);
        byte[] byArray2 = MD5.getHash(byArray);
        String string4 = MD5.convertToString(byArray2);
        fileInputStream.close();
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        FileWriter fileWriter = new FileWriter(string2);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(magicNumberString + ":" + string4 + ":" + formatversion + ":" + mqversion);
        bufferedWriter.newLine();
        int n2 = 0;
        while ((string3 = bufferedReader.readLine()) != null) {
            char[] cArray = string3.toCharArray();
            int n3 = n2 % fseq.length;
            String string5 = "";
            for (int i = 0; i < cArray.length; ++i) {
                if (n3 >= fseq.length) {
                    n3 = 0;
                }
                string5 = string5 + (char)(cArray[i] ^ fseq[n3]);
                ++n3;
            }
            bufferedWriter.write(string5);
            bufferedWriter.newLine();
            ++n2;
        }
        bufferedWriter.close();
        fileWriter.close();
        bufferedReader.close();
        fileReader.close();
    }

    public static void deobfuscateFile(String string, String string2) throws IOException {
        Object object;
        String string3;
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string4 = bufferedReader.readLine();
        int n = 0;
        if (!string4.startsWith(magicNumberString)) {
            fileReader.close();
            bufferedReader.close();
            throw new IOException("unobfuscated file");
        }
        int n2 = string4.indexOf(58);
        int n3 = string4.indexOf(58, n2 + 1);
        String string5 = string4.substring(n2 + 1, n3);
        FileWriter fileWriter = new FileWriter(string2);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        StringBuffer stringBuffer = new StringBuffer();
        n = 0;
        while ((string3 = bufferedReader.readLine()) != null) {
            object = string3.toCharArray();
            int n4 = n % fseq.length;
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (n4 >= fseq.length) {
                    n4 = 0;
                }
                char c = (char)(object[i] ^ fseq[n4]);
                stringBuffer.append(c);
                ++n4;
            }
            stringBuffer.append('\n');
            ++n;
        }
        string3 = stringBuffer.toString();
        object = MD5.getHashString(string3);
        if (!((String)object).equals(string5)) {
            throw new IOException("deobfuscateFile:  File corrupted, hashcodes do not match");
        }
        bufferedWriter.write(string3);
        bufferedWriter.close();
        fileWriter.close();
        bufferedReader.close();
        fileReader.close();
    }

    public static boolean isobfuscated(String string) throws IOException {
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        fileReader.close();
        return string2.startsWith(magicNumberString);
    }

    public static InputStream retrieveObfuscatedFile(String string) throws IOException {
        Object object;
        String string2;
        FileInputStream fileInputStream = new FileInputStream(string);
        int n = fileInputStream.available();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        String string3 = dataInputStream.readLine();
        if (!string3.startsWith(magicNumberString)) {
            byteArrayInputStream.reset();
            fileInputStream.close();
            return byteArrayInputStream;
        }
        int n2 = string3.indexOf(58);
        int n3 = string3.indexOf(58, n2 + 1);
        String string4 = string3.substring(n2 + 1, n3);
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while ((string2 = dataInputStream.readLine()) != null) {
            object = string2.toCharArray();
            int n5 = n4 % fseq.length;
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (n5 >= fseq.length) {
                    n5 = 0;
                }
                char c = (char)(object[i] ^ fseq[n5]);
                stringBuffer.append(c);
                ++n5;
            }
            stringBuffer.append('\n');
            ++n4;
        }
        string2 = stringBuffer.toString();
        object = MD5.getHashString(string2);
        if (!((String)object).equals(string4)) {
            throw new IOException("retrieveObfuscatedFile:  File corrupted, hashcodes do not match");
        }
        byte[] byArray2 = string2.getBytes("UTF8");
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray2);
        byteArrayInputStream.close();
        dataInputStream.close();
        fileInputStream.close();
        return byteArrayInputStream2;
    }
}

