/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.EngineLOB;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.jdbc.AutoPositioningStream;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.impl.jdbc.PositionedStoreStream;
import org.apache.derby.impl.jdbc.UpdatableBlobStream;
import org.apache.derby.impl.jdbc.Util;

final class EmbedBlob
extends ConnectionChild
implements Blob,
EngineLOB {
    private boolean materialized;
    private PositionedStoreStream myStream;
    private int locator = 0;
    private long streamLength = -1L;
    private final int streamPositionOffset;
    private boolean isValid = true;
    private LOBStreamControl control;

    EmbedBlob(byte[] byArray, EmbedConnection embedConnection) throws SQLException {
        super(embedConnection);
        try {
            this.control = new LOBStreamControl(embedConnection, byArray);
            this.materialized = true;
            this.streamPositionOffset = Integer.MIN_VALUE;
            embedConnection.addLOBReference(this);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    protected EmbedBlob(DataValueDescriptor dataValueDescriptor, EmbedConnection embedConnection) throws StandardException {
        super(embedConnection);
        InputStream inputStream = dataValueDescriptor.getStream();
        if (inputStream == null) {
            this.materialized = true;
            this.streamPositionOffset = Integer.MIN_VALUE;
            byte[] byArray = dataValueDescriptor.getBytes();
            try {
                this.control = new LOBStreamControl(this.getEmbedConnection(), byArray);
            }
            catch (IOException iOException) {
                throw StandardException.newException("XJ022.S", iOException);
            }
        }
        this.materialized = false;
        try {
            this.myStream = new PositionedStoreStream(inputStream);
            BinaryToRawStream binaryToRawStream = new BinaryToRawStream(this.myStream, embedConnection);
            this.streamPositionOffset = (int)this.myStream.getPosition();
            this.streamLength = binaryToRawStream.getLength();
            binaryToRawStream.close();
        }
        catch (StandardException standardException) {
            if (standardException.getMessageId().equals("40XD0")) {
                throw StandardException.newException("XJ073.S");
            }
            throw standardException;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XCL30.S", iOException, (Object)"BLOB");
        }
        embedConnection.addLOBReference(this);
    }

    private long setBlobPosition(long l) throws StandardException, IOException {
        if (this.materialized) {
            if (l >= this.control.getLength()) {
                throw StandardException.newException("XJ076.S", new Long(l));
            }
        } else {
            try {
                this.myStream.reposition(l + (long)this.streamPositionOffset);
            }
            catch (EOFException eOFException) {
                throw StandardException.newException("XJ076.S", eOFException, (Object)new Long(l));
            }
        }
        return l;
    }

    private int read(long l) throws IOException, StandardException {
        int n;
        if (this.materialized) {
            if (l >= this.control.getLength()) {
                return -1;
            }
            n = this.control.read(l);
        } else {
            this.myStream.reposition(l + (long)this.streamPositionOffset);
            n = this.myStream.read();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long length() throws SQLException {
        long l;
        this.checkValidity();
        try {
            if (this.materialized) {
                return this.control.getLength();
            }
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        if (this.streamLength != -1L) {
            return this.streamLength;
        }
        boolean bl = false;
        try {
            try {
                Object object = this.getConnectionSynchronization();
                synchronized (object) {
                    boolean bl2 = bl = !this.getEmbedConnection().isClosed();
                    if (bl) {
                        this.setupContextStack();
                    }
                    this.myStream.resetStream();
                    BinaryToRawStream binaryToRawStream = new BinaryToRawStream(this.myStream, this);
                    this.streamLength = InputStreamUtil.skipUntilEOF(binaryToRawStream);
                    binaryToRawStream.close();
                    l = this.streamLength;
                }
                Object var8_7 = null;
                if (!bl) return l;
            }
            catch (Throwable throwable) {
                throw this.handleMyExceptions(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!bl) throw throwable;
            this.restoreContextStack();
            throw throwable;
        }
        this.restoreContextStack();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes(long l, int n) throws SQLException {
        byte[] byArray;
        boolean bl;
        block19: {
            byte[] byArray2;
            block18: {
                byte[] byArray3;
                block17: {
                    this.checkValidity();
                    bl = false;
                    try {
                        try {
                            byte[] byArray4;
                            if (l < 1L) {
                                throw StandardException.newException("XJ070.S", new Long(l));
                            }
                            if (n < 0) {
                                throw StandardException.newException("XJ071.S", new Integer(n));
                            }
                            if (this.materialized) {
                                byArray4 = new byte[n];
                                int n2 = this.control.read(byArray4, 0, byArray4.length, l - 1L);
                                if (n2 == -1) {
                                    byArray3 = new byte[]{};
                                    Object var12_14 = null;
                                    if (!bl) return byArray3;
                                    break block17;
                                }
                                if (n2 < n) {
                                    byte[] byArray5 = new byte[n2];
                                    System.arraycopy(byArray4, 0, byArray5, 0, n2);
                                    byArray4 = byArray5;
                                }
                            } else {
                                Object object = this.getConnectionSynchronization();
                                synchronized (object) {
                                    boolean bl2 = bl = !this.getEmbedConnection().isClosed();
                                    if (bl) {
                                        this.setupContextStack();
                                    }
                                    this.setBlobPosition(l - 1L);
                                    byArray4 = new byte[n];
                                    int n3 = InputStreamUtil.readLoop(this.myStream, byArray4, 0, n);
                                    if (n3 < n) {
                                        byte[] byArray6 = new byte[n3];
                                        System.arraycopy(byArray4, 0, byArray6, 0, n3);
                                        byArray2 = byArray6;
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 13, 15] lbl37 : MonitorExitStatement: MONITOREXIT : var6_9
                                        break block18;
                                    }
                                }
                            }
                            byArray = byArray4;
                            break block19;
                        }
                        catch (StandardException standardException) {
                            StandardException standardException2;
                            if (!standardException.getMessageId().equals("XJ079.S")) throw this.handleMyExceptions(standardException2);
                            standardException2 = StandardException.newException("XJ076.S", new Long(l));
                            throw this.handleMyExceptions(standardException2);
                        }
                        catch (Throwable throwable) {
                            throw this.handleMyExceptions(throwable);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_17 = null;
                        if (!bl) throw throwable;
                        this.restoreContextStack();
                        throw throwable;
                    }
                }
                this.restoreContextStack();
                return byArray3;
            }
            Object var12_15 = null;
            if (!bl) return byArray2;
            this.restoreContextStack();
            return byArray2;
        }
        Object var12_16 = null;
        if (!bl) return byArray;
        this.restoreContextStack();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getBinaryStream() throws SQLException {
        UpdatableBlobStream updatableBlobStream;
        boolean bl;
        block9: {
            InputStream inputStream;
            block8: {
                this.checkValidity();
                bl = false;
                try {
                    try {
                        if (this.materialized) {
                            inputStream = this.control.getInputStream(0L);
                            Object var6_5 = null;
                            if (!bl) return inputStream;
                            break block8;
                        }
                        Object object = this.getConnectionSynchronization();
                        synchronized (object) {
                            boolean bl2 = bl = !this.getEmbedConnection().isClosed();
                            if (bl) {
                                this.setupContextStack();
                            }
                            this.myStream.resetStream();
                            updatableBlobStream = new UpdatableBlobStream(this, new AutoPositioningStream(this, this.myStream, this));
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        throw this.handleMyExceptions(throwable);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (!bl) throw throwable;
                    this.restoreContextStack();
                    throw throwable;
                }
            }
            this.restoreContextStack();
            return inputStream;
        }
        Object var6_6 = null;
        if (!bl) return updatableBlobStream;
        this.restoreContextStack();
        return updatableBlobStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long position(byte[] byArray, long l) throws SQLException {
        long l2;
        boolean bl;
        block18: {
            long l3;
            block17: {
                long l4;
                block16: {
                    this.checkValidity();
                    bl = false;
                    try {
                        try {
                            if (l < 1L) {
                                throw StandardException.newException("XJ070.S", new Long(l));
                            }
                            if (byArray == null) {
                                throw StandardException.newException("XJ072.S");
                            }
                            if (byArray.length == 0) {
                                l4 = l;
                                Object var16_8 = null;
                                if (!bl) return l4;
                                break block16;
                            }
                            Object object = this.getConnectionSynchronization();
                            synchronized (object) {
                                boolean bl2 = bl = !this.getEmbedConnection().isClosed();
                                if (bl) {
                                    this.setupContextStack();
                                }
                                long l5 = this.setBlobPosition(l - 1L);
                                byte by = byArray[0];
                                while (true) {
                                    int n;
                                    if ((n = this.read(l5++)) == -1) {
                                        l3 = -1L;
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 9, 14] lbl25 : MonitorExitStatement: MONITOREXIT : var5_5
                                        break block17;
                                    }
                                    if (n != by) continue;
                                    long l6 = l5;
                                    if (this.checkMatch(byArray, l5)) {
                                        l2 = l6;
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 9, 13] lbl32 : MonitorExitStatement: MONITOREXIT : var5_5
                                        break block18;
                                    }
                                    l5 = this.setBlobPosition(l6);
                                }
                            }
                        }
                        catch (StandardException standardException) {
                            throw this.handleMyExceptions(standardException);
                        }
                        catch (Throwable throwable) {
                            throw this.handleMyExceptions(throwable);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_11 = null;
                        if (!bl) throw throwable;
                        this.restoreContextStack();
                        throw throwable;
                    }
                }
                this.restoreContextStack();
                return l4;
            }
            Object var16_9 = null;
            if (!bl) return l3;
            this.restoreContextStack();
            return l3;
        }
        Object var16_10 = null;
        if (!bl) return l2;
        this.restoreContextStack();
        return l2;
    }

    private boolean checkMatch(byte[] byArray, long l) throws IOException, StandardException {
        for (int i = 1; i < byArray.length; ++i) {
            int n;
            if ((n = this.read(l++)) >= 0 && n == byArray[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long position(Blob blob, long l) throws SQLException {
        long l2;
        boolean bl;
        block21: {
            long l3;
            block20: {
                long l4;
                block19: {
                    this.checkValidity();
                    bl = false;
                    try {
                        try {
                            if (l < 1L) {
                                throw StandardException.newException("XJ070.S", new Long(l));
                            }
                            if (blob == null) {
                                throw StandardException.newException("XJ072.S");
                            }
                            Object object = this.getConnectionSynchronization();
                            synchronized (object) {
                                byte[] byArray;
                                boolean bl2 = bl = !this.getEmbedConnection().isClosed();
                                if (bl) {
                                    this.setupContextStack();
                                }
                                long l5 = this.setBlobPosition(l - 1L);
                                try {
                                    byArray = blob.getBytes(1L, 1);
                                }
                                catch (SQLException sQLException) {
                                    throw StandardException.newException("XJ077.S");
                                }
                                if (byArray == null || byArray.length < 1) {
                                    l4 = l;
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 18, 7] lbl22 : MonitorExitStatement: MONITOREXIT : var5_4
                                    Object var17_12 = null;
                                    if (!bl) return l4;
                                    break block19;
                                }
                                byte by = byArray[0];
                                while (true) {
                                    int n;
                                    if ((n = this.read(l5++)) == -1) {
                                        l3 = -1L;
                                        // MONITOREXIT @DISABLED, blocks:[0, 17, 1, 7, 12] lbl31 : MonitorExitStatement: MONITOREXIT : var5_4
                                        break block20;
                                    }
                                    if (n != by) continue;
                                    long l6 = l5;
                                    if (this.checkMatch(blob, l5)) {
                                        l2 = l6;
                                        // MONITOREXIT @DISABLED, blocks:[0, 16, 1, 7, 12] lbl38 : MonitorExitStatement: MONITOREXIT : var5_4
                                        break block21;
                                    }
                                    l5 = this.setBlobPosition(l6);
                                }
                            }
                        }
                        catch (StandardException standardException) {
                            throw this.handleMyExceptions(standardException);
                        }
                        catch (Throwable throwable) {
                            throw this.handleMyExceptions(throwable);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var17_15 = null;
                        if (!bl) throw throwable;
                        this.restoreContextStack();
                        throw throwable;
                    }
                }
                this.restoreContextStack();
                return l4;
            }
            Object var17_13 = null;
            if (!bl) return l3;
            this.restoreContextStack();
            return l3;
        }
        Object var17_14 = null;
        if (!bl) return l2;
        this.restoreContextStack();
        return l2;
    }

    private boolean checkMatch(Blob blob, long l) throws IOException, StandardException {
        int n;
        InputStream inputStream;
        try {
            inputStream = blob.getBinaryStream();
        }
        catch (SQLException sQLException) {
            return false;
        }
        if (inputStream == null) {
            return false;
        }
        int n2 = inputStream.read();
        if (n2 < 0) {
            return false;
        }
        do {
            if ((n2 = inputStream.read()) >= 0) continue;
            return true;
        } while (n2 == (n = this.read(l++)) && n >= 0);
        return false;
    }

    private SQLException handleMyExceptions(Throwable throwable) throws SQLException {
        if (throwable instanceof StandardException && ((StandardException)throwable).getMessageId().equals("40XD0")) {
            throwable = StandardException.newException("XJ073.S");
        }
        return this.handleException(throwable);
    }

    protected void finalize() {
        if (!this.materialized) {
            this.myStream.closeStream();
        }
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.checkValidity();
        try {
            if (this.materialized) {
                if (l - 1L > this.length()) {
                    throw Util.generateCsSQLException("XJ076.S", new Long(l));
                }
                if (l < 1L) {
                    throw Util.generateCsSQLException("XJ070.S", new Long(l));
                }
                this.control.write(byArray, n, n2, l - 1L);
            } else {
                this.control = new LOBStreamControl(this.getEmbedConnection());
                this.control.copyData(this.myStream, this.length());
                this.control.write(byArray, n, n2, l - 1L);
                this.myStream.close();
                this.streamLength = -1L;
                this.materialized = true;
            }
            return n2;
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        this.checkValidity();
        if (l - 1L > this.length()) {
            throw Util.generateCsSQLException("XJ076.S", new Long(l));
        }
        if (l < 1L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(l));
        }
        try {
            if (this.materialized) {
                return this.control.getOutputStream(l - 1L);
            }
            this.control = new LOBStreamControl(this.getEmbedConnection());
            this.control.copyData(this.myStream, l - 1L);
            this.myStream.close();
            this.streamLength = -1L;
            this.materialized = true;
            return this.control.getOutputStream(l - 1L);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    public void truncate(long l) throws SQLException {
        if (l > this.length()) {
            throw Util.generateCsSQLException("XJ079.S", new Long(l));
        }
        try {
            if (this.materialized) {
                this.control.truncate(l);
            } else {
                this.control = new LOBStreamControl(this.getEmbedConnection());
                this.control.copyData(this.myStream, l);
                this.myStream.close();
                this.streamLength = -1L;
                this.materialized = true;
            }
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    public void free() throws SQLException {
        if (!this.isValid) {
            return;
        }
        this.isValid = false;
        if (this.locator != 0) {
            this.localConn.removeLOBMapping(this.locator);
        }
        this.streamLength = -1L;
        if (!this.materialized) {
            this.myStream.closeStream();
            this.myStream = null;
        } else {
            try {
                this.control.free();
                this.control = null;
            }
            catch (IOException iOException) {
                throw Util.setStreamFailure(iOException);
            }
        }
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        this.checkValidity();
        if (l <= 0L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(l));
        }
        if (l2 < 0L) {
            throw Util.generateCsSQLException("XJ071.S", new Long(l2));
        }
        if (l2 > this.length() - (l - 1L)) {
            throw Util.generateCsSQLException("XJ087.S", (Object)new Long(l), new Long(l2));
        }
        try {
            return new UpdatableBlobStream(this, this.getBinaryStream(), l - 1L, l2);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
    }

    private void checkValidity() throws SQLException {
        this.getEmbedConnection().checkIfClosed();
        if (!this.isValid) {
            throw this.newSQLException("XJ215.S");
        }
    }

    boolean isMaterialized() {
        return this.materialized;
    }

    public int getLocator() {
        if (this.locator == 0) {
            this.locator = this.localConn.addLOBMapping(this);
        }
        return this.locator;
    }
}

