/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.accesslog;

import com.sun.enterprise.web.accesslog.AccessLogFormatter;
import com.sun.logging.LogDomains;
import java.nio.CharBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Request;
import org.apache.catalina.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAccessLogFormatterImpl
extends AccessLogFormatter {
    private static final Logger _logger = LogDomains.getLogger(DefaultAccessLogFormatterImpl.class, (String)"javax.enterprise.system.container.web");
    private static final ResourceBundle _rb = _logger.getResourceBundle();
    private static final String QUOTE = "\"";
    private static final String HTTP_HEADER_ACCEPT = "Accept";
    private static final String HTTP_HEADER_AUTHORIZATION = "Authorization";
    private static final String HTTP_HEADER_DATE = "Date";
    private static final String HTTP_HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String ATTRIBUTE_BY_NAME_PREFIX = "attribute.";
    private static final int ATTRIBUTE_BY_NAME_PREFIX_LEN = "attribute.".length();
    private static final String SESSION_ATTRIBUTE_BY_NAME_PREFIX = "session.";
    private static final int SESSION_ATTRIBUTE_BY_NAME_PREFIX_LEN = "session.".length();
    private static final String AUTH_USER_NAME = "auth-user-name";
    private static final String CLIENT_DNS = "client.dns";
    private static final String CLIENT_NAME = "client.name";
    private static final String COOKIE = "cookie";
    private static final String COOKIES = "cookies";
    private static final String COOKIE_VALUE = "cookie.value";
    private static final String COOKIE_BY_NAME_PREFIX = "cookie.";
    private static final int COOKIE_BY_NAME_PREFIX_LEN = "cookie.".length();
    private static final String COOKIES_BY_NAME_PREFIX = "cookies.";
    private static final int COOKIES_BY_NAME_PREFIX_LEN = "cookies.".length();
    private static final String DATE_TIME = "datetime";
    private static final String HEADER_ACCEPT = "header.accept";
    private static final String HEADER_BY_NAME_PREFIX = "header.";
    private static final int HEADER_BY_NAME_PREFIX_LEN = "header.".length();
    private static final String HEADERS_BY_NAME_PREFIX = "headers.";
    private static final int HEADERS_BY_NAME_PREFIX_LEN = "headers.".length();
    private static final String HEADER_AUTH = "header.auth";
    private static final String HEADER_DATE = "header.date";
    private static final String HEADER_IF_MOD_SINCE = "header.if-mod-since";
    private static final String HEADER_USER_AGENT = "header.user-agent";
    private static final String HEADER_REFERER = "header.referer";
    private static final String HTTP_METHOD = "http-method";
    private static final String HTTP_URI = "http-uri";
    private static final String HTTP_VERSION = "http-version";
    private static final String QUERY_STR = "query-str";
    private static final String REFERER = "referer";
    private static final String REQUEST = "request";
    private static final String RESPONSE_LENGTH = "response.length";
    private static final String STATUS = "status";
    private static final String TIME_TAKEN = "time-taken";
    private static final String USER_AGENT = "user.agent";
    private static final String VS_ID = "vs.id";
    private Container container;
    private LinkedList<String> patternComponents;

    public DefaultAccessLogFormatterImpl(String pattern, Container container) {
        this.patternComponents = this.parsePattern(pattern);
        this.container = container;
        final TimeZone timeZone = this.tz;
        this.dayFormatter = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat f = new SimpleDateFormat("dd");
                f.setTimeZone(timeZone);
                return f;
            }
        };
        this.monthFormatter = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat f = new SimpleDateFormat("MM");
                f.setTimeZone(timeZone);
                return f;
            }
        };
        this.yearFormatter = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat f = new SimpleDateFormat("yyyy");
                f.setTimeZone(timeZone);
                return f;
            }
        };
        this.timeFormatter = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss");
                f.setTimeZone(timeZone);
                return f;
            }
        };
    }

    @Override
    public void appendLogEntry(Request request, Response response, CharBuffer charBuffer) {
        ServletRequest req = request.getRequest();
        HttpServletRequest hreq = (HttpServletRequest)req;
        for (int i = 0; i < this.patternComponents.size(); ++i) {
            String pc = this.patternComponents.get(i);
            if (pc.startsWith(ATTRIBUTE_BY_NAME_PREFIX)) {
                this.appendAttributeByName(charBuffer, pc.substring(ATTRIBUTE_BY_NAME_PREFIX_LEN), hreq);
            } else if (pc.startsWith(SESSION_ATTRIBUTE_BY_NAME_PREFIX)) {
                this.appendSessionAttributeByName(charBuffer, pc.substring(SESSION_ATTRIBUTE_BY_NAME_PREFIX_LEN), hreq);
            } else if (AUTH_USER_NAME.equals(pc)) {
                this.appendAuthUserName(charBuffer, hreq);
            } else if (CLIENT_DNS.equals(pc)) {
                this.appendClientDNS(charBuffer, req);
            } else if (CLIENT_NAME.equals(pc)) {
                this.appendClientName(charBuffer, req);
            } else if (COOKIE.equals(pc)) {
                this.appendCookie(charBuffer, hreq);
            } else if (COOKIES.equals(pc)) {
                this.appendCookies(charBuffer, hreq);
            } else if (COOKIE_VALUE.equals(pc)) {
                this.appendCookieValue(charBuffer, hreq);
            } else if (pc.startsWith(COOKIE_BY_NAME_PREFIX)) {
                this.appendCookieByName(charBuffer, pc.substring(COOKIE_BY_NAME_PREFIX_LEN), hreq);
            } else if (pc.startsWith(COOKIES_BY_NAME_PREFIX)) {
                this.appendCookiesByName(charBuffer, pc.substring(COOKIES_BY_NAME_PREFIX_LEN), hreq);
            } else if (DATE_TIME.equals(pc)) {
                this.appendCurrentDate(charBuffer);
            } else if (HEADER_ACCEPT.equals(pc)) {
                this.appendHeaderAccept(charBuffer, hreq);
            } else if (HEADER_AUTH.equals(pc)) {
                this.appendHeaderAuth(charBuffer, hreq);
            } else if (HEADER_DATE.equals(pc)) {
                this.appendHeaderDate(charBuffer, hreq);
            } else if (HEADER_IF_MOD_SINCE.equals(pc)) {
                this.appendHeaderIfModSince(charBuffer, hreq);
            } else if (HEADER_USER_AGENT.equals(pc)) {
                this.appendUserAgent(charBuffer, hreq);
            } else if (HEADER_REFERER.equals(pc)) {
                this.appendReferer(charBuffer, hreq);
            } else if (HTTP_METHOD.equals(pc)) {
                this.appendHTTPMethod(charBuffer, hreq);
            } else if (HTTP_URI.equals(pc)) {
                this.appendHTTPUri(charBuffer, hreq);
            } else if (HTTP_VERSION.equals(pc)) {
                this.appendHTTPVersion(charBuffer, hreq);
            } else if (QUERY_STR.equals(pc)) {
                this.appendQueryString(charBuffer, hreq);
            } else if (REFERER.equals(pc)) {
                this.appendReferer(charBuffer, hreq);
            } else if (REQUEST.equals(pc)) {
                this.appendRequestInfo(charBuffer, hreq);
            } else if (RESPONSE_LENGTH.equals(pc)) {
                this.appendResponseLength(charBuffer, response);
            } else if (STATUS.equals(pc)) {
                this.appendResponseStatus(charBuffer, response);
            } else if (TIME_TAKEN.equals(pc)) {
                this.appendTimeTaken(charBuffer, request);
            } else if (USER_AGENT.equals(pc)) {
                this.appendUserAgent(charBuffer, hreq);
            } else if (VS_ID.equals(pc)) {
                this.appendVirtualServerId(charBuffer);
            } else if (pc.startsWith(HEADER_BY_NAME_PREFIX)) {
                this.appendHeaderByName(charBuffer, pc.substring(HEADER_BY_NAME_PREFIX_LEN), hreq);
            } else if (pc.startsWith(HEADERS_BY_NAME_PREFIX)) {
                this.appendHeadersByName(charBuffer, pc.substring(HEADERS_BY_NAME_PREFIX_LEN), hreq);
            }
            charBuffer.put(" ");
        }
    }

    private LinkedList<String> parsePattern(String pattern) {
        LinkedList<String> list = new LinkedList<String>();
        int from = 0;
        int end = -1;
        int index = -1;
        if (pattern == null || pattern.indexOf(37) < 0) {
            _logger.log(Level.SEVERE, "peaccesslogvalve.invalidAccessLogPattern", pattern);
        }
        while ((index = pattern.indexOf(37, from)) >= 0) {
            String component;
            end = pattern.indexOf(37, index + 1);
            if (end < 0) {
                _logger.log(Level.SEVERE, "peaccesslogvalve.missingAccessLogPatternEndDelimiter", pattern);
            }
            if (!((component = pattern.substring(index + 1, end)).startsWith(ATTRIBUTE_BY_NAME_PREFIX) || AUTH_USER_NAME.equals(component) || CLIENT_DNS.equals(component) || CLIENT_NAME.equals(component) || COOKIE.equals(component) || COOKIES.equals(component) || COOKIE_VALUE.equals(component) || component.startsWith(COOKIE_BY_NAME_PREFIX) || component.startsWith(COOKIES_BY_NAME_PREFIX) || DATE_TIME.equals(component) || HEADER_ACCEPT.equals(component) || HEADER_AUTH.equals(component) || HEADER_DATE.equals(component) || HEADER_IF_MOD_SINCE.equals(component) || HEADER_USER_AGENT.equals(component) || HEADER_REFERER.equals(component) || HTTP_METHOD.equals(component) || HTTP_URI.equals(component) || HTTP_VERSION.equals(component) || QUERY_STR.equals(component) || REFERER.equals(component) || REQUEST.equals(component) || RESPONSE_LENGTH.equals(component) || STATUS.equals(component) || TIME_TAKEN.equals(component) || USER_AGENT.equals(component) || VS_ID.equals(component) || component.startsWith(HEADER_BY_NAME_PREFIX) || component.startsWith(HEADERS_BY_NAME_PREFIX))) {
                _logger.log(Level.SEVERE, "peaccesslogvalve.invalidAccessLogPatternComponent", new Object[]{component, pattern});
            }
            if (TIME_TAKEN.equals(component)) {
                this.needTimeTaken = true;
            }
            list.add(component);
            from = end + 1;
        }
        return list;
    }

    private void appendAttributeByName(CharBuffer cb, String attributeName, HttpServletRequest hreq) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Null request attribute name");
        }
        cb.put(QUOTE);
        Object attrValue = hreq.getAttribute(attributeName);
        if (attrValue != null) {
            cb.put(attrValue.toString());
        } else {
            cb.put("NULL-ATTRIBUTE-" + attributeName.toUpperCase());
        }
        cb.put(QUOTE);
    }

    private void appendSessionAttributeByName(CharBuffer cb, String attributeName, HttpServletRequest hreq) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Null session attribute name");
        }
        cb.put(QUOTE);
        HttpSession session = hreq.getSession(false);
        if (session != null) {
            Object attrValue = session.getAttribute(attributeName);
            if (attrValue != null) {
                cb.put(attrValue.toString());
            } else {
                cb.put("NULL-SESSION-ATTRIBUTE-" + attributeName.toUpperCase());
            }
        } else {
            cb.put("NULL-SESSION");
        }
        cb.put(QUOTE);
    }

    private void appendClientName(CharBuffer cb, ServletRequest req) {
        cb.put(QUOTE);
        String value = req.getRemoteHost();
        if (value == null) {
            value = "NULL-CLIENT-NAME";
        }
        cb.put(value);
        cb.put(QUOTE);
    }

    private void appendClientDNS(CharBuffer cb, ServletRequest req) {
        cb.put(QUOTE);
        String value = req.getRemoteAddr();
        if (value == null) {
            value = "NULL-CLIENT-DNS";
        }
        cb.put(value);
        cb.put(QUOTE);
    }

    private void appendAuthUserName(CharBuffer cb, HttpServletRequest hreq) {
        cb.put(QUOTE);
        String user = hreq.getRemoteUser();
        if (user == null) {
            user = "NULL-AUTH-USER";
        }
        cb.put(user);
        cb.put(QUOTE);
    }

    private void appendCurrentDate(CharBuffer cb) {
        cb.put(QUOTE);
        Date date = this.getDate();
        cb.put(((SimpleDateFormat)this.dayFormatter.get()).format(date));
        cb.put('/');
        cb.put(this.lookup(((SimpleDateFormat)this.monthFormatter.get()).format(date)));
        cb.put('/');
        cb.put(((SimpleDateFormat)this.yearFormatter.get()).format(date));
        cb.put(':');
        cb.put(((SimpleDateFormat)this.timeFormatter.get()).format(date));
        cb.put(" ");
        cb.put(this.timeZone);
        cb.put(QUOTE);
    }

    private void appendRequestInfo(CharBuffer cb, HttpServletRequest hreq) {
        cb.put(QUOTE);
        cb.put(hreq.getMethod());
        cb.put(" ");
        cb.put(hreq.getRequestURI());
        if (hreq.getQueryString() != null) {
            cb.put('?');
            cb.put(hreq.getQueryString());
        }
        cb.put(" ");
        cb.put(hreq.getProtocol());
        cb.put(QUOTE);
    }

    private void appendResponseStatus(CharBuffer cb, Response response) {
        cb.put(String.valueOf(((HttpResponse)response).getStatus()));
    }

    private void appendResponseLength(CharBuffer cb, Response response) {
        cb.put("" + response.getContentCount());
    }

    private void appendUserAgent(CharBuffer cb, HttpServletRequest hreq) {
        cb.put(QUOTE);
        String ua = hreq.getHeader("user-agent");
        if (ua == null) {
            ua = "NULL-USER-AGENT";
        }
        cb.put(ua);
        cb.put(QUOTE);
    }

    private void appendTimeTaken(CharBuffer cb, Request req) {
        String timeTaken = "NULL-TIME-TAKEN";
        cb.put(QUOTE);
        Long startTimeObj = (Long)req.getNote("com.sun.enterprise.web.request.startTime");
        if (startTimeObj != null) {
            long startTime = startTimeObj;
            long endTime = System.currentTimeMillis();
            timeTaken = String.valueOf(endTime - startTime);
        }
        cb.put(timeTaken);
        cb.put(QUOTE);
    }

    private void appendReferer(CharBuffer cb, HttpServletRequest hreq) {
        cb.put(QUOTE);
        String referer = hreq.getHeader(REFERER);
        if (referer == null) {
            referer = "NULL-REFERER";
        }
        cb.put(referer);
        cb.put(QUOTE);
    }

    private void appendHeaderAccept(CharBuffer cb, HttpServletRequest hreq) {
        cb.put(QUOTE);
        String accept = hreq.getHeader(HTTP_HEADER_ACCEPT);
        if (accept == null) {
            accept = "NULL-HEADER-ACCEPT";
        }
        cb.put(accept);
        cb.put(QUOTE);
    }

    private void appendHeaderAuth(CharBuffer cb, HttpServletRequest hreq) {
        cb.put(QUOTE);
        String auth = hreq.getHeader(HTTP_HEADER_AUTHORIZATION);
        if (auth == null) {
            auth = "NULL-HEADER-AUTHORIZATION";
        }
        cb.put(auth);
        cb.put(QUOTE);
    }

    private void appendHeaderDate(CharBuffer cb, HttpServletRequest hreq) {
        cb.put(QUOTE);
        String date = hreq.getHeader(HTTP_HEADER_DATE);
        if (date == null) {
            date = "NULL-HEADER-DATE";
        }
        cb.put(date);
        cb.put(QUOTE);
    }

    private void appendHeaderIfModSince(CharBuffer cb, HttpServletRequest hreq) {
        cb.put(QUOTE);
        String ifModSince = hreq.getHeader(HTTP_HEADER_IF_MODIFIED_SINCE);
        if (ifModSince == null) {
            ifModSince = "NULL-HEADER-IF-MODIFIED-SINCE";
        }
        cb.put(ifModSince);
        cb.put(QUOTE);
    }

    private void appendHeaderByName(CharBuffer cb, String headerName, HttpServletRequest hreq) {
        if (headerName == null) {
            throw new IllegalArgumentException("Null request header name");
        }
        cb.put(QUOTE);
        String value = hreq.getHeader(headerName);
        if (value == null) {
            value = "NULL-HEADER-" + headerName.toUpperCase();
        }
        cb.put(value);
        cb.put(QUOTE);
    }

    private void appendHeadersByName(CharBuffer cb, String headerName, HttpServletRequest hreq) {
        if (headerName == null) {
            throw new IllegalArgumentException("Null request header name");
        }
        cb.put(QUOTE);
        Enumeration<String> e = hreq.getHeaders(headerName);
        if (e != null) {
            boolean first = true;
            while (e.hasMoreElements()) {
                if (first) {
                    first = false;
                } else {
                    cb.put(";");
                }
                cb.put(e.nextElement().toString());
            }
            if (first) {
                cb.put("NULL-HEADERS-" + headerName.toUpperCase());
            }
        } else {
            cb.put("NULL-HEADERS-" + headerName.toUpperCase());
        }
        cb.put(QUOTE);
    }

    private void appendCookie(CharBuffer cb, HttpServletRequest hreq) {
        cb.put(QUOTE);
        String cookie = "NULL-COOKIE";
        Cookie[] cookies = hreq.getCookies();
        if (cookies != null && cookies.length > 0) {
            cookie = cookies[0].getName() + "=" + cookies[0].getValue();
        }
        cb.put(cookie);
        cb.put(QUOTE);
    }

    private void appendCookies(CharBuffer cb, HttpServletRequest hreq) {
        cb.put(QUOTE);
        Cookie[] cookies = hreq.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (int i = 0; i < cookies.length; ++i) {
                cb.put(cookies[i].getName() + "=" + cookies[i].getValue());
                if (i >= cookies.length - 1) continue;
                cb.put(";");
            }
        } else {
            cb.put("NULL-COOKIES");
        }
        cb.put(QUOTE);
    }

    private void appendCookieValue(CharBuffer cb, HttpServletRequest hreq) {
        cb.put(QUOTE);
        String cookieValue = "NULL-COOKIE-VALUE";
        Cookie[] cookies = hreq.getCookies();
        if (cookies != null && cookies.length > 0) {
            cookieValue = cookies[0].getValue();
        }
        cb.put(cookieValue);
        cb.put(QUOTE);
    }

    private void appendCookieByName(CharBuffer cb, String cookieName, HttpServletRequest hreq) {
        if (cookieName == null) {
            throw new IllegalArgumentException("Null request cookie name");
        }
        cb.put(QUOTE);
        String cookieValue = null;
        Cookie[] cookies = hreq.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                cookieValue = cookie.getValue();
                break;
            }
        }
        if (cookieValue == null) {
            cookieValue = "NULL-COOKIE-" + cookieName.toUpperCase();
        }
        cb.put(cookieValue);
        cb.put(QUOTE);
    }

    private void appendCookiesByName(CharBuffer cb, String cookieName, HttpServletRequest hreq) {
        if (cookieName == null) {
            throw new IllegalArgumentException("Null request cookie name");
        }
        cb.put(QUOTE);
        Cookie[] cookies = hreq.getCookies();
        if (cookies != null && cookies.length > 0) {
            boolean first = true;
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookieName.equals(cookies[i].getName())) continue;
                if (first) {
                    first = false;
                } else {
                    cb.put(";");
                }
                cb.put(cookies[i].getValue());
            }
        } else {
            cb.put("NULL-COOKIES-" + cookieName.toUpperCase());
        }
        cb.put(QUOTE);
    }

    private void appendHTTPMethod(CharBuffer cb, HttpServletRequest hreq) {
        cb.put(QUOTE);
        String method = hreq.getMethod();
        if (method == null) {
            method = "NULL-HTTP-METHOD";
        }
        cb.put(method);
        cb.put(QUOTE);
    }

    private void appendHTTPUri(CharBuffer cb, HttpServletRequest hreq) {
        cb.put(QUOTE);
        String uri = hreq.getRequestURI();
        if (uri == null) {
            uri = "NULL-HTTP-URI";
        }
        cb.put(uri);
        cb.put(QUOTE);
    }

    private void appendHTTPVersion(CharBuffer cb, HttpServletRequest hreq) {
        cb.put(QUOTE);
        String protocol = hreq.getProtocol();
        if (protocol == null) {
            protocol = "NULL-HTTP-PROTOCOL";
        }
        cb.put(protocol);
        cb.put(QUOTE);
    }

    private void appendQueryString(CharBuffer cb, HttpServletRequest hreq) {
        cb.put(QUOTE);
        String query = hreq.getQueryString();
        if (query == null) {
            query = "NULL-QUERY";
        }
        cb.put(query);
        cb.put(QUOTE);
    }

    private void appendVirtualServerId(CharBuffer cb) {
        String vsId = "NULL-VIRTUAL-SERVER";
        if (this.container != null) {
            vsId = this.container.getName();
        }
        cb.put(vsId);
    }
}

