/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.modelmbean.DescriptorSupport;
import org.glassfish.admin.amx.annotation.Description;
import org.glassfish.admin.amx.annotation.ManagedAttribute;
import org.glassfish.admin.amx.annotation.ManagedOperation;
import org.glassfish.admin.amx.annotation.Param;
import org.glassfish.admin.amx.base.Singleton;
import org.glassfish.admin.amx.core.AMXMBeanMetadata;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.AMX_SPI;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MBeanInfoSupport {
    private static MBeanInfo amxspiMBeanInfo = null;

    private MBeanInfoSupport() {
    }

    private static void debug(Object o) {
        System.out.println(o.toString());
    }

    public static synchronized MBeanInfo getAMX_SPIMBeanInfo() {
        if (amxspiMBeanInfo == null) {
            amxspiMBeanInfo = MBeanInfoSupport.getMBeanInfo(AMX_SPI.class);
        }
        return amxspiMBeanInfo;
    }

    public static <T extends AMX_SPI> MBeanInfo getMBeanInfo(Class<T> intf) {
        boolean supportsAdoption;
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        HashMap<String, Method> getterSetters = new HashMap<String, Method>();
        HashSet<Method> operations = new HashSet<Method>();
        MBeanInfoSupport.findInterfaceMethods(intf, getters, setters, getterSetters, operations);
        if (!AMX_SPI.class.isAssignableFrom(intf)) {
            MBeanInfoSupport.findInterfaceMethods(AMX_SPI.class, getters, setters, getterSetters, operations);
        }
        List<MBeanAttributeInfo> attrsList = MBeanInfoSupport.generateMBeanAttributeInfos(getterSetters.values(), getters.values(), setters.values());
        MBeanOperationInfo[] operationInfos = MBeanInfoSupport.generateMBeanOperationInfos(operations);
        MBeanConstructorInfo[] constructorInfos = null;
        MBeanNotificationInfo[] notificationInfos = null;
        AMXMBeanMetadata meta = intf.getAnnotation(AMXMBeanMetadata.class);
        boolean globalSingleton = meta != null && meta.globalSingleton();
        boolean singleton = Singleton.class.isAssignableFrom(intf) || globalSingleton || meta != null && meta.singleton();
        String group = "other";
        boolean isLeaf = meta != null && meta.leaf();
        boolean bl = supportsAdoption = !isLeaf;
        if (isLeaf) {
            JMXUtil.remove(attrsList, (String)"Children");
        }
        DescriptorSupport d = MBeanInfoSupport.mbeanDescriptor(true, intf, singleton, globalSingleton, "other", supportsAdoption, null);
        MBeanAttributeInfo[] attrInfos = new MBeanAttributeInfo[attrsList.size()];
        attrsList.toArray(attrInfos);
        MBeanInfo mbeanInfo = new MBeanInfo(intf.getName(), intf.getName(), attrInfos, constructorInfos, operationInfos, notificationInfos, d);
        return mbeanInfo;
    }

    public static void findInterfaceMethods(Class<?> intf, Map<String, Method> getters, Map<String, Method> setters, Map<String, Method> getterSetters, Set<Method> operations) {
        Method[] methods;
        for (Method method : methods = intf.getMethods()) {
            String methodName = method.getName();
            ManagedAttribute managedAttr = method.getAnnotation(ManagedAttribute.class);
            ManagedOperation managedOp = method.getAnnotation(ManagedOperation.class);
            if (managedAttr != null) {
                Class<?> setterType;
                String attrName = null;
                int numArgs = method.getParameterTypes().length;
                if (managedOp != null) {
                    ImplUtil.getLogger().warning("MBeanInfoSupport:  @ManagedAttribute cannot also be @ManagedOperation: " + intf.getName() + "." + method.getName() + "()");
                } else if (numArgs == 0 && JMXUtil.isIsOrGetter((Method)method)) {
                    attrName = JMXUtil.getAttributeName((Method)method);
                    getters.put(attrName, method);
                } else if (numArgs == 1 && JMXUtil.isSetter((Method)method)) {
                    attrName = JMXUtil.getAttributeName((Method)method);
                    setters.put(attrName, method);
                } else {
                    ImplUtil.getLogger().warning("MBeanInfoSupport:  @ManagedAttribute not a getter or setter: " + intf.getName() + "." + method.getName() + "()");
                }
                if (attrName == null || !getters.containsKey(attrName) || !setters.containsKey(attrName)) continue;
                Method getter = getters.get(attrName);
                Class<?> getterType = getter.getReturnType();
                if (getterType == (setterType = setters.get(attrName).getParameterTypes()[0])) {
                    getters.remove(attrName);
                    setters.remove(attrName);
                    getterSetters.put(attrName, getter);
                    continue;
                }
                throw new IllegalArgumentException("Attribute " + attrName + "has type " + getterType.getName() + " as getter but type " + setterType.getName() + " as setter");
            }
            if (managedOp == null) continue;
            operations.add(method);
        }
    }

    public static MBeanAttributeInfo attributeInfo(Method m) {
        ManagedAttribute managed = m.getAnnotation(ManagedAttribute.class);
        if (managed == null) {
            return null;
        }
        String methodName = m.getName();
        Description d = m.getAnnotation(Description.class);
        String description = d == null ? "" : d.value();
        String attrName = JMXUtil.getAttributeName((Method)m);
        boolean isGetter = JMXUtil.isGetter((Method)m);
        boolean isSetter = JMXUtil.isSetter((Method)m);
        boolean isIs = JMXUtil.isIs((Method)m);
        MBeanAttributeInfo info = new MBeanAttributeInfo(attrName, m.getReturnType().getName(), description, isGetter, isSetter, isIs, null);
        return info;
    }

    public static Class<?> translatedType(Class<?> clazz) {
        Class<Object> type = clazz;
        if (AMXProxy.class.isAssignableFrom(clazz)) {
            type = ObjectName.class;
        } else if (clazz.isArray() && AMXProxy.class.isAssignableFrom(clazz.getComponentType())) {
            type = ObjectName[].class;
        }
        return type;
    }

    private static List<MBeanAttributeInfo> generateAttributeInfos(Collection<Method> methods, boolean read, boolean write) {
        ArrayList<MBeanAttributeInfo> infos = new ArrayList<MBeanAttributeInfo>();
        for (Method m : methods) {
            String methodName = m.getName();
            String description = MBeanInfoSupport.getDescription(m);
            String attrName = JMXUtil.getAttributeName((Method)m);
            boolean isIs = JMXUtil.isIs((Method)m);
            Class<Object> returnType = m.getReturnType();
            if (AMXProxy.class.isAssignableFrom(returnType)) {
                returnType = ObjectName.class;
            }
            MBeanAttributeInfo info = new MBeanAttributeInfo(attrName, MBeanInfoSupport.translatedType(m.getReturnType()).getName(), description, read, write, JMXUtil.isIs((Method)m));
            infos.add(info);
        }
        return infos;
    }

    public static List<MBeanAttributeInfo> generateMBeanAttributeInfos(Collection<Method> getterSetters, Collection<Method> getters, Collection<Method> setters) {
        ArrayList<MBeanAttributeInfo> attrsList = new ArrayList<MBeanAttributeInfo>();
        attrsList.addAll(MBeanInfoSupport.generateAttributeInfos(getterSetters, true, true));
        attrsList.addAll(MBeanInfoSupport.generateAttributeInfos(getters, true, false));
        attrsList.addAll(MBeanInfoSupport.generateAttributeInfos(setters, false, true));
        return attrsList;
    }

    public static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> clazz) {
        Annotation result = null;
        for (Annotation a : annotations) {
            if (a.annotationType() != clazz) continue;
            result = a;
            break;
        }
        return (T)result;
    }

    private static String getDescription(AnnotatedElement o) {
        Description d = o.getAnnotation(Description.class);
        return d == null ? "" : d.value();
    }

    public static MBeanParameterInfo[] parameterInfos(Method method) {
        Class<?>[] sig = method.getParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        MBeanParameterInfo[] infos = new MBeanParameterInfo[sig.length];
        for (int i = 0; i < sig.length; ++i) {
            MBeanParameterInfo info;
            Class<?> paramClass = MBeanInfoSupport.translatedType(sig[i]);
            Annotation[] annotations = paramAnnotations[i];
            Param p = MBeanInfoSupport.getAnnotation(annotations, Param.class);
            String paramName = p == null || p.name().length() == 0 ? "p" + i : p.name();
            Description d = MBeanInfoSupport.getAnnotation(annotations, Description.class);
            String description = "";
            if (d != null && d.value().length() != 0) {
                description = d.value();
            }
            String type = paramClass.getName();
            infos[i] = info = new MBeanParameterInfo(paramName, type, description);
        }
        return infos;
    }

    public static MBeanOperationInfo[] generateMBeanOperationInfos(Collection<Method> methods) {
        MBeanOperationInfo[] infos = new MBeanOperationInfo[methods.size()];
        int i = 0;
        for (Method m : methods) {
            MBeanOperationInfo info;
            ManagedOperation managed = m.getAnnotation(ManagedOperation.class);
            String methodName = m.getName();
            MBeanParameterInfo[] parameterInfos = MBeanInfoSupport.parameterInfos(m);
            int impact = managed == null ? 3 : managed.impact();
            String description = MBeanInfoSupport.getDescription(m);
            Descriptor descriptor = null;
            infos[i] = info = new MBeanOperationInfo(methodName, description, parameterInfos, MBeanInfoSupport.translatedType(m.getReturnType()).getName(), impact, descriptor);
            ++i;
        }
        return infos;
    }

    public static DescriptorSupport mbeanDescriptor(boolean immutable, Class<?> intf, boolean singleton, boolean globalSingleton, String group, boolean supportsAdoption, String[] subTypes) {
        DescriptorSupport desc = new DescriptorSupport();
        if (intf == null || !intf.isInterface()) {
            throw new IllegalArgumentException("interface class must be an interface");
        }
        desc.setField("immutableInfo", immutable);
        desc.setField("interfaceName", intf.getName());
        desc.setField("amx.isSingleton", singleton);
        desc.setField("amx.isGlobalSingleton", globalSingleton);
        desc.setField("amx.group", group);
        desc.setField("amx.supportsAdoption", supportsAdoption);
        if (subTypes != null) {
            desc.setField("amx.subTypes", subTypes);
        }
        return desc;
    }
}

