/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.connectors.util.ConnectionPoolReconfigHelper;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public final class ConnectorDescriptorInfo
implements Serializable {
    protected String rarName_;
    protected String resourceAdapterClass_;
    protected String connectionDefinitionName_;
    protected String managedConnectionFactoryClass_;
    protected String connectionFactoryClass_;
    protected String connectionFactoryInterface_;
    protected String connectionClass_;
    protected String connectionInterface_;
    protected Set<ConnectorConfigProperty> mcfConfigProperties_ = new HashSet<ConnectorConfigProperty>();
    protected Set<ConnectorConfigProperty> resourceAdapterConfigProperties_ = new HashSet<ConnectorConfigProperty>();

    public ConnectorDescriptorInfo() {
    }

    public ConnectorDescriptorInfo doClone() {
        ConnectorDescriptorInfo cdi = new ConnectorDescriptorInfo();
        cdi.setMCFConfigProperties(this.mcfConfigProperties_);
        cdi.setResourceAdapterConfigProperties(this.resourceAdapterConfigProperties_);
        cdi.setRarName(this.rarName_);
        cdi.setResourceAdapterClassName(this.resourceAdapterClass_);
        cdi.setConnectionDefinitionName(this.connectionDefinitionName_);
        cdi.setManagedConnectionFactoryClass(this.managedConnectionFactoryClass_);
        cdi.setConnectionFactoryClass(this.connectionFactoryClass_);
        cdi.setConnectionFactoryInterface(this.connectionFactoryInterface_);
        cdi.setConnectionClass(this.connectionClass_);
        cdi.setConnectionInterface(this.connectionInterface_);
        return cdi;
    }

    public ConnectorDescriptorInfo(ConnectorConfigProperty[] mcfConfigProperties, ConnectorConfigProperty[] resourceAdapterConfigProperties) {
        this();
        if (mcfConfigProperties != null) {
            for (ConnectorConfigProperty mcfConfigProperty : mcfConfigProperties) {
                this.mcfConfigProperties_.add(mcfConfigProperty);
            }
            if (resourceAdapterConfigProperties != null) {
                for (ConnectorConfigProperty mcfConfigProperty : mcfConfigProperties) {
                    this.resourceAdapterConfigProperties_.add(mcfConfigProperty);
                }
            }
        }
    }

    public void addMCFConfigProperty(ConnectorConfigProperty configProperty) {
        if (configProperty != null) {
            this.mcfConfigProperties_.add(configProperty);
        }
    }

    public void removeMCFConfigProperty(ConnectorConfigProperty configProperty) {
        if (configProperty != null) {
            this.mcfConfigProperties_.remove(configProperty);
        }
    }

    public void setMCFConfigProperties(Set configProperties) {
        this.mcfConfigProperties_ = configProperties;
    }

    public void setMCFConfigProperties(ConnectorConfigProperty[] configProperties) {
        if (configProperties != null) {
            for (int i = 0; i < configProperties.length; ++i) {
                this.mcfConfigProperties_.add(configProperties[i]);
            }
        }
    }

    public Set getMCFConfigProperties() {
        return this.mcfConfigProperties_;
    }

    public void addResourceAdapterConfigProperty(ConnectorConfigProperty configProperty) {
        if (configProperty != null) {
            this.resourceAdapterConfigProperties_.add(configProperty);
        }
    }

    public void removeResourceAdapterConfigProperty(ConnectorConfigProperty configProperty) {
        if (configProperty != null) {
            this.resourceAdapterConfigProperties_.remove(configProperty);
        }
    }

    public void setResourceAdapterConfigProperties(Set configProperties) {
        this.resourceAdapterConfigProperties_ = configProperties;
    }

    public void setResourceAdapterConfigProperties(ConnectorConfigProperty[] configProperties) {
        if (configProperties != null) {
            for (ConnectorConfigProperty configProperty : configProperties) {
                this.resourceAdapterConfigProperties_.add(configProperty);
            }
        }
    }

    public Set getResourceAdapterConfigProperties() {
        return this.resourceAdapterConfigProperties_;
    }

    public String getRarName() {
        return this.rarName_;
    }

    public void setRarName(String rarName) {
        this.rarName_ = rarName;
    }

    public String getResourceAdapterClassName() {
        return this.resourceAdapterClass_;
    }

    public void setResourceAdapterClassName(String resourceAdapterClass) {
        this.resourceAdapterClass_ = resourceAdapterClass;
    }

    public String getConnectionDefinitionName() {
        return this.connectionDefinitionName_;
    }

    public void setConnectionDefinitionName(String connectionDefinitionName) {
        this.connectionDefinitionName_ = connectionDefinitionName;
    }

    public String getManagedConnectionFactoryClass() {
        return this.managedConnectionFactoryClass_;
    }

    public void setManagedConnectionFactoryClass(String managedConnectionFactoryClass) {
        this.managedConnectionFactoryClass_ = managedConnectionFactoryClass;
    }

    public String getConnectionFactoryClass() {
        return this.connectionFactoryClass_;
    }

    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.connectionFactoryClass_ = connectionFactoryClass;
    }

    public String getConnectionFactoryInterface() {
        return this.connectionFactoryInterface_;
    }

    public void setConnectionFactoryInterface(String connectionFactoryInterface) {
        this.connectionFactoryInterface_ = connectionFactoryInterface;
    }

    public String getConnectionClass() {
        return this.connectionClass_;
    }

    public void setConnectionClass(String connectionClass) {
        this.connectionClass_ = connectionClass;
    }

    public String getConnectionInterface() {
        return this.connectionInterface_;
    }

    public void setConnectionInterface(String connectionInterface) {
        this.connectionInterface_ = connectionInterface;
    }

    public ConnectionPoolReconfigHelper.ReconfigAction compareMCFConfigProperties(ConnectorDescriptorInfo cdi) {
        return this.compareMCFConfigProperties(cdi, new HashSet());
    }

    public ConnectionPoolReconfigHelper.ReconfigAction compareMCFConfigProperties(ConnectorDescriptorInfo cdi, Set excluded) {
        Set mcfConfigProps = cdi.getMCFConfigProperties();
        if (mcfConfigProps.size() != this.mcfConfigProperties_.size()) {
            return ConnectionPoolReconfigHelper.ReconfigAction.RECREATE_POOL;
        }
        boolean same = false;
        for (Object mcfConfigProp : mcfConfigProps) {
            ConnectorConfigProperty prop = (ConnectorConfigProperty)mcfConfigProp;
            if (excluded.contains(prop.getName())) continue;
            for (ConnectorConfigProperty property : this.mcfConfigProperties_) {
                if (!this.isEnvPropEqual(prop, property)) continue;
                same = true;
                break;
            }
            if (!same) {
                return ConnectionPoolReconfigHelper.ReconfigAction.RECREATE_POOL;
            }
            same = false;
        }
        return ConnectionPoolReconfigHelper.ReconfigAction.NO_OP;
    }

    private boolean isEnvPropEqual(ConnectorConfigProperty e1, ConnectorConfigProperty e2) {
        return e1 != null && e2 != null && e1.getName() != null && e2.getName() != null && e1.getName().equals(e2.getName()) && e1.getValue() != null && e2.getValue() != null && e1.getValue().equals(e2.getValue());
    }
}

