/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentArguments {
    private static final String AGENT_ARG_PATTERN = "(?:([^=,]*?)=)?((?:\"([^\"]*)\")|[^,]+)";
    private static final int KEYWORD = 1;
    private static final int QUOTED = 2;
    private static final int UNQUOTED = 3;
    private static Pattern agentArgPattern = Pattern.compile("(?:([^=,]*?)=)?((?:\"([^\"]*)\")|[^,]+)", 32);
    private final Properties namedValues = new Properties();
    private final List<String> anonValues = new ArrayList<String>();

    public static AgentArguments newInstance(String args) {
        AgentArguments result = new AgentArguments();
        result.scan(args);
        return result;
    }

    public Properties namedValues() {
        return this.namedValues;
    }

    public List<String> unnamedValues() {
        return this.anonValues;
    }

    private void scan(String args) {
        if (args == null) {
            return;
        }
        Matcher m = agentArgPattern.matcher(args);
        while (m.find()) {
            String value;
            String keyword = m.group(1);
            String string = value = m.group(2) != null ? m.group(2) : m.group(3);
            if (keyword != null) {
                this.namedValues.setProperty(keyword, value);
                continue;
            }
            this.anonValues.add(value);
        }
    }
}

