/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.spi.transport.MessageTraceManager;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MessageTraceManagerImpl
implements MessageTraceManager {
    private List dataSent;
    private List dataReceived;
    private boolean enabled;
    private boolean RHRCalled;
    private byte[] header;

    public MessageTraceManagerImpl() {
        this.init();
        this.enabled = false;
    }

    @Override
    public void clear() {
        this.init();
    }

    private void init() {
        this.dataSent = new ArrayList();
        this.dataReceived = new ArrayList();
        this.initHeaderRecorder();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void enable(boolean flag) {
        this.enabled = flag;
    }

    @Override
    public byte[][] getDataSent() {
        return (byte[][])this.dataSent.toArray((T[])new byte[this.dataSent.size()][]);
    }

    @Override
    public byte[][] getDataReceived() {
        return (byte[][])this.dataReceived.toArray((T[])new byte[this.dataReceived.size()][]);
    }

    private void initHeaderRecorder() {
        this.RHRCalled = false;
        this.header = null;
    }

    public byte[] getBytes(ByteBuffer bb, int offset) {
        ByteBuffer view = bb.asReadOnlyBuffer();
        view.flip();
        int len = view.remaining();
        byte[] buffer = new byte[len + offset];
        view.get(buffer, offset, len);
        return buffer;
    }

    public void recordDataSent(ByteBuffer message) {
        byte[] buffer = this.getBytes(message, 0);
        this.dataSent.add(buffer);
    }

    public void recordHeaderReceived(ByteBuffer message) {
        if (this.RHRCalled) {
            this.dataReceived.add(this.header);
            this.initHeaderRecorder();
        }
        this.RHRCalled = true;
        this.header = this.getBytes(message, 0);
    }

    public void recordBodyReceived(ByteBuffer message) {
        if (!this.RHRCalled) {
            this.header = "NO HEADER!!!".getBytes();
        }
        byte[] buffer = this.getBytes(message, this.header.length);
        System.arraycopy(this.header, 0, buffer, this.header.length, message.remaining());
        this.dataReceived.add(buffer);
        this.initHeaderRecorder();
    }
}

