/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.encoding.BufferManagerRead;
import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.oa.poa.Policies;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message_1_2;
import com.sun.corba.ee.impl.transport.BufferConnectionImpl;
import com.sun.corba.ee.impl.transport.CorbaInboundConnectionCacheImpl;
import com.sun.corba.ee.impl.transport.CorbaOutboundConnectionCacheImpl;
import com.sun.corba.ee.impl.transport.MessageTraceManagerImpl;
import com.sun.corba.ee.impl.transport.SelectorImpl;
import com.sun.corba.ee.spi.ior.IORTemplate;
import com.sun.corba.ee.spi.ior.ObjectAdapterId;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.ByteBufferPool;
import com.sun.corba.ee.spi.transport.CorbaAcceptor;
import com.sun.corba.ee.spi.transport.CorbaContactInfo;
import com.sun.corba.ee.spi.transport.CorbaInboundConnectionCache;
import com.sun.corba.ee.spi.transport.CorbaOutboundConnectionCache;
import com.sun.corba.ee.spi.transport.CorbaTransportManager;
import com.sun.corba.ee.spi.transport.MessageData;
import com.sun.corba.ee.spi.transport.MessageTraceManager;
import com.sun.corba.ee.spi.transport.Selector;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.omg.CORBA.portable.InputStream;

public class CorbaTransportManagerImpl
implements CorbaTransportManager {
    protected ORB orb;
    protected List<CorbaAcceptor> acceptors;
    protected Map<String, CorbaOutboundConnectionCache> outboundConnectionCaches;
    protected Map<String, CorbaInboundConnectionCache> inboundConnectionCaches;
    protected Selector selector;
    private ThreadLocal currentMessageTraceManager = new ThreadLocal(){

        public Object initialValue() {
            return new MessageTraceManagerImpl();
        }
    };

    public CorbaTransportManagerImpl(ORB orb) {
        this.orb = orb;
        this.acceptors = new ArrayList<CorbaAcceptor>();
        this.outboundConnectionCaches = new HashMap<String, CorbaOutboundConnectionCache>();
        this.inboundConnectionCaches = new HashMap<String, CorbaInboundConnectionCache>();
        this.selector = new SelectorImpl(orb);
        orb.mom().register((Object)orb, (Object)this);
    }

    @Override
    public ByteBufferPool getByteBufferPool(int id) {
        throw new RuntimeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CorbaOutboundConnectionCache getOutboundConnectionCache(CorbaContactInfo contactInfo) {
        CorbaContactInfo corbaContactInfo = contactInfo;
        synchronized (corbaContactInfo) {
            if (contactInfo.getConnectionCache() == null) {
                CorbaOutboundConnectionCache connectionCache = null;
                Map<String, CorbaOutboundConnectionCache> map = this.outboundConnectionCaches;
                synchronized (map) {
                    connectionCache = this.outboundConnectionCaches.get(contactInfo.getConnectionCacheType());
                    if (connectionCache == null) {
                        connectionCache = new CorbaOutboundConnectionCacheImpl(this.orb, contactInfo);
                        this.orb.mom().register((Object)this, (Object)connectionCache);
                        StatsProviderManager.register((String)"orb", (PluginPoint)PluginPoint.SERVER, (String)"orb/transport/connectioncache/outbound", (Object)connectionCache);
                        this.outboundConnectionCaches.put(contactInfo.getConnectionCacheType(), connectionCache);
                    }
                }
                contactInfo.setConnectionCache(connectionCache);
            }
            return contactInfo.getConnectionCache();
        }
    }

    @Override
    public Collection<CorbaOutboundConnectionCache> getOutboundConnectionCaches() {
        return this.outboundConnectionCaches.values();
    }

    @Override
    public Collection<CorbaInboundConnectionCache> getInboundConnectionCaches() {
        return this.inboundConnectionCaches.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CorbaInboundConnectionCache getInboundConnectionCache(CorbaAcceptor acceptor) {
        CorbaAcceptor corbaAcceptor = acceptor;
        synchronized (corbaAcceptor) {
            if (acceptor.getConnectionCache() == null) {
                CorbaInboundConnectionCache connectionCache = null;
                Map<String, CorbaInboundConnectionCache> map = this.inboundConnectionCaches;
                synchronized (map) {
                    connectionCache = this.inboundConnectionCaches.get(acceptor.getConnectionCacheType());
                    if (connectionCache == null) {
                        connectionCache = new CorbaInboundConnectionCacheImpl(this.orb, acceptor);
                        this.orb.mom().register((Object)this, (Object)connectionCache);
                        StatsProviderManager.register((String)"orb", (PluginPoint)PluginPoint.SERVER, (String)"orb/transport/connectioncache/inbound", (Object)connectionCache);
                        this.inboundConnectionCaches.put(acceptor.getConnectionCacheType(), connectionCache);
                    }
                }
                acceptor.setConnectionCache(connectionCache);
            }
            return acceptor.getConnectionCache();
        }
    }

    @Override
    public Selector getSelector() {
        return this.selector;
    }

    @Override
    public Selector getSelector(int id) {
        return this.selector;
    }

    @Override
    public synchronized void registerAcceptor(CorbaAcceptor acceptor) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerAcceptor->: " + acceptor);
        }
        this.acceptors.add(acceptor);
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerAcceptor<-: " + acceptor);
        }
    }

    @Override
    public synchronized void unregisterAcceptor(CorbaAcceptor acceptor) {
        this.acceptors.remove(acceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close->");
            }
            for (CorbaOutboundConnectionCache corbaOutboundConnectionCache : this.outboundConnectionCaches.values()) {
                StatsProviderManager.unregister((Object)corbaOutboundConnectionCache);
                corbaOutboundConnectionCache.close();
            }
            for (CorbaInboundConnectionCache corbaInboundConnectionCache : this.inboundConnectionCaches.values()) {
                StatsProviderManager.unregister((Object)corbaInboundConnectionCache);
                corbaInboundConnectionCache.close();
            }
            this.getSelector(0).close();
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close<-");
            }
        }
    }

    @Override
    public Collection<CorbaAcceptor> getAcceptors() {
        return this.getAcceptors(null, null);
    }

    @Override
    public Collection<CorbaAcceptor> getAcceptors(String objectAdapterManagerId, ObjectAdapterId objectAdapterId) {
        for (CorbaAcceptor acc : this.acceptors) {
            if (!acc.initialize() || !acc.shouldRegisterAcceptEvent()) continue;
            this.orb.getTransportManager().getSelector(0).registerForEvent(acc.getEventHandler());
        }
        return this.acceptors;
    }

    @Override
    public void addToIORTemplate(IORTemplate iorTemplate, Policies policies, String codebase, String objectAdapterManagerId, ObjectAdapterId objectAdapterId) {
        for (CorbaAcceptor acceptor : this.getAcceptors(objectAdapterManagerId, objectAdapterId)) {
            acceptor.addToIORTemplate(iorTemplate, policies, codebase);
        }
    }

    @Override
    public Message getMessage(byte[] data) {
        BufferConnectionImpl connection = new BufferConnectionImpl(this.orb);
        ByteBuffer bb = ByteBuffer.allocate(data.length);
        bb.put(data);
        bb.position(0);
        try {
            connection.write(bb);
        }
        catch (IOException exc) {
            // empty catch block
        }
        MessageBase msg = MessageBase.readGIOPMessage(this.orb, connection);
        if (msg.getGIOPVersion().equals(GIOPVersion.V1_2)) {
            ((Message_1_2)msg).unmarshalRequestID(msg.getByteBuffer());
        }
        return msg;
    }

    @Override
    public MessageData getMessageData(byte[][] data) {
        BufferConnectionImpl connection = new BufferConnectionImpl(this.orb);
        for (int ctr = 0; ctr < data.length; ++ctr) {
            byte[] message = data[ctr];
            ByteBuffer bb = ByteBuffer.allocate(message.length);
            bb.put(message);
            bb.position(0);
            try {
                connection.write(bb);
                continue;
            }
            catch (IOException exc) {
                // empty catch block
            }
        }
        final Message[] messages = new Message[data.length];
        boolean requestID = false;
        Message firstMessage = null;
        MessageBase msg = null;
        CDRInputObject inobj = null;
        BufferManagerRead buffman = null;
        for (int ctr = 0; ctr < data.length; ++ctr) {
            msg = MessageBase.readGIOPMessage(this.orb, connection);
            messages[ctr] = msg;
            if (msg.getGIOPVersion().equals(GIOPVersion.V1_2)) {
                ((Message_1_2)msg).unmarshalRequestID(msg.getByteBuffer());
            }
            if (ctr == 0) {
                firstMessage = msg;
                inobj = new CDRInputObject(this.orb, connection, msg.getByteBuffer(), msg);
                buffman = inobj.getBufferManager();
                inobj.performORBVersionSpecificInit();
                continue;
            }
            buffman.processFragment(msg.getByteBuffer(), (FragmentMessage)((Object)msg));
        }
        firstMessage.read((InputStream)inobj);
        final CDRInputObject resultObj = inobj;
        return new MessageData(){

            @Override
            public Message[] getMessages() {
                return messages;
            }

            @Override
            public CDRInputObject getStream() {
                return resultObj;
            }
        };
    }

    @Override
    public MessageTraceManager getMessageTraceManager() {
        return (MessageTraceManager)this.currentMessageTraceManager.get();
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaTransportManagerImpl", msg);
    }
}

