/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil;

import com.sun.corba.ee.impl.corba.CORBAObjectImpl;
import com.sun.corba.ee.impl.io.ValueHandlerImpl;
import com.sun.corba.ee.impl.ior.iiop.JavaSerializationComponent;
import com.sun.corba.ee.impl.javax.rmi.CORBA.Util;
import com.sun.corba.ee.impl.logging.OMGSystemException;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBVersion;
import com.sun.corba.ee.spi.orb.ORBVersionFactory;
import com.sun.corba.ee.spi.orbutil.ORBClassLoader;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import com.sun.corba.ee.spi.protocol.CorbaClientDelegate;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.rmi.CORBA.ValueHandler;
import javax.rmi.CORBA.ValueHandlerMultiFormat;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Object;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public final class ORBUtility {
    private static final ThreadLocal<LinkedList<Byte>> encVersionThreadLocal = new ThreadLocal<LinkedList<Byte>>(){

        @Override
        protected LinkedList<Byte> initialValue() {
            return new LinkedList<Byte>();
        }
    };
    private static ORBUtilSystemException wrapper = ORB.getStaticLogWrapperTable().get_UTIL_ORBUtil();
    private static OMGSystemException omgWrapper = ORB.getStaticLogWrapperTable().get_UTIL_OMG();
    private static StructMember[] members = null;
    private static ValueHandler vhandler = new ValueHandlerImpl();
    private static final Hashtable exceptionClassNames = new Hashtable();
    private static final Hashtable exceptionRepositoryIds = new Hashtable();

    public static SocketChannel openSocketChannel(SocketAddress sa) throws IOException {
        SocketChannel sc = SocketChannel.open();
        try {
            sc.connect(sa);
            return sc;
        }
        catch (IOException exc) {
            try {
                sc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw exc;
        }
    }

    public static void pushEncVersionToThreadLocalState(byte value) {
        LinkedList<Byte> stack = encVersionThreadLocal.get();
        stack.addLast(value);
    }

    public static void popEncVersionFromThreadLocalState() {
        LinkedList<Byte> stack = encVersionThreadLocal.get();
        stack.removeLast();
    }

    public static byte getEncodingVersion() {
        Byte last;
        byte encodingVersion = 0;
        LinkedList<Byte> stack = encVersionThreadLocal.get();
        if (stack.size() > 0 && (last = stack.getLast()) != null) {
            encodingVersion = last;
        }
        return encodingVersion;
    }

    public static byte[] getByteBufferArray(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            byte[] buf = new byte[byteBuffer.limit()];
            System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), buf, 0, buf.length);
            return buf;
        }
        byte[] buf = new byte[byteBuffer.limit()];
        int pos = byteBuffer.position();
        byteBuffer.position(0);
        byteBuffer.get(buf);
        byteBuffer.position(pos);
        return buf;
    }

    public static byte chooseEncodingVersion(ORB orb, IOR ior, GIOPVersion gv) {
        IIOPProfile prof;
        IIOPProfileTemplate profTemp;
        Iterator<TaggedComponent> iter;
        if (orb.getORBData().isJavaSerializationEnabled() && !gv.lessThan(GIOPVersion.V1_2) && (iter = (profTemp = (IIOPProfileTemplate)(prof = ior.getProfile()).getTaggedProfileTemplate()).iteratorById(1398099458)).hasNext()) {
            JavaSerializationComponent jc = (JavaSerializationComponent)iter.next();
            byte jcVersion = jc.javaSerializationVersion();
            if (jcVersion >= 1) {
                return 1;
            }
            if (jcVersion > 0) {
                return jcVersion;
            }
            wrapper.invalidJavaSerializationVersion(jc);
        }
        return 0;
    }

    private ORBUtility() {
    }

    private static synchronized StructMember[] systemExceptionMembers(ORB orb) {
        if (members == null) {
            members = new StructMember[3];
            ORBUtility.members[0] = new StructMember("id", orb.create_string_tc(0), null);
            ORBUtility.members[1] = new StructMember("minor", orb.get_primitive_tc(TCKind.tk_long), null);
            ORBUtility.members[2] = new StructMember("completed", orb.get_primitive_tc(TCKind.tk_long), null);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypeCode getSystemExceptionTypeCode(ORB orb, String repID, String name) {
        Class<TypeCode> clazz = TypeCode.class;
        synchronized (TypeCode.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return orb.create_exception_tc(repID, name, ORBUtility.systemExceptionMembers(orb));
        }
    }

    private static boolean isSystemExceptionTypeCode(TypeCode type, ORB orb) {
        StructMember[] systemExceptionMembers = ORBUtility.systemExceptionMembers(orb);
        try {
            return type.kind().value() == 22 && type.member_count() == 3 && type.member_type(0).equal(systemExceptionMembers[0].type) && type.member_type(1).equal(systemExceptionMembers[1].type) && type.member_type(2).equal(systemExceptionMembers[2].type);
        }
        catch (BadKind ex) {
            return false;
        }
        catch (Bounds ex) {
            return false;
        }
    }

    public static void insertSystemException(SystemException ex, Any any) {
        OutputStream out = any.create_output_stream();
        ORB orb = (ORB)out.orb();
        String name = ((java.lang.Object)((java.lang.Object)ex)).getClass().getName();
        String repID = ORBUtility.repositoryIdOf(name);
        out.write_string(repID);
        out.write_long(ex.minor);
        out.write_long(ex.completed.value());
        any.read_value(out.create_input_stream(), ORBUtility.getSystemExceptionTypeCode(orb, repID, name));
    }

    public static SystemException extractSystemException(Any any) {
        InputStream in = any.create_input_stream();
        ORB orb = (ORB)in.orb();
        if (!ORBUtility.isSystemExceptionTypeCode(any.type(), orb)) {
            throw wrapper.unknownDsiSysex(CompletionStatus.COMPLETED_MAYBE);
        }
        return ORBUtility.readSystemException(in);
    }

    public static ValueHandler createValueHandler(ORB orb) {
        return vhandler;
    }

    public static boolean isLegacyORB(ORB orb) {
        try {
            ORBVersion currentORB = orb.getORBVersion();
            return currentORB.equals(ORBVersionFactory.getOLD());
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public static boolean isForeignORB(ORB orb) {
        if (orb == null) {
            return false;
        }
        try {
            return orb.getORBVersion().equals(ORBVersionFactory.getFOREIGN());
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public static int bytesToInt(byte[] array, int offset) {
        int b1 = array[offset++] << 24 & 0xFF000000;
        int b2 = array[offset++] << 16 & 0xFF0000;
        int b3 = array[offset++] << 8 & 0xFF00;
        int b4 = array[offset++] << 0 & 0xFF;
        return b1 | b2 | b3 | b4;
    }

    public static void intToBytes(int value, byte[] array, int offset) {
        array[offset++] = (byte)(value >>> 24 & 0xFF);
        array[offset++] = (byte)(value >>> 16 & 0xFF);
        array[offset++] = (byte)(value >>> 8 & 0xFF);
        array[offset++] = (byte)(value >>> 0 & 0xFF);
    }

    public static int hexOf(char x) {
        int val = x - 48;
        if (val >= 0 && val <= 9) {
            return val;
        }
        val = x - 97 + 10;
        if (val >= 10 && val <= 15) {
            return val;
        }
        val = x - 65 + 10;
        if (val >= 10 && val <= 15) {
            return val;
        }
        throw wrapper.badHexDigit();
    }

    public static void writeSystemException(SystemException ex, OutputStream strm) {
        String s = ORBUtility.repositoryIdOf(((java.lang.Object)((java.lang.Object)ex)).getClass().getName());
        strm.write_string(s);
        strm.write_long(ex.minor);
        strm.write_long(ex.completed.value());
    }

    public static SystemException readSystemException(InputStream strm) {
        try {
            String name = ORBUtility.classNameOf(strm.read_string());
            SystemException ex = (SystemException)((java.lang.Object)ORBClassLoader.loadClass(name).newInstance());
            ex.minor = strm.read_long();
            ex.completed = CompletionStatus.from_int((int)strm.read_long());
            return ex;
        }
        catch (Exception ex) {
            throw wrapper.unknownSysex(CompletionStatus.COMPLETED_MAYBE, ex);
        }
    }

    public static String classNameOf(String repositoryId) {
        String className = null;
        className = (String)exceptionClassNames.get(repositoryId);
        if (className == null) {
            className = "org.omg.CORBA.UNKNOWN";
        }
        return className;
    }

    public static boolean isSystemException(String repositoryId) {
        String className = null;
        className = (String)exceptionClassNames.get(repositoryId);
        return className != null;
    }

    public static String repositoryIdOf(String name) {
        String id = (String)exceptionRepositoryIds.get(name);
        if (id == null) {
            id = "IDL:omg.org/CORBA/UNKNOWN:1.0";
        }
        return id;
    }

    public static int[] parseVersion(String version) {
        int end;
        int start;
        if (version == null) {
            return new int[0];
        }
        char[] s = version.toCharArray();
        for (start = 0; start < s.length && (s[start] < '0' || s[start] > '9'); ++start) {
            if (start != s.length) continue;
            return new int[0];
        }
        int size = 1;
        for (end = start + 1; end < s.length; ++end) {
            if (s[end] == '.') {
                ++size;
                continue;
            }
            if (s[end] < '0' || s[end] > '9') break;
        }
        int[] val = new int[size];
        for (int i = 0; i < size; ++i) {
            int dot = version.indexOf(46, start);
            if (dot == -1 || dot > end) {
                dot = end;
            }
            val[i] = start >= dot ? 0 : Integer.parseInt(version.substring(start, dot));
            start = dot + 1;
        }
        return val;
    }

    public static int compareVersion(int[] v1, int[] v2) {
        if (v1 == null) {
            v1 = new int[]{};
        }
        if (v2 == null) {
            v2 = new int[]{};
        }
        for (int i = 0; i < v1.length; ++i) {
            if (i >= v2.length || v1[i] > v2[i]) {
                return 1;
            }
            if (v1[i] >= v2[i]) continue;
            return -1;
        }
        return v1.length == v2.length ? 0 : -1;
    }

    public static synchronized int compareVersion(String v1, String v2) {
        return ORBUtility.compareVersion(ORBUtility.parseVersion(v1), ORBUtility.parseVersion(v2));
    }

    private static String compressClassName(String name) {
        String prefix = "com.sun.corba.ee.";
        if (name.startsWith(prefix)) {
            return "(ORB)." + name.substring(prefix.length());
        }
        return name;
    }

    public static String getThreadName(Thread thr) {
        if (thr == null) {
            return "null";
        }
        String name = thr.getName();
        StringTokenizer st = new StringTokenizer(name);
        int numTokens = st.countTokens();
        if (numTokens != 5) {
            return name;
        }
        String[] tokens = new String[numTokens];
        for (int ctr = 0; ctr < numTokens; ++ctr) {
            tokens[ctr] = st.nextToken();
        }
        if (!tokens[0].equals("SelectReaderThread")) {
            return name;
        }
        return "SelectReaderThread[" + tokens[2] + ":" + tokens[3] + "]";
    }

    private static String formatStackTraceElement(StackTraceElement ste) {
        return ORBUtility.compressClassName(ste.getClassName()) + "." + ste.getMethodName() + (ste.isNativeMethod() ? "(Native Method)" : (ste.getFileName() != null && ste.getLineNumber() >= 0 ? "(" + ste.getFileName() + ":" + ste.getLineNumber() + ")" : (ste.getFileName() != null ? "(" + ste.getFileName() + ")" : "(Unknown Source)")));
    }

    private static void printStackTrace(StackTraceElement[] trace) {
        System.out.println("    Stack Trace:");
        for (int ctr = 1; ctr < trace.length; ++ctr) {
            System.out.print("        >");
            System.out.println(ORBUtility.formatStackTraceElement(trace[ctr]));
        }
    }

    public static synchronized void dprint(java.lang.Object obj, String msg) {
        System.out.println(ORBUtility.compressClassName(obj.getClass().getName()) + "(" + ORBUtility.getThreadName(Thread.currentThread()) + "): " + msg);
    }

    public static synchronized void dprint(String className, String msg) {
        System.out.println(ORBUtility.compressClassName(className) + "(" + ORBUtility.getThreadName(Thread.currentThread()) + "): " + msg);
    }

    public synchronized void dprint(String msg) {
        ORBUtility.dprint(this, msg);
    }

    public static synchronized void dprintTrace(java.lang.Object obj, String msg) {
        ORBUtility.dprint(obj, msg);
        Throwable thr = new Throwable();
        ORBUtility.printStackTrace(thr.getStackTrace());
    }

    public static synchronized void dprint(java.lang.Object caller, String msg, Throwable t) {
        System.out.println(ORBUtility.compressClassName(caller.getClass().getName()) + '(' + Thread.currentThread() + "): " + msg);
        if (t != null) {
            ORBUtility.printStackTrace(t.getStackTrace());
        }
    }

    public static String[] concatenateStringArrays(String[] arr1, String[] arr2) {
        int ctr;
        String[] result = new String[arr1.length + arr2.length];
        for (ctr = 0; ctr < arr1.length; ++ctr) {
            result[ctr] = arr1[ctr];
        }
        for (ctr = 0; ctr < arr2.length; ++ctr) {
            result[ctr + arr1.length] = arr2[ctr];
        }
        return result;
    }

    public static void throwNotSerializableForCorba(String className) {
        throw omgWrapper.notSerializable(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)className);
    }

    public static byte getMaxStreamFormatVersion() {
        ValueHandler vh = Util.getInstance().createValueHandler();
        if (!(vh instanceof ValueHandlerMultiFormat)) {
            return 1;
        }
        return ((ValueHandlerMultiFormat)vh).getMaximumStreamFormatVersion();
    }

    public static CorbaClientDelegate makeClientDelegate(IOR ior) {
        ORB orb = ior.getORB();
        CorbaContactInfoList ccil = orb.getCorbaContactInfoListFactory().create(ior);
        CorbaClientDelegate del = orb.getClientDelegateFactory().create(ccil);
        return del;
    }

    public static Object makeObjectReference(IOR ior) {
        CorbaClientDelegate del = ORBUtility.makeClientDelegate(ior);
        CORBAObjectImpl objectImpl = new CORBAObjectImpl();
        StubAdapter.setDelegate((java.lang.Object)objectImpl, (Delegate)del);
        return objectImpl;
    }

    public static void setDaemon(Thread thread) {
        final Thread finalThread = thread;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    finalThread.setDaemon(true);
                    return null;
                }
            });
        }
        catch (Exception e) {
            ORBUtility.dprint(new java.lang.Object(), "setDaemon: Exception: " + e);
        }
    }

    public static String operationNameAndRequestId(CorbaMessageMediator m) {
        return "op/" + m.getOperationName() + " id/" + m.getRequestId();
    }

    public static boolean isPrintable(char c) {
        if (Character.isJavaIdentifierStart(c)) {
            return true;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        switch (Character.getType(c)) {
            case 27: {
                return true;
            }
            case 20: {
                return true;
            }
            case 25: {
                return true;
            }
            case 24: {
                return true;
            }
            case 21: {
                return true;
            }
            case 22: {
                return true;
            }
        }
        return false;
    }

    public static byte[] getBuffer(String[] data) {
        int numChar = 0;
        for (String str : data) {
            numChar += str.length();
        }
        int maxSize = numChar / 2;
        byte[] result = new byte[maxSize];
        int index = 0;
        int value = 0;
        boolean startByte = true;
        block1: for (String str : data) {
            for (int ctr = 0; ctr < str.length(); ++ctr) {
                char ch = str.charAt(ctr);
                if (!Character.isWhitespace(ch)) {
                    if (ch == '#') continue block1;
                    value = 16 * value + ORBUtility.hexOf(ch);
                    if (!startByte) {
                        result[index++] = (byte)value;
                        value = 0;
                    }
                    boolean bl = startByte = !startByte;
                }
                if (startByte) continue;
                throw new RuntimeException();
            }
        }
        return result;
    }

    public static String dumpBinary(byte[] data) {
        ByteBuffer bb = ByteBuffer.wrap(data);
        StringBuffer sb = new StringBuffer();
        ORBUtility.dumpBinary(sb, bb);
        return sb.toString();
    }

    private static void dumpBinary(StringBuffer sbuf, ByteBuffer buffer) {
        int length = buffer.position();
        char[] charBuf = new char[16];
        for (int i = 0; i < length; i += 16) {
            int x;
            int j;
            for (j = 0; j < 16 && i + j < length; ++j) {
                String hex;
                int k = buffer.get(i + j);
                if (k < 0) {
                    k = 256 + k;
                }
                if ((hex = Integer.toHexString(k)).length() == 1) {
                    hex = "0" + hex;
                }
                sbuf.append(hex + " ");
            }
            while (j < 16) {
                sbuf.append("   ");
                ++j;
            }
            for (x = 0; x < 16 && x + i < length; ++x) {
                charBuf[x] = ORBUtility.isPrintable((char)buffer.get(i + x)) ? (int)buffer.get(i + x) : 46;
            }
            sbuf.append(new String(charBuf, 0, x) + "\n");
        }
    }

    public static void printBuffer(String msg, ByteBuffer buffer, PrintStream ps) {
        StringBuffer sbuf = new StringBuffer();
        int length = buffer.position();
        sbuf.append("--------------------------------------------------------\n\n");
        sbuf.append(msg + "\n");
        sbuf.append("\n");
        sbuf.append("Total length (ByteBuffer position) : " + length + "\n");
        sbuf.append("Byte Buffer capacity               : " + buffer.capacity() + "\n\n");
        try {
            ORBUtility.dumpBinary(sbuf, buffer);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        sbuf.append("--------------------------------------------------------\n");
        ps.println(sbuf.toString());
    }

    public static String getClassSecurityInfo(final Class cl) {
        String result = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                StringBuffer sb = new StringBuffer(500);
                ProtectionDomain pd = cl.getProtectionDomain();
                Policy policy = Policy.getPolicy();
                PermissionCollection pc = policy.getPermissions(pd);
                sb.append("\nPermissionCollection ");
                sb.append(pc.toString());
                sb.append(pd.toString());
                return sb.toString();
            }
        });
        return result;
    }

    public static String formatStringArray(String[] a) {
        if (a == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        for (int i = 0; i < a.length; ++i) {
            result.append(a[i]);
            result.append(" ");
        }
        result.append("]");
        return result.toString();
    }

    static {
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_CONTEXT:1.0", "org.omg.CORBA.BAD_CONTEXT");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_INV_ORDER:1.0", "org.omg.CORBA.BAD_INV_ORDER");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_OPERATION:1.0", "org.omg.CORBA.BAD_OPERATION");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_PARAM:1.0", "org.omg.CORBA.BAD_PARAM");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_TYPECODE:1.0", "org.omg.CORBA.BAD_TYPECODE");
        exceptionClassNames.put("IDL:omg.org/CORBA/COMM_FAILURE:1.0", "org.omg.CORBA.COMM_FAILURE");
        exceptionClassNames.put("IDL:omg.org/CORBA/DATA_CONVERSION:1.0", "org.omg.CORBA.DATA_CONVERSION");
        exceptionClassNames.put("IDL:omg.org/CORBA/IMP_LIMIT:1.0", "org.omg.CORBA.IMP_LIMIT");
        exceptionClassNames.put("IDL:omg.org/CORBA/INTF_REPOS:1.0", "org.omg.CORBA.INTF_REPOS");
        exceptionClassNames.put("IDL:omg.org/CORBA/INTERNAL:1.0", "org.omg.CORBA.INTERNAL");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_FLAG:1.0", "org.omg.CORBA.INV_FLAG");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_IDENT:1.0", "org.omg.CORBA.INV_IDENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_OBJREF:1.0", "org.omg.CORBA.INV_OBJREF");
        exceptionClassNames.put("IDL:omg.org/CORBA/MARSHAL:1.0", "org.omg.CORBA.MARSHAL");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_MEMORY:1.0", "org.omg.CORBA.NO_MEMORY");
        exceptionClassNames.put("IDL:omg.org/CORBA/FREE_MEM:1.0", "org.omg.CORBA.FREE_MEM");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_IMPLEMENT:1.0", "org.omg.CORBA.NO_IMPLEMENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_PERMISSION:1.0", "org.omg.CORBA.NO_PERMISSION");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_RESOURCES:1.0", "org.omg.CORBA.NO_RESOURCES");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_RESPONSE:1.0", "org.omg.CORBA.NO_RESPONSE");
        exceptionClassNames.put("IDL:omg.org/CORBA/OBJ_ADAPTER:1.0", "org.omg.CORBA.OBJ_ADAPTER");
        exceptionClassNames.put("IDL:omg.org/CORBA/INITIALIZE:1.0", "org.omg.CORBA.INITIALIZE");
        exceptionClassNames.put("IDL:omg.org/CORBA/PERSIST_STORE:1.0", "org.omg.CORBA.PERSIST_STORE");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSIENT:1.0", "org.omg.CORBA.TRANSIENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/UNKNOWN:1.0", "org.omg.CORBA.UNKNOWN");
        exceptionClassNames.put("IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0", "org.omg.CORBA.OBJECT_NOT_EXIST");
        exceptionClassNames.put("IDL:omg.org/CORBA/INVALID_TRANSACTION:1.0", "org.omg.CORBA.INVALID_TRANSACTION");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_REQUIRED:1.0", "org.omg.CORBA.TRANSACTION_REQUIRED");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_ROLLEDBACK:1.0", "org.omg.CORBA.TRANSACTION_ROLLEDBACK");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_POLICY:1.0", "org.omg.CORBA.INV_POLICY");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_UNAVAILABLE:1.0", "org.omg.CORBA.TRANSACTION_UNAVAILABLE");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_MODE:1.0", "org.omg.CORBA.TRANSACTION_MODE");
        exceptionClassNames.put("IDL:omg.org/CORBA/CODESET_INCOMPATIBLE:1.0", "org.omg.CORBA.CODESET_INCOMPATIBLE");
        exceptionClassNames.put("IDL:omg.org/CORBA/REBIND:1.0", "org.omg.CORBA.REBIND");
        exceptionClassNames.put("IDL:omg.org/CORBA/TIMEOUT:1.0", "org.omg.CORBA.TIMEOUT");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_QOS:1.0", "org.omg.CORBA.BAD_QOS");
        exceptionClassNames.put("IDL:omg.org/CORBA/INVALID_ACTIVITY:1.0", "org.omg.CORBA.INVALID_ACTIVITY");
        exceptionClassNames.put("IDL:omg.org/CORBA/ACTIVITY_COMPLETED:1.0", "org.omg.CORBA.ACTIVITY_COMPLETED");
        exceptionClassNames.put("IDL:omg.org/CORBA/ACTIVITY_REQUIRED:1.0", "org.omg.CORBA.ACTIVITY_REQUIRED");
        Enumeration keys = exceptionClassNames.keys();
        try {
            while (keys.hasMoreElements()) {
                java.lang.Object s = keys.nextElement();
                String rId = (String)s;
                String cName = (String)exceptionClassNames.get(rId);
                exceptionRepositoryIds.put(cName, rId);
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }
}

