/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import com.sun.messaging.jmq.io.MQObjectInputStream;
import com.sun.messaging.jmq.io.VRFile;
import com.sun.messaging.jmq.io.VRFileRAF;
import com.sun.messaging.jmq.io.VRFileWarning;
import com.sun.messaging.jmq.io.VRecord;
import com.sun.messaging.jmq.io.VRecordRAF;
import com.sun.messaging.jmq.resources.SharedResources;
import com.sun.messaging.jmq.util.PHashMapLoadException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PHashMap
extends ConcurrentHashMap {
    private static boolean DEBUG = false;
    public static final int VERSION = 1;
    public static final int DEFAULT_INITIAL_MAP_CAPACITY = 128;
    protected VRFile backingFile;
    protected ConcurrentHashMap recordMap;
    protected boolean safe = false;
    protected static long cookie = String.valueOf("PHashMap:1").hashCode();
    private VRFileWarning warning = null;
    protected boolean loaded = false;
    private Set entrySet = null;
    private Set keySet = null;
    private Collection values = null;

    public PHashMap(File file, boolean bl, boolean bl2) throws IOException {
        this(file, 0xA00000L, 128, bl, bl2);
    }

    public PHashMap(File file, long l, boolean bl, boolean bl2) throws IOException {
        this(file, l, 128, bl, bl2);
    }

    public PHashMap(File file, long l, int n, boolean bl, boolean bl2) throws IOException {
        super(n);
        if (DEBUG) {
            System.out.println("PHashMap cookie: " + cookie);
        }
        this.safe = bl;
        this.initBackingFile(file, l);
        this.backingFile.setCookie(cookie);
        this.backingFile.setSafe(bl);
        if (bl2) {
            this.backingFile.clear(false);
        }
        try {
            this.backingFile.open();
        }
        catch (VRFileWarning vRFileWarning) {
            this.warning = vRFileWarning;
        }
    }

    protected void initBackingFile(File file, long l) {
        this.backingFile = new VRFileRAF(file, l);
    }

    public void load() throws IOException, ClassNotFoundException, PHashMapLoadException {
        int n;
        Object object = null;
        Set set = this.backingFile.getRecords();
        int n2 = set.size();
        this.recordMap = n2 > (n = this.size()) ? new ConcurrentHashMap(n2) : new ConcurrentHashMap(n);
        for (VRecordRAF vRecordRAF : set) {
            Object object2;
            Object object3 = null;
            Object object4 = null;
            Throwable throwable = null;
            Throwable throwable2 = null;
            IOException iOException = null;
            try {
                object2 = new byte[vRecordRAF.getDataCapacity()];
                vRecordRAF.read((byte[])object2);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object2);
                MQObjectInputStream mQObjectInputStream = new MQObjectInputStream(byteArrayInputStream);
                try {
                    object3 = mQObjectInputStream.readObject();
                }
                catch (Throwable throwable3) {
                    if (throwable3 instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)throwable3;
                    }
                    throwable = throwable3;
                }
                try {
                    object4 = mQObjectInputStream.readObject();
                }
                catch (Throwable throwable4) {
                    if (throwable4 instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)throwable4;
                    }
                    throwable2 = throwable4;
                }
                mQObjectInputStream.close();
                byteArrayInputStream.close();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (throwable != null || throwable2 != null || iOException != null) {
                object2 = new PHashMapLoadException("Failed to load data in [" + vRecordRAF.toString() + "]");
                ((PHashMapLoadException)object2).setKey(object3);
                ((PHashMapLoadException)object2).setValue(object4);
                ((PHashMapLoadException)object2).setKeyCause(throwable);
                ((PHashMapLoadException)object2).setValueCause(throwable2);
                ((PHashMapLoadException)object2).setNextException((PHashMapLoadException)object);
                ((Throwable)object2).initCause(iOException);
                object = object2;
                if (object3 != null) {
                    this.recordMap.put(object3, vRecordRAF);
                    super.put(object3, object4);
                    continue;
                }
                this.backingFile.free(vRecordRAF);
                continue;
            }
            this.recordMap.put(object3, vRecordRAF);
            super.put(object3, object4);
        }
        this.loaded = true;
        if (object != null) {
            throw object;
        }
    }

    public void force() throws IOException {
        this.force(null);
    }

    public void force(Object object) throws IOException {
        this.checkLoaded();
        if (object != null) {
            VRecord vRecord = (VRecord)this.recordMap.get(object);
            if (vRecord != null) {
                vRecord.force();
            }
        } else {
            this.backingFile.force();
        }
    }

    public Object put(Object object, Object object2) {
        return this.doPut(object, object2, false);
    }

    public Object putIfAbsent(Object object, Object object2) {
        return this.doPut(object, object2, true);
    }

    public final Object put(Object object, Object object2, boolean bl) {
        return this.doPut(object, object2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object doPut(Object object, Object object2, boolean bl) {
        Object object3;
        boolean bl2;
        block18: {
            Object object4;
            block17: {
                this.checkLoaded();
                bl2 = false;
                object3 = null;
                try {
                    try {
                        if (bl) {
                            object3 = super.putIfAbsent(object, object2);
                            if (object3 != null) {
                                object4 = object3;
                                Object var13_9 = null;
                                if (!bl2) return object4;
                                if (object3 != null) break block17;
                                super.remove(object);
                                return object4;
                            }
                        } else {
                            object3 = super.put(object, object2);
                        }
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        objectOutputStream.writeObject(object);
                        objectOutputStream.writeObject(object2);
                        objectOutputStream.close();
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        VRecordRAF vRecordRAF = (VRecordRAF)this.recordMap.get(object);
                        VRFile vRFile = this.backingFile;
                        synchronized (vRFile) {
                            if (vRecordRAF == null) {
                                vRecordRAF = (VRecordRAF)this.backingFile.allocate(byArray.length);
                            } else if (vRecordRAF.getDataCapacity() < byArray.length) {
                                this.backingFile.free(vRecordRAF);
                                vRecordRAF = (VRecordRAF)this.backingFile.allocate(byArray.length);
                            } else {
                                vRecordRAF.rewind();
                            }
                            vRecordRAF.write(byArray);
                            if (this.safe) {
                                vRecordRAF.force();
                            }
                        }
                        this.recordMap.put(object, vRecordRAF);
                        break block18;
                    }
                    catch (IOException iOException) {
                        bl2 = true;
                        throw new RuntimeException(iOException);
                    }
                }
                catch (Throwable throwable) {
                    Object var13_11 = null;
                    if (!bl2) throw throwable;
                    if (object3 == null) {
                        super.remove(object);
                        throw throwable;
                    }
                    super.put(object, object3);
                    throw throwable;
                }
            }
            super.put(object, object3);
            return object4;
        }
        Object var13_10 = null;
        if (!bl2) return object3;
        if (object3 == null) {
            super.remove(object);
            return object3;
        }
        super.put(object, object3);
        return object3;
    }

    public Object remove(Object object) {
        this.checkLoaded();
        try {
            Object v = super.remove(object);
            this.removeFromFile(object);
            return v;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public boolean remove(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public Object replace(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public boolean replace(Object object, Object object2, Object object3) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void clear() {
        this.checkLoaded();
        try {
            super.clear();
            this.recordMap.clear();
            this.backingFile.clear(false);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void close() {
        this.backingFile.close();
    }

    public Set entrySet() {
        this.checkLoaded();
        Set set = this.entrySet;
        if (set == null) {
            set = this.entrySet = new HashSet(super.entrySet());
        }
        return set;
    }

    public Set keySet() {
        this.checkLoaded();
        Set set = this.keySet;
        if (set == null) {
            set = this.keySet = new HashSet(super.keySet());
        }
        return set;
    }

    public VRFileWarning getWarning() {
        return this.warning;
    }

    public Collection values() {
        this.checkLoaded();
        Collection collection = this.values;
        if (collection == null) {
            collection = this.values = new ValueCollection(super.entrySet());
        }
        return collection;
    }

    protected final void checkLoaded() {
        if (!this.loaded) {
            throw new IllegalStateException(SharedResources.getResources().getString("S3010"));
        }
    }

    final Object putInHashMap(Object object, Object object2, boolean bl) {
        if (bl) {
            return super.putIfAbsent(object, object2);
        }
        return super.put(object, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromFile(Object object) throws IOException {
        VRecord vRecord;
        if (DEBUG) {
            System.out.println("PHashMap.removeFromFile() called for " + object);
        }
        if ((vRecord = (VRecord)this.recordMap.remove(object)) != null) {
            VRFile vRFile = this.backingFile;
            synchronized (vRFile) {
                this.backingFile.free(vRecord);
                if (this.safe) {
                    this.backingFile.force();
                }
            }
        }
    }

    private class HashIterator
    implements Iterator {
        boolean values = false;
        Iterator iterator = null;
        Object current = null;

        HashIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        HashIterator(Iterator iterator, boolean bl) {
            this.iterator = iterator;
            this.values = bl;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.current = this.iterator.next();
            if (this.values) {
                return ((Map.Entry)this.current).getValue();
            }
            return this.current;
        }

        public void remove() {
            this.iterator.remove();
            Object object = null;
            object = this.current instanceof Map.Entry ? ((Map.Entry)this.current).getKey() : this.current;
            try {
                PHashMap.this.removeFromFile(object);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    private class ValueCollection
    extends AbstractCollection {
        Set entries = null;

        ValueCollection(Set set) {
            this.entries = set;
        }

        public int size() {
            return this.entries.size();
        }

        public boolean contains(Object object) {
            return PHashMap.this.containsValue(object);
        }

        public void clear() {
            PHashMap.this.clear();
        }

        public Iterator iterator() {
            return new HashIterator(this.entries.iterator(), true);
        }
    }

    private class HashSet
    extends AbstractSet {
        Set set = null;

        HashSet(Set set) {
            this.set = set;
        }

        public int size() {
            return this.set.size();
        }

        public boolean contains(Object object) {
            return this.set.contains(object);
        }

        public boolean remove(Object object) {
            boolean bl = this.set.remove(object);
            if (bl) {
                Object object2 = null;
                object2 = object instanceof Map.Entry ? ((Map.Entry)object).getKey() : object;
                try {
                    PHashMap.this.removeFromFile(object2);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            return bl;
        }

        public void clear() {
            PHashMap.this.clear();
        }

        public Iterator iterator() {
            return new HashIterator(this.set.iterator());
        }
    }
}

