/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.gui;

import com.sun.enterprise.tools.upgrade.UpgradeToolMain;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.Credentials;
import com.sun.enterprise.tools.upgrade.common.DirectoryMover;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_masterpassword;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_source;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_target;
import com.sun.enterprise.tools.upgrade.gui.DataCollectionPanel;
import com.sun.enterprise.tools.upgrade.gui.ProgressPanel;
import com.sun.enterprise.tools.upgrade.gui.UpgradeWorker;
import com.sun.enterprise.tools.upgrade.gui.util.Utils;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.logging.Logger;
import javax.help.CSH;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;

public class MainFrame
extends JFrame
implements DirectoryMover {
    private static final Logger logger = LogService.getLogger();
    private StringManager stringManager = StringManager.getManager(MainFrame.class);
    private static final CommonInfoModel commonInfoModel = CommonInfoModel.getInstance();
    private final UpgradeToolMain upgradeToolMain;
    private final DataCollectionPanel dataCollectionPanel = new DataCollectionPanel(this);
    private final ProgressPanel progressPanel = new ProgressPanel();
    private ImageIcon upgradeIcon;
    private JButton backButton;
    private JButton cancelButton;
    private JButton helpButton;
    private JLabel imageLabel;
    private JPanel mainPanel;
    private JButton nextButton;

    public MainFrame(UpgradeToolMain upgradeToolMain) {
        this.upgradeToolMain = upgradeToolMain;
        String imageURLString = "com/sun/enterprise/tools/upgrade/gui/Appserv_upgrade_wizard.gif";
        URL imageURL = ClassLoader.getSystemClassLoader().getResource(imageURLString);
        if (imageURL != null) {
            this.upgradeIcon = new ImageIcon(imageURL, "some text. booyah!");
        } else {
            System.err.println(String.format("Cannot find image %s", imageURLString));
        }
        this.initComponents();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                MainFrame.this.doCancelAction();
            }
        });
        if (Utils.getHelpBroker() != null) {
            Utils.getHelpBroker().enableHelpOnButton(this.helpButton, "WIZARD_FIRST", null);
        }
        this.dataCollectionPanel.checkState();
    }

    private void initComponents() {
        JPanel imagePanel = new JPanel();
        this.imageLabel = new JLabel(this.upgradeIcon);
        this.mainPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        JPanel centeredPanel = new JPanel();
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.cancelButton = new JButton();
        this.helpButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle(this.stringManager.getString("upgrade.gui.mainframe.titleMessage", commonInfoModel.getTarget().getVersion()));
        this.setMinimumSize(new Dimension(725, 545));
        imagePanel.setLayout(new BoxLayout(imagePanel, 2));
        imagePanel.add(this.imageLabel);
        this.mainPanel.setLayout(new CardLayout());
        this.backButton.setText(this.stringManager.getString("upgrade.gui.mainframe.backbutton"));
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.backButtonActionPerformed(evt);
            }
        });
        this.nextButton.setText(this.stringManager.getString("upgrade.gui.mainframe.nextbutton"));
        this.nextButton.setEnabled(false);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.nextButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(this.stringManager.getString("upgrade.gui.mainframe.cancelbutton"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cancelButtonActionPerformed(evt);
            }
        });
        this.helpButton.setText(this.stringManager.getString("upgrade.gui.mainframe.helpbutton"));
        this.helpButton.setToolTipText("Help");
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.helpButtonActionPerformed(evt);
            }
        });
        GroupLayout centeredPanelLayout = new GroupLayout(centeredPanel);
        centeredPanel.setLayout(centeredPanelLayout);
        centeredPanelLayout.setHorizontalGroup(centeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(centeredPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.backButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton).addGap(90, 90, 90).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addContainerGap()));
        centeredPanelLayout.linkSize(0, this.backButton, this.cancelButton, this.helpButton, this.nextButton);
        centeredPanelLayout.setVerticalGroup(centeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(centeredPanelLayout.createSequentialGroup().addContainerGap().addGroup(centeredPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nextButton).addComponent(this.cancelButton).addComponent(this.backButton).addComponent(this.helpButton)).addContainerGap()));
        GroupLayout buttonPanelLayout = new GroupLayout(buttonPanel);
        buttonPanel.setLayout(buttonPanelLayout);
        buttonPanelLayout.setHorizontalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, buttonPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(centeredPanel, -2, -1, -2).addContainerGap(65, Short.MAX_VALUE)));
        buttonPanelLayout.setVerticalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, buttonPanelLayout.createSequentialGroup().addContainerGap().addComponent(centeredPanel, -2, -1, -2)));
        this.mainPanel.add((Component)this.dataCollectionPanel, Panels.DATA_COLLECTION_PANEL.name());
        this.mainPanel.add((Component)this.progressPanel, Panels.PROGRESS_PANEL.name());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(imagePanel, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainPanel, -1, 571, Short.MAX_VALUE)).addComponent(buttonPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -2, 444, -2).addComponent(imagePanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(buttonPanel, -1, 49, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        CardLayout layoutManager = (CardLayout)this.mainPanel.getLayout();
        layoutManager.show(this.mainPanel, Panels.DATA_COLLECTION_PANEL.name());
        this.nextButton.setText(this.stringManager.getString("upgrade.gui.mainframe.nextbutton"));
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
        CSH.setHelpIDString(this.helpButton, "WIZARD_FIRST");
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        if (this.progressPanel.isVisible()) {
            this.performExit();
        }
        if (!this.dataCollectionPanel.isVisible()) {
            throw new AssertionError((Object)"No expected panel is visible");
        }
        if (!this.processArguments()) {
            return;
        }
        this.printArguments();
        CardLayout layoutManager = (CardLayout)this.mainPanel.getLayout();
        layoutManager.show(this.mainPanel, Panels.PROGRESS_PANEL.name());
        this.nextButton.setText(this.stringManager.getString("upgrade.gui.mainframe.finishbutton"));
        this.nextButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.progressPanel.getProgressBar().setIndeterminate(true);
        CSH.setHelpIDString(this.helpButton, "WIZARD_RESULT");
        UpgradeWorker upgradeWorker = new UpgradeWorker(this, this.upgradeToolMain);
        upgradeWorker.execute();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doCancelAction();
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
    }

    public boolean moveDirectory(File dir) {
        String title;
        String message = String.format(this.stringManager.getString("upgrade.gui.util.domainRenameOption", dir.getName()), new Object[0]);
        int retVal = JOptionPane.showConfirmDialog(this, message, title = this.stringManager.getString("upgrade.gui.util.domainNameConflict"), 2, 3);
        if (0 != retVal) {
            return false;
        }
        UpgradeUtils.getUpgradeUtils(commonInfoModel).rename(dir);
        return true;
    }

    void allowContinue(boolean b) {
        this.nextButton.setEnabled(b);
    }

    void done() {
        JLabel progressLabel = this.progressPanel.getProgressLabel();
        progressLabel.setText(this.stringManager.getString("upgrade.gui.progresspanel.progressLabel.DONE"));
        JProgressBar jpBar = this.progressPanel.getProgressBar();
        jpBar.setIndeterminate(false);
        jpBar.setValue(jpBar.getMaximum());
        this.backButton.setEnabled(true);
        this.nextButton.setEnabled(true);
    }

    ProgressPanel getProgressPanel() {
        return this.progressPanel;
    }

    private void doCancelAction() {
        int retVal = JOptionPane.showConfirmDialog(this, this.stringManager.getString("upgrade.gui.mainframe.exitMessage"), this.stringManager.getString("upgrade.gui.mainframe.exitMessageTitle"), 0, 3);
        if (retVal == 1) {
            return;
        }
        this.performExit();
    }

    private void performExit() {
        System.exit(0);
    }

    private boolean processArguments() {
        ARG_source argSource = new ARG_source();
        argSource.setRawParameters(this.dataCollectionPanel.getSourceDirPath());
        if (!argSource.isValidParameter()) {
            JOptionPane.showMessageDialog(this, this.stringManager.getString("upgrade.gui.mainframe.invalidSourceMsg"), this.stringManager.getString("upgrade.gui.mainframe.invalidSourceTitle"), 0);
            return false;
        }
        argSource.exec();
        commonInfoModel.getTarget().setDirectoryMover(this);
        ARG_target t = new ARG_target();
        t.setRawParameters(this.dataCollectionPanel.getDestinationDirPath());
        if (!t.isValidParameter()) {
            JOptionPane.showMessageDialog(this, this.stringManager.getString("upgrade.gui.mainframe.invalidTargetMsg"), this.stringManager.getString("upgrade.gui.mainframe.invalidTargetTitle"), 0);
            return false;
        }
        t.exec();
        if (!commonInfoModel.isUpgradeSupported()) {
            JOptionPane.showMessageDialog(this, this.stringManager.getString("upgrade.gui.mainframe.versionNotSupportedMsg"), this.stringManager.getString("upgrade.gui.mainframe.versionNotSupportedTitle"), 0);
            return false;
        }
        ARG_masterpassword argMasterPW = new ARG_masterpassword();
        argMasterPW.setRawParameters(this.dataCollectionPanel.getMasterPassword());
        argMasterPW.exec();
        return true;
    }

    private void printArguments() {
        Credentials c = commonInfoModel.getSource().getDomainCredentials();
        logger.info("asupgrade -s " + commonInfoModel.getSource().getInstallDir() + "\t -t " + commonInfoModel.getTarget().getInstallDir() + "\t -m " + c.getMasterPassword().replaceAll(".", "*"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Panels {
        DATA_COLLECTION_PANEL,
        PROGRESS_PANEL;

    }
}

