/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.newtimer;

import com.sun.corba.ee.spi.orbutil.newtimer.Controllable;
import com.sun.corba.ee.spi.orbutil.newtimer.Timer;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerEvent;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerFactory;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LogEventHandlerIterator
implements Iterator<TimerEvent> {
    private int current = 0;
    private TimerEvent entry = null;
    private final TimerFactory factory;
    private final long[] data;
    private final int nextFree;

    public LogEventHandlerIterator(TimerFactory factory, long[] data, int nextFree) {
        this.factory = factory;
        this.data = data;
        this.nextFree = nextFree;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.current < this.nextFree;
    }

    @Override
    public TimerEvent next() {
        if (this.hasNext()) {
            long elem = this.data[this.current];
            TimerEvent.TimerEventType etype = (elem & 1L) == 1L ? TimerEvent.TimerEventType.EXIT : TimerEvent.TimerEventType.ENTER;
            int id = (int)(elem >> 1);
            Controllable con = this.factory.getControllable(id);
            if (!(con instanceof Timer)) {
                throw new IllegalStateException("Controllable id must be Timer");
            }
            Timer timer = (Timer)Timer.class.cast(con);
            if (this.entry == null) {
                this.entry = new TimerEvent(timer, etype, this.data[this.current + 1]);
            } else {
                this.entry.update(timer, etype, this.data[this.current + 1]);
            }
            this.current += 2;
            return this.entry;
        }
        throw new NoSuchElementException();
    }
}

