/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.theme.ThemeContext;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.faces.context.FacesContext;
import org.glassfish.admingui.common.handlers.PluginHandlers;
import org.glassfish.admingui.common.plugin.ConsoleClassLoader;
import org.glassfish.admingui.plugin.IntegrationPoint;
import org.glassfish.admingui.theme.AdminguiThemeContext;

public class ThemeHandlers {
    public static void getTheme(HandlerContext handlerCtx) {
        String themeName = (String)handlerCtx.getInputValue("themeName");
        String themeVersion = (String)handlerCtx.getInputValue("themeVersion");
        ThemeContext themeContext = AdminguiThemeContext.getInstance(handlerCtx.getFacesContext(), themeName, themeVersion);
        handlerCtx.setOutputValue("themeContext", (Object)themeContext);
    }

    public static void getThemeFromIntegrationPoints(HandlerContext handlerCtx) {
        String type;
        FacesContext ctx = handlerCtx.getFacesContext();
        List ipList = PluginHandlers.getIntegrationPoints((FacesContext)ctx, (String)(type = "org.glassfish.admingui:customtheme"));
        if (ipList != null) {
            int lowest = ThemeHandlers.getLowestPriorityNum(ipList);
            for (IntegrationPoint ip : ipList) {
                int priority = ip.getPriority();
                if (priority != lowest) continue;
                String content = ip.getContent();
                if (content == null || content.equals("")) {
                    throw new IllegalArgumentException("No Properties File Name Provided!");
                }
                ClassLoader pluginCL = ConsoleClassLoader.findModuleClassLoader((String)ip.getConsoleConfigId());
                URL propertyFileURL = pluginCL.getResource("/" + content);
                try {
                    Properties propertyMap = new Properties();
                    propertyMap.load(propertyFileURL.openStream());
                    ThemeContext themeContext = AdminguiThemeContext.getInstance(ctx, propertyMap);
                    themeContext.setDefaultClassLoader(pluginCL);
                    handlerCtx.setOutputValue("themeContext", (Object)themeContext);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unable to access properties file '" + content + "'!", ex);
                }
            }
        }
    }

    private static int getLowestPriorityNum(List ipList) {
        Iterator iter = ipList.iterator();
        int lowest = 101;
        while (iter.hasNext()) {
            IntegrationPoint iP = (IntegrationPoint)iter.next();
            if (iP.getPriority() >= lowest) continue;
            lowest = iP.getPriority();
        }
        return lowest;
    }
}

