/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.TimeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.web.admin.monitor.TimeStatData;
import org.jvnet.hk2.component.PostConstruct;

@AMXMetadata(type="request-mon", group="monitoring")
@ManagedObject
@Description(value="Web Container HTTP Service Statistics")
public class HttpServiceStatsProvider
implements PostConstruct {
    private static final Logger logger = Logger.getLogger(HttpServiceStatsProvider.class.getName());
    private static final String ERROR_COUNT_DESCRIPTION = "Cumulative value of the error count, with error count representing the number of cases where the response code was greater than or equal to 400";
    private static final String MAX_TIME_DESCRIPTION = "Longest response time for a request; not a cumulative value, but the largest response time from among the response times";
    private static final String PROCESSING_TIME_DESCRIPTION = "Average request processing time";
    private static final String REQUEST_COUNT_DESCRIPTION = "Cumulative number of requests processed so far";
    private static final String COUNT_200_DESCRIPTION = "Number of responses with a status code equal to 200";
    private static final String COUNT_2xx_DESCRIPTION = "Number of responses with a status code in the 2xx range";
    private static final String COUNT_302_DESCRIPTION = "Number of responses with a status code equal to 302";
    private static final String COUNT_304_DESCRIPTION = "Number of responses with a status code equal to 304";
    private static final String COUNT_3xx_DESCRIPTION = "Number of responses with a status code in the 3xx range";
    private static final String COUNT_400_DESCRIPTION = "Number of responses with a status code equal to 400";
    private static final String COUNT_401_DESCRIPTION = "Number of responses with a status code equal to 401";
    private static final String COUNT_403_DESCRIPTION = "Number of responses with a status code equal to 403";
    private static final String COUNT_404_DESCRIPTION = "Number of responses with a status code equal to 404";
    private static final String COUNT_4xx_DESCRIPTION = "Number of responses with a status code in the 4xx range";
    private static final String COUNT_503_DESCRIPTION = "Number of responses with a status code equal to 503";
    private static final String COUNT_5xx_DESCRIPTION = "Number of responses with a status code in the 5xx range";
    private static final String COUNT_OTHER_DESCRIPTION = "Number of responses with a status code outside the 2xx, 3xx, 4xx, and 5xx range";
    private CountStatisticImpl errorCount = new CountStatisticImpl("ErrorCount", "count", "Cumulative value of the error count, with error count representing the number of cases where the response code was greater than or equal to 400");
    private CountStatisticImpl maxTime = new CountStatisticImpl("MaxTime", "millisecond", "Longest response time for a request; not a cumulative value, but the largest response time from among the response times");
    private CountStatisticImpl processingTime = new CountStatisticImpl("ProcessingTime", "millisecond", "Average request processing time");
    private CountStatisticImpl requestCount = new CountStatisticImpl("RequestCount", "count", "Cumulative number of requests processed so far");
    private CountStatisticImpl count200 = new CountStatisticImpl("Count200", "count", "Number of responses with a status code equal to 200");
    private CountStatisticImpl count2xx = new CountStatisticImpl("Count2xx", "count", "Number of responses with a status code in the 2xx range");
    private CountStatisticImpl count302 = new CountStatisticImpl("Count302", "count", "Number of responses with a status code equal to 302");
    private CountStatisticImpl count304 = new CountStatisticImpl("Count304", "count", "Number of responses with a status code equal to 304");
    private CountStatisticImpl count3xx = new CountStatisticImpl("Count3xx", "count", "Number of responses with a status code in the 3xx range");
    private CountStatisticImpl count400 = new CountStatisticImpl("Count400", "count", "Number of responses with a status code equal to 400");
    private CountStatisticImpl count401 = new CountStatisticImpl("Count401", "count", "Number of responses with a status code equal to 401");
    private CountStatisticImpl count403 = new CountStatisticImpl("Count403", "count", "Number of responses with a status code equal to 403");
    private CountStatisticImpl count404 = new CountStatisticImpl("Count404", "count", "Number of responses with a status code equal to 404");
    private CountStatisticImpl count4xx = new CountStatisticImpl("Count4xx", "count", "Number of responses with a status code in the 4xx range");
    private CountStatisticImpl count503 = new CountStatisticImpl("Count503", "count", "Number of responses with a status code equal to 503");
    private CountStatisticImpl count5xx = new CountStatisticImpl("Count5xx", "count", "Number of responses with a status code in the 5xx range");
    private CountStatisticImpl countOther = new CountStatisticImpl("CountOther", "count", "Number of responses with a status code outside the 2xx, 3xx, 4xx, and 5xx range");
    private TimeStatisticImpl requestProcessTime = new TimeStatisticImpl(0L, 0L, 0L, 0L, "", "", "", System.currentTimeMillis(), -1L);
    private String virtualServerName = null;
    private ThreadLocal<TimeStatData> individualData = new ThreadLocal<TimeStatData>(){
        TimeStatData tsd;

        @Override
        protected TimeStatData initialValue() {
            this.tsd = new TimeStatData();
            return this.tsd;
        }

        @Override
        public TimeStatData get() {
            if (this.tsd == null) {
                this.tsd = new TimeStatData();
            }
            return this.tsd;
        }
    };

    public HttpServiceStatsProvider(String vsName) {
        this.virtualServerName = vsName;
    }

    public void postConstruct() {
    }

    @ManagedAttribute(id="maxtime")
    @Description(value="Longest response time for a request; not a cumulative value, but the largest response time from among the response times")
    public CountStatistic getMaxTime() {
        this.maxTime.setCount(this.requestProcessTime.getMaxTime());
        return this.maxTime;
    }

    @ManagedAttribute(id="requestcount")
    @Description(value="Cumulative number of requests processed so far")
    public CountStatistic getCount() {
        this.requestCount.setCount(this.requestProcessTime.getCount());
        return this.requestCount;
    }

    @ManagedAttribute(id="processingtime")
    @Description(value="Average request processing time")
    public CountStatistic getTime() {
        this.processingTime.setCount(this.getProcessTime());
        return this.processingTime;
    }

    @ManagedAttribute(id="errorcount")
    @Description(value="Cumulative value of the error count, with error count representing the number of cases where the response code was greater than or equal to 400")
    public CountStatistic getErrorCount() {
        return this.errorCount;
    }

    @ManagedAttribute(id="count200")
    @Description(value="Number of responses with a status code equal to 200")
    public CountStatistic getCount200() {
        return this.count200.getStatistic();
    }

    @ManagedAttribute(id="count2xx")
    @Description(value="Number of responses with a status code in the 2xx range")
    public CountStatistic getCount2xx() {
        return this.count2xx.getStatistic();
    }

    @ManagedAttribute(id="count302")
    @Description(value="Number of responses with a status code equal to 302")
    public CountStatistic getCount302() {
        return this.count302.getStatistic();
    }

    @ManagedAttribute(id="count304")
    @Description(value="Number of responses with a status code equal to 304")
    public CountStatistic getCount304() {
        return this.count304.getStatistic();
    }

    @ManagedAttribute(id="count3xx")
    @Description(value="Number of responses with a status code in the 3xx range")
    public CountStatistic getCount3xxt() {
        return this.count3xx.getStatistic();
    }

    @ManagedAttribute(id="count400")
    @Description(value="Number of responses with a status code equal to 400")
    public CountStatistic getCount400() {
        return this.count400.getStatistic();
    }

    @ManagedAttribute(id="count401")
    @Description(value="Number of responses with a status code equal to 401")
    public CountStatistic getCount401() {
        return this.count401.getStatistic();
    }

    @ManagedAttribute(id="count403")
    @Description(value="Number of responses with a status code equal to 403")
    public CountStatistic getCount403() {
        return this.count403.getStatistic();
    }

    @ManagedAttribute(id="count404")
    @Description(value="Number of responses with a status code equal to 404")
    public CountStatistic getCount404() {
        return this.count404.getStatistic();
    }

    @ManagedAttribute(id="count4xx")
    @Description(value="Number of responses with a status code in the 4xx range")
    public CountStatistic getCount4xx() {
        return this.count4xx.getStatistic();
    }

    @ManagedAttribute(id="count503")
    @Description(value="Number of responses with a status code equal to 503")
    public CountStatistic getCount503() {
        return this.count503.getStatistic();
    }

    @ManagedAttribute(id="count5xx")
    @Description(value="Number of responses with a status code in the 5xx range")
    public CountStatistic getCount5xx() {
        return this.count5xx.getStatistic();
    }

    @ManagedAttribute(id="countother")
    @Description(value="Number of responses with a status code outside the 2xx, 3xx, 4xx, and 5xx range")
    public CountStatistic getCountOther() {
        return this.countOther.getStatistic();
    }

    @ProbeListener(value="glassfish:web:http-service:requestStartEvent")
    public void requestStartEvent(@ProbeParam(value="hostName") String hostName, @ProbeParam(value="serverName") String serverName, @ProbeParam(value="serverPort") int serverPort, @ProbeParam(value="contextPath") String contextPath, @ProbeParam(value="servletPath") String servletPath) {
        if (hostName != null && hostName.equals(this.virtualServerName)) {
            this.individualData.get().setEntryTime(System.currentTimeMillis());
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("[TM]requestStartEvent received - virtual-server = " + serverName + " : port = " + serverPort);
            }
        }
    }

    @ProbeListener(value="glassfish:web:http-service:requestEndEvent")
    public void requestEndEvent(@ProbeParam(value="hostName") String hostName, @ProbeParam(value="serverName") String serverName, @ProbeParam(value="serverPort") int serverPort, @ProbeParam(value="contextPath") String contextPath, @ProbeParam(value="servletPath") String servletPath, @ProbeParam(value="statusCode") int statusCode) {
        if (hostName != null && hostName.equals(this.virtualServerName)) {
            TimeStatData tsd = this.individualData.get();
            tsd.setExitTime(System.currentTimeMillis());
            this.requestProcessTime.incrementCount(tsd.getTotalTime());
            this.incrementStatsCounter(statusCode);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("[TM]requestEndEvent received - virtual-server = " + serverName + ": application = " + contextPath + " : servlet = " + servletPath + " :Response code = " + statusCode + " :Response time = " + tsd.getTotalTime());
            }
        }
    }

    public long getProcessTime() {
        long count = this.requestProcessTime.getCount();
        long processTime = 0L;
        if (count != 0L) {
            processTime = this.requestProcessTime.getTotalTime() / count;
        }
        return processTime;
    }

    private void incrementStatsCounter(int statusCode) {
        switch (statusCode) {
            case 200: {
                this.count200.increment();
                break;
            }
            case 302: {
                this.count302.increment();
                break;
            }
            case 304: {
                this.count304.increment();
                break;
            }
            case 400: {
                this.count400.increment();
                break;
            }
            case 401: {
                this.count401.increment();
                break;
            }
            case 403: {
                this.count403.increment();
                break;
            }
            case 404: {
                this.count404.increment();
                break;
            }
            case 503: {
                this.count503.increment();
                break;
            }
        }
        if (200 <= statusCode && statusCode <= 299) {
            this.count2xx.increment();
        } else if (300 <= statusCode && statusCode <= 399) {
            this.count3xx.increment();
        } else if (400 <= statusCode && statusCode <= 499) {
            this.count4xx.increment();
        } else if (500 <= statusCode && statusCode <= 599) {
            this.count5xx.increment();
        } else {
            this.countOther.increment();
        }
        if (statusCode >= 400) {
            this.errorCount.increment();
        }
    }

    @Reset
    public void reset() {
        this.requestProcessTime.reset();
        this.count200.reset();
        this.count2xx.reset();
        this.count302.reset();
        this.count304.reset();
        this.count3xx.reset();
        this.count400.reset();
        this.count401.reset();
        this.count403.reset();
        this.count404.reset();
        this.count4xx.reset();
        this.count503.reset();
        this.count5xx.reset();
        this.countOther.reset();
        this.errorCount.reset();
        this.maxTime.reset();
        this.processingTime.reset();
        this.requestCount.reset();
    }
}

