/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.application;

import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.core.spi.component.ProviderServices;
import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.server.impl.model.method.dispatch.ResourceMethodDispatchProvider;
import com.sun.jersey.spi.dispatch.RequestDispatcher;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceMethodDispatcherFactory {
    private static final Logger LOGGER = Logger.getLogger(ResourceMethodDispatcherFactory.class.getName());
    private final Set<ResourceMethodDispatchProvider> dispatchers;

    public ResourceMethodDispatcherFactory(ProviderServices providerServices) {
        this.dispatchers = providerServices.getProvidersAndServices(ResourceMethodDispatchProvider.class);
    }

    public Set<ResourceMethodDispatchProvider> getDispatchers() {
        return this.dispatchers;
    }

    public RequestDispatcher getDispatcher(AbstractResourceMethod abstractResourceMethod) {
        for (ResourceMethodDispatchProvider rmdp : this.dispatchers) {
            try {
                RequestDispatcher d = rmdp.create(abstractResourceMethod);
                if (d == null) continue;
                return d;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, ImplMessages.ERROR_PROCESSING_METHOD(abstractResourceMethod.getMethod(), rmdp.getClass().getName()), e);
            }
        }
        return null;
    }
}

