/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl.provider.entity;

import com.sun.jersey.api.json.JSONConfigurated;
import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.core.provider.jaxb.AbstractListElementProvider;
import com.sun.jersey.json.impl.JSONHelper;
import com.sun.jersey.json.impl.Stax2JsonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONListElementProvider
extends AbstractListElementProvider {
    JSONListElementProvider(Providers ps) {
        super(ps);
    }

    JSONListElementProvider(Providers ps, MediaType mt) {
        super(ps, mt);
    }

    @Override
    public final void writeList(Class<?> elementType, Collection<?> t, MediaType mediaType, Charset c, Marshaller m, OutputStream entityStream) throws JAXBException, IOException {
        OutputStreamWriter osw = new OutputStreamWriter(entityStream, c);
        JSONConfiguration jsonConfig = JSONConfiguration.DEFAULT;
        if (m instanceof JSONConfigurated) {
            jsonConfig = ((JSONConfigurated)m).getJSONConfiguration();
        }
        XMLStreamWriter jxsw = Stax2JsonFactory.createWriter(osw, jsonConfig, true);
        try {
            jxsw.writeStartElement(this.getRootElementName(elementType));
            for (Object o : t) {
                m.marshal(o, jxsw);
            }
            jxsw.writeEndElement();
            jxsw.writeEndDocument();
            jxsw.flush();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(JSONListElementProvider.class.getName()).log(Level.SEVERE, null, ex);
            throw new JAXBException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    protected final XMLStreamReader getXMLStreamReader(Class<?> elementType, MediaType mediaType, Unmarshaller u, InputStream entityStream) throws XMLStreamException {
        JSONConfiguration c = JSONConfiguration.DEFAULT;
        Charset charset = JSONListElementProvider.getCharset(mediaType);
        if (u instanceof JSONConfigurated) {
            c = ((JSONConfigurated)u).getJSONConfiguration();
        }
        return Stax2JsonFactory.createReader(new InputStreamReader(entityStream, charset), c, JSONHelper.getRootElementName(elementType), true);
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public static final class App
    extends JSONListElementProvider {
        public App(@Context Providers ps) {
            super(ps, MediaType.APPLICATION_JSON_TYPE);
        }
    }

    @Produces(value={"*/*"})
    @Consumes(value={"*/*"})
    public static final class General
    extends JSONListElementProvider {
        public General(@Context Providers ps) {
            super(ps);
        }

        protected boolean isSupported(MediaType m) {
            return m.getSubtype().endsWith("+json");
        }
    }
}

