/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.config.serverbeans.JavaConfig;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
@Scoped(value=PerLookup.class)
public class V2ToV3ConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    JavaConfig jc;
    private List<String> oldJvmOptions;
    private final List<String> newJvmOptions = new ArrayList<String>();
    private static final String[] REMOVAL_LIST = new String[]{"-Djavax.management.builder.initial", "-Dsun.rmi.dgc.server.gcInterval", "-Dsun.rmi.dgc.client.gcInterval", "-Dcom.sun.enterprise.taglibs", "-Dcom.sun.enterprise.taglisteners", "-XX:+UnlockDiagnosticVMOptions", "-XX:+LogVMOutput", "-XX:LogFile", "-DANTLR_USE_DIRECT_CLASS_LOADING"};
    private static final String[] ADD_LIST = new String[]{"-XX:+UnlockDiagnosticVMOptions", "-XX:+LogVMOutput", "-XX:LogFile=${com.sun.aas.instanceRoot}/logs/jvm.log", "-DANTLR_USE_DIRECT_CLASS_LOADING=true"};

    public void postConstruct() {
        try {
            this.oldJvmOptions = Collections.unmodifiableList(this.jc.getJvmOptions());
            this.doAdditions();
            this.doRemovals();
            ConfigSupport.apply((SingleConfigCode)new JavaConfigChanger(), (ConfigBeanProxy)this.jc);
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading jvm-options from V2 to V3", e);
            throw new RuntimeException(e);
        }
    }

    private void doRemovals() {
        for (String s : this.oldJvmOptions) {
            if (this.shouldRemove(s)) continue;
            this.newJvmOptions.add(s);
        }
    }

    private void doAdditions() {
        for (String s : ADD_LIST) {
            this.newJvmOptions.add(s);
        }
    }

    private boolean shouldRemove(String option) {
        if (!this.ok(option)) {
            return true;
        }
        for (String s : REMOVAL_LIST) {
            if (!option.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaConfigChanger
    implements SingleConfigCode<JavaConfig> {
        private JavaConfigChanger() {
        }

        public Object run(JavaConfig jc) throws PropertyVetoException, TransactionFailure {
            jc.setJvmOptions(V2ToV3ConfigUpgrade.this.newJvmOptions);
            return jc;
        }
    }
}

