/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.annotations.Kind;
import com.sun.btrace.annotations.Where;
import com.sun.btrace.org.objectweb.asm.AnnotationVisitor;
import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassVisitor;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.MethodAdapter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.runtime.ArrayAccessInstrumentor;
import com.sun.btrace.runtime.ArrayAllocInstrumentor;
import com.sun.btrace.runtime.CatchInstrumentor;
import com.sun.btrace.runtime.ClassFilter;
import com.sun.btrace.runtime.Constants;
import com.sun.btrace.runtime.ErrorReturnInstrumentor;
import com.sun.btrace.runtime.FieldAccessInstrumentor;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.LineNumberInstrumentor;
import com.sun.btrace.runtime.Location;
import com.sun.btrace.runtime.MethodCallInstrumentor;
import com.sun.btrace.runtime.MethodCopier;
import com.sun.btrace.runtime.MethodEntryInstrumentor;
import com.sun.btrace.runtime.MethodInstrumentor;
import com.sun.btrace.runtime.MethodReturnInstrumentor;
import com.sun.btrace.runtime.ObjectAllocInstrumentor;
import com.sun.btrace.runtime.OnMethod;
import com.sun.btrace.runtime.Preprocessor;
import com.sun.btrace.runtime.SynchronizedInstrumentor;
import com.sun.btrace.runtime.ThrowInstrumentor;
import com.sun.btrace.runtime.TypeCheckInstrumentor;
import com.sun.btrace.runtime.TypeUtils;
import com.sun.btrace.runtime.Verifier;
import com.sun.btrace.util.LocalVariablesSorter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Instrumentor
extends ClassAdapter {
    private String btraceClassName;
    private ClassReader btraceClass;
    private List<OnMethod> onMethods;
    private List<OnMethod> applicableOnMethods;
    private Set<OnMethod> calledOnMethods;
    private String className;
    private Class clazz;

    public Instrumentor(Class clazz, String btraceClassName, ClassReader btraceClass, List<OnMethod> onMethods, ClassVisitor cv) {
        super(cv);
        this.clazz = clazz;
        this.btraceClassName = btraceClassName.replace('.', '/');
        this.btraceClass = btraceClass;
        this.onMethods = onMethods;
        this.applicableOnMethods = new ArrayList<OnMethod>();
        this.calledOnMethods = new HashSet<OnMethod>();
    }

    public Instrumentor(Class clazz, String btraceClassName, byte[] btraceCode, List<OnMethod> onMethods, ClassVisitor cv) {
        this(clazz, btraceClassName, new ClassReader(btraceCode), onMethods, cv);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        String externalName = name.replace('/', '.');
        for (OnMethod om : this.onMethods) {
            String probeClazz = om.getClazz();
            if (probeClazz.length() == 0) continue;
            char firstChar = probeClazz.charAt(0);
            if (firstChar == '/' && Constants.REGEX_SPECIFIER.matcher(probeClazz).matches()) {
                if (!externalName.matches(probeClazz = probeClazz.substring(1, probeClazz.length() - 1))) continue;
                this.applicableOnMethods.add(om);
                continue;
            }
            if (firstChar == '+') {
                String superType = probeClazz.substring(1);
                String superTypeInternal = superType.replace('.', '/');
                if (!ClassFilter.isSubTypeOf(this.clazz, superType) && !superName.equals(superTypeInternal) && !Instrumentor.isInArray(interfaces, superTypeInternal)) continue;
                this.applicableOnMethods.add(om);
                continue;
            }
            if (!probeClazz.equals(externalName)) continue;
            this.applicableOnMethods.add(om);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        String extName = Type.getType(desc).getClassName();
        for (OnMethod om : this.onMethods) {
            String probeClazz = om.getClazz();
            if (probeClazz.length() <= 0 || probeClazz.charAt(0) != '@' || (probeClazz = probeClazz.substring(1)).length() == 0) continue;
            if (Constants.REGEX_SPECIFIER.matcher(probeClazz).matches()) {
                if (!extName.matches(probeClazz = probeClazz.substring(1, probeClazz.length() - 1))) continue;
                this.applicableOnMethods.add(om);
                continue;
            }
            if (!probeClazz.equals(extName)) continue;
            this.applicableOnMethods.add(om);
        }
        return av;
    }

    @Override
    public MethodVisitor visitMethod(final int access, final String name, final String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.applicableOnMethods.size() == 0 || (access & 0x400) != 0 || (access & 0x100) != 0 || name.startsWith("$btrace$")) {
            return methodVisitor;
        }
        for (OnMethod om : this.applicableOnMethods) {
            if (om.getLocation().getValue() == Kind.LINE) {
                methodVisitor = this.instrumentorFor(om, methodVisitor, access, name, desc);
                continue;
            }
            String methodName = om.getMethod();
            if (methodName.equals("")) {
                methodName = om.getTargetName();
            }
            if (methodName.equals(name) && this.typeMatches(om.getType(), desc)) {
                methodVisitor = this.instrumentorFor(om, methodVisitor, access, name, desc);
                continue;
            }
            if (methodName.charAt(0) != '/' || !Constants.REGEX_SPECIFIER.matcher(methodName).matches() || !name.matches(methodName = methodName.substring(1, methodName.length() - 1)) || !this.typeMatches(om.getType(), desc)) continue;
            methodVisitor = this.instrumentorFor(om, methodVisitor, access, name, desc);
        }
        return new MethodAdapter(methodVisitor){

            @Override
            public AnnotationVisitor visitAnnotation(String annoDesc, boolean visible) {
                for (OnMethod om : Instrumentor.this.applicableOnMethods) {
                    String extAnnoName = Type.getType(annoDesc).getClassName();
                    String annoName = om.getMethod();
                    if (annoName.length() <= 0 || annoName.charAt(0) != '@' || (annoName = annoName.substring(1)).length() == 0) continue;
                    if (Constants.REGEX_SPECIFIER.matcher(annoName).matches()) {
                        if (!extAnnoName.matches(annoName = annoName.substring(1, annoName.length() - 1))) continue;
                        this.mv = Instrumentor.this.instrumentorFor(om, this.mv, access, name, desc);
                        continue;
                    }
                    if (!annoName.equals(extAnnoName)) continue;
                    this.mv = Instrumentor.this.instrumentorFor(om, this.mv, access, name, desc);
                }
                return this.mv.visitAnnotation(annoDesc, visible);
            }
        };
    }

    private MethodVisitor instrumentorFor(final OnMethod om, MethodVisitor mv, int access, String name, String desc) {
        final Location loc = om.getLocation();
        final Where where = loc.getWhere();
        final Type[] actionArgTypes = Type.getArgumentTypes(om.getTargetDescriptor());
        final int numActionArgs = actionArgTypes.length;
        final LocalVariablesSorter lvs = new LocalVariablesSorter(access, desc, mv);
        switch (loc.getValue()) {
            case ARRAY_GET: {
                return new ArrayAccessInstrumentor(mv, access, name, desc){

                    @Override
                    protected void onBeforeArrayLoad(int opcode) {
                        if (numActionArgs == 2 && where == Where.BEFORE && TypeUtils.getArrayType(opcode).equals(actionArgTypes[0]) && Type.INT_TYPE.equals(actionArgTypes[1])) {
                            this.dup2();
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }

                    @Override
                    protected void onAfterArrayLoad(int opcode) {
                        if (numActionArgs == 1 && where == Where.AFTER && TypeUtils.getElementType(opcode).equals(actionArgTypes[0])) {
                            this.dupArrayValue(opcode);
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }
                };
            }
            case ARRAY_SET: {
                return new ArrayAccessInstrumentor(mv, access, name, desc){
                    private int maxLocal;
                    {
                        super(x0, x1, x2, x3);
                        this.maxLocal = 0;
                    }

                    @Override
                    public void visitCode() {
                        this.maxLocal = this.getArgumentTypes().length;
                        super.visitCode();
                    }

                    @Override
                    public void visitVarInsn(int opcode, int var) {
                        if (var > this.maxLocal) {
                            this.maxLocal = var;
                        }
                        super.visitVarInsn(opcode, var);
                    }

                    @Override
                    protected void onBeforeArrayStore(int opcode) {
                        Type elementType = TypeUtils.getElementType(opcode);
                        if (where == Where.BEFORE && numActionArgs == 3 && TypeUtils.getArrayType(opcode).equals(actionArgTypes[0]) && Type.INT_TYPE.equals(actionArgTypes[1]) && elementType.equals(actionArgTypes[2])) {
                            this.storeLocal(elementType, this.maxLocal + 1);
                            this.dup2();
                            this.loadLocal(elementType, this.maxLocal + 1);
                            Instrumentor.this.invokeBTraceAction(this, om);
                            this.storeLocal(elementType, this.maxLocal + 1);
                        }
                    }

                    @Override
                    protected void onAfterArrayStore(int opcode) {
                        if (numActionArgs == 0 && where == Where.AFTER) {
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }
                };
            }
            case CALL: {
                return new MethodCallInstrumentor(lvs, access, name, desc){
                    private String localClassName;
                    private String localMethodName;
                    private int returnVarIndex;
                    private int[] backupArgsIndexes;
                    {
                        super(x0, x1, x2, x3);
                        this.localClassName = loc.getClazz();
                        this.localMethodName = loc.getMethod();
                        this.returnVarIndex = -1;
                    }

                    private void backupArgs(boolean isStaticCall, Type[] callArgs) {
                        this.backupArgsIndexes = new int[callArgs.length + 1];
                        int upper = callArgs.length - 1;
                        for (int i = 0; i < callArgs.length; ++i) {
                            int index = lvs.newLocal(callArgs[upper - i]);
                            this.storeLocal(callArgs[upper - i], index);
                            this.backupArgsIndexes[i + 1] = index;
                        }
                        if (!isStaticCall) {
                            int index = lvs.newLocal(TypeUtils.objectType);
                            this.storeLocal(TypeUtils.objectType, index);
                            this.backupArgsIndexes[0] = index;
                        }
                    }

                    private void restoreArgs(boolean isStaticCall, Type[] callArgs) {
                        int upper = callArgs.length - 1;
                        if (!isStaticCall) {
                            this.loadLocal(TypeUtils.objectType, this.backupArgsIndexes[0]);
                        }
                        for (int i = callArgs.length - 1; i > -1; --i) {
                            this.loadLocal(callArgs[upper - i], this.backupArgsIndexes[i + 1]);
                        }
                    }

                    private void preMatchAction(boolean isStaticCall, String method, Type[] callArgs, Type returnType, int probeArgsLength) {
                        int argPtrRev = callArgs.length;
                        int argPtr = 0;
                        for (int i = 0; i < probeArgsLength; ++i) {
                            if (i == om.getSelfParameter()) {
                                if (this.isStatic()) continue;
                                this.loadThis();
                                continue;
                            }
                            if (i == om.getCalledMethodParameter()) {
                                super.visitLdcInsn(method);
                                continue;
                            }
                            if (i == om.getCalledInstanceParameter()) {
                                if (isStaticCall) continue;
                                this.loadLocal(TypeUtils.objectType, this.backupArgsIndexes[0]);
                                continue;
                            }
                            if (i == om.getReturnParameter() && returnType != null) {
                                this.loadLocal(returnType, this.returnVarIndex);
                                continue;
                            }
                            this.loadLocal(callArgs[argPtr++], this.backupArgsIndexes[argPtrRev--]);
                        }
                    }

                    private void preAnyTypeAction(boolean isStaticCall, String method, Type[] callArgs, Type returnType, int probeArgsLength) {
                        int upper = callArgs.length - 1;
                        for (int i = 0; i < probeArgsLength; ++i) {
                            if (i == om.getSelfParameter()) {
                                if (this.isStatic()) continue;
                                this.loadThis();
                                continue;
                            }
                            if (i == om.getCalledMethodParameter()) {
                                super.visitLdcInsn(method);
                                continue;
                            }
                            if (i == om.getCalledInstanceParameter()) {
                                if (isStaticCall) continue;
                                this.loadLocal(TypeUtils.objectType, this.backupArgsIndexes[0]);
                                continue;
                            }
                            if (i == om.getReturnParameter() && returnType != null) {
                                this.loadLocal(returnType, this.returnVarIndex);
                                continue;
                            }
                            this.push(callArgs.length);
                            super.visitTypeInsn(189, TypeUtils.objectType.getInternalName());
                            for (int argIndex = 0; argIndex < callArgs.length; ++argIndex) {
                                this.dup();
                                this.push(argIndex);
                                this.loadLocal(callArgs[upper - argIndex], this.backupArgsIndexes[argIndex + 1]);
                                this.box(callArgs[upper - argIndex]);
                                this.arrayStore(TypeUtils.objectType);
                            }
                        }
                    }

                    private void injectBtrace(boolean isStaticCall, boolean usesAnytype, String method, Type[] calledMethodArgs, Type returnType, Type[] actionArgTypes2) {
                        if (usesAnytype) {
                            this.preAnyTypeAction(isStaticCall, method, calledMethodArgs, returnType, actionArgTypes2.length);
                        } else {
                            this.preMatchAction(isStaticCall, method, calledMethodArgs, returnType, actionArgTypes2.length);
                        }
                        Instrumentor.this.invokeBTraceAction(this, om);
                    }

                    @Override
                    protected void onBeforeCallMethod(int opcode, String owner, String name, String desc) {
                        if (this.isStatic() && om.getSelfParameter() > -1) {
                            return;
                        }
                        if (Instrumentor.this.matches(this.localClassName, owner.replace('/', '.')) && Instrumentor.this.matches(this.localMethodName, name) && Instrumentor.this.typeMatches(loc.getType(), desc)) {
                            String method = name + desc;
                            Type[] calledMethodArgs = Type.getArgumentTypes(desc);
                            Type returnType = where == Where.AFTER ? Type.getReturnType(desc) : null;
                            ValidationResult vr = Instrumentor.this.validateArguments(om, this.isStatic(), returnType, actionArgTypes, calledMethodArgs);
                            if (vr != ValidationResult.INVALID) {
                                boolean isStaticCall;
                                boolean bl = isStaticCall = opcode == 184;
                                if (isStaticCall ? om.getCalledInstanceParameter() != -1 : where == Where.BEFORE && name.equals("<init>")) {
                                    return;
                                }
                                this.backupArgs(isStaticCall, calledMethodArgs);
                                if (where == Where.BEFORE) {
                                    this.injectBtrace(opcode == 184, vr == ValidationResult.ANYTYPE, method, calledMethodArgs, returnType, actionArgTypes);
                                }
                                this.restoreArgs(isStaticCall, calledMethodArgs);
                            }
                        }
                    }

                    @Override
                    protected void onAfterCallMethod(int opcode, String owner, String name, String desc) {
                        if (this.isStatic() && om.getSelfParameter() != -1) {
                            return;
                        }
                        if (where == Where.AFTER && Instrumentor.this.matches(this.localClassName, owner.replace('/', '.')) && Instrumentor.this.matches(this.localMethodName, name) && Instrumentor.this.typeMatches(loc.getType(), desc)) {
                            Type returnType = Type.getReturnType(desc);
                            Type[] calledMethodArgs = Type.getArgumentTypes(desc);
                            ValidationResult vr = Instrumentor.this.validateArguments(om, this.isStatic(), returnType, actionArgTypes, calledMethodArgs);
                            if (vr != ValidationResult.INVALID) {
                                boolean withReturn;
                                String method = name + desc;
                                boolean bl = withReturn = om.getReturnParameter() != -1 && returnType != Type.VOID_TYPE;
                                if (withReturn) {
                                    int index = lvs.newLocal(returnType);
                                    this.storeLocal(returnType, index);
                                    this.returnVarIndex = index;
                                }
                                this.injectBtrace(opcode == 184, vr == ValidationResult.ANYTYPE, method, calledMethodArgs, returnType, actionArgTypes);
                                if (withReturn) {
                                    this.loadLocal(returnType, this.returnVarIndex);
                                }
                            }
                        }
                    }
                };
            }
            case CATCH: {
                return new CatchInstrumentor(mv, access, name, desc){

                    @Override
                    protected void onCatch(String type) {
                        if (numActionArgs == 1 && Type.getObjectType(type).equals(actionArgTypes[0])) {
                            this.dup();
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }
                };
            }
            case CHECKCAST: {
                return new TypeCheckInstrumentor(mv, access, name, desc){

                    private void callAction(int opcode, String desc) {
                        if (opcode == 192 && numActionArgs == 1 && Type.getType(desc).equals(actionArgTypes[0])) {
                            this.dup();
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }

                    @Override
                    protected void onBeforeTypeCheck(int opcode, String desc) {
                        if (where == Where.BEFORE) {
                            this.callAction(opcode, desc);
                        }
                    }

                    @Override
                    protected void onAfterTypeCheck(int opcode, String desc) {
                        if (where == Where.AFTER) {
                            this.callAction(opcode, desc);
                        }
                    }
                };
            }
            case ENTRY: {
                return new MethodEntryInstrumentor(lvs, access, name, desc){

                    private void preMatchAction(Type[] args, int probeArgsLength) {
                        int argPtr = this.isStatic() ? 0 : 1;
                        int argIndex = 0;
                        for (int i = 0; i < probeArgsLength; ++i) {
                            if (i == om.getSelfParameter()) {
                                if (this.isStatic()) continue;
                                this.loadThis();
                                continue;
                            }
                            this.loadLocal(args[argIndex], argPtr);
                            argPtr += args[argIndex].getSize();
                            ++argIndex;
                        }
                    }

                    private void preAnyTypeAction(Type[] args, int probeArgsLength) {
                        int argPtr = this.isStatic() ? 0 : 1;
                        for (int i = 0; i < probeArgsLength; ++i) {
                            if (i == om.getSelfParameter()) {
                                if (this.isStatic()) continue;
                                this.loadThis();
                                continue;
                            }
                            this.push(args.length);
                            super.visitTypeInsn(189, TypeUtils.objectType.getInternalName());
                            for (int argIndex = 0; argIndex < args.length; ++argIndex) {
                                this.dup();
                                this.push(argIndex);
                                Type argType = args[argIndex];
                                this.loadLocal(argType, argPtr);
                                this.box(argType);
                                this.arrayStore(TypeUtils.objectType);
                                argPtr += argType.getSize();
                            }
                        }
                    }

                    private void injectBtrace(boolean usesAnytype, Type[] calledMethodArgs, Type[] actionArgTypes2) {
                        if (usesAnytype) {
                            this.preAnyTypeAction(calledMethodArgs, actionArgTypes2.length);
                        } else {
                            this.preMatchAction(calledMethodArgs, actionArgTypes2.length);
                        }
                        Instrumentor.this.invokeBTraceAction(this, om);
                    }

                    private void callAction() {
                        if (this.isStatic() && om.getSelfParameter() > -1) {
                            return;
                        }
                        Type[] calledMethodArgs = this.getArgumentTypes();
                        ValidationResult vr = Instrumentor.this.validateArguments(om, this.isStatic(), Type.getReturnType(this.getDescriptor()), actionArgTypes, calledMethodArgs);
                        if (vr != ValidationResult.INVALID) {
                            this.injectBtrace(vr == ValidationResult.ANYTYPE, calledMethodArgs, actionArgTypes);
                        }
                    }

                    @Override
                    protected void onMethodEntry() {
                        if (numActionArgs == 0) {
                            Instrumentor.this.invokeBTraceAction(this, om);
                        } else {
                            this.callAction();
                        }
                    }
                };
            }
            case ERROR: {
                return new ErrorReturnInstrumentor(mv, access, name, desc){

                    @Override
                    protected void onErrorReturn() {
                        switch (numActionArgs) {
                            case 0: {
                                Instrumentor.this.invokeBTraceAction(this, om);
                                break;
                            }
                            case 1: {
                                if (!TypeUtils.isThrowable(actionArgTypes[0])) break;
                                this.dup();
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                        }
                    }
                };
            }
            case FIELD_GET: {
                return new FieldAccessInstrumentor(mv, access, name, desc){
                    private String className;
                    private String fieldName;
                    {
                        super(x0, x1, x2, x3);
                        this.className = loc.getClazz();
                        this.fieldName = loc.getField();
                    }

                    @Override
                    protected void onBeforeGetField(int opcode, String owner, String name, String desc) {
                        if (where == Where.BEFORE && Instrumentor.this.matches(this.className, owner.replace('/', '.')) && Instrumentor.this.matches(this.fieldName, name)) {
                            if (opcode == 180) {
                                switch (numActionArgs) {
                                    case 0: {
                                        Instrumentor.this.invokeBTraceAction(this, om);
                                        break;
                                    }
                                    case 1: {
                                        if (!TypeUtils.isObject(actionArgTypes[0]) && !TypeUtils.isCompatible(actionArgTypes[0], Type.getObjectType(owner))) break;
                                        this.dup();
                                        Instrumentor.this.invokeBTraceAction(this, om);
                                    }
                                }
                            } else if (opcode == 178 && numActionArgs == 0) {
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                        }
                    }

                    @Override
                    protected void onAfterGetField(int opcode, String owner, String name, String desc) {
                        if (where == Where.AFTER && Instrumentor.this.matches(this.className, owner.replace('/', '.')) && Instrumentor.this.matches(this.fieldName, name)) {
                            switch (numActionArgs) {
                                case 0: {
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                    break;
                                }
                                case 1: {
                                    if (!TypeUtils.isObject(actionArgTypes[0]) && !TypeUtils.isCompatible(actionArgTypes[0], Type.getType(desc))) break;
                                    this.dupValue(desc);
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                }
                            }
                        }
                    }
                };
            }
            case FIELD_SET: {
                return new FieldAccessInstrumentor(mv, access, name, desc){
                    private String className;
                    private String fieldName;
                    private int maxLocal;
                    {
                        super(x0, x1, x2, x3);
                        this.className = loc.getClazz();
                        this.fieldName = loc.getField();
                        this.maxLocal = 0;
                    }

                    @Override
                    public void visitCode() {
                        this.maxLocal = this.getArgumentTypes().length;
                        super.visitCode();
                    }

                    @Override
                    public void visitVarInsn(int opcode, int var) {
                        if (var > this.maxLocal) {
                            this.maxLocal = var;
                        }
                        super.visitVarInsn(opcode, var);
                    }

                    @Override
                    protected void onBeforePutField(int opcode, String owner, String name, String desc) {
                        if (where == Where.BEFORE && Instrumentor.this.matches(this.className, owner.replace('/', '.')) && Instrumentor.this.matches(this.fieldName, name)) {
                            block0 : switch (numActionArgs) {
                                case 0: {
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                    break;
                                }
                                case 2: {
                                    Type fieldType = Type.getType(desc);
                                    if (!TypeUtils.isObject(actionArgTypes[0]) && !TypeUtils.isCompatible(actionArgTypes[0], Type.getObjectType(owner)) || !fieldType.equals(actionArgTypes[1])) break;
                                    switch (fieldType.getSize()) {
                                        case 1: {
                                            this.dup2();
                                            Instrumentor.this.invokeBTraceAction(this, om);
                                            break block0;
                                        }
                                        case 2: {
                                            this.storeLocal(fieldType, this.maxLocal + 1);
                                            this.dup();
                                            this.loadLocal(fieldType, this.maxLocal + 1);
                                            Instrumentor.this.invokeBTraceAction(this, om);
                                            this.loadLocal(fieldType, this.maxLocal + 1);
                                        }
                                    }
                                }
                            }
                        }
                    }

                    @Override
                    protected void onAfterPutField(int opcode, String owner, String name, String desc) {
                        if (where == Where.AFTER && Instrumentor.this.matches(this.className, owner) && Instrumentor.this.matches(this.fieldName, name) && numActionArgs == 0) {
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }
                };
            }
            case INSTANCEOF: {
                return new TypeCheckInstrumentor(mv, access, name, desc){

                    private void callAction(int opcode, String desc) {
                        if (numActionArgs == 1 && opcode == 193) {
                            this.dup();
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }

                    @Override
                    protected void onBeforeTypeCheck(int opcode, String desc) {
                        if (where == Where.BEFORE && Type.getType(desc).equals(actionArgTypes[0])) {
                            this.callAction(opcode, desc);
                        }
                    }

                    @Override
                    protected void onAfterTypeCheck(int opcode, String desc) {
                        if (where == Where.AFTER && Type.BOOLEAN_TYPE.equals(actionArgTypes[0])) {
                            this.callAction(opcode, desc);
                        }
                    }
                };
            }
            case LINE: {
                return new LineNumberInstrumentor(mv, access, name, desc){
                    private int onLine;
                    {
                        super(x0, x1, x2, x3);
                        this.onLine = loc.getLine();
                    }

                    private void callOnLine(int line) {
                        if (numActionArgs == 0) {
                            Instrumentor.this.invokeBTraceAction(this, om);
                        } else if (numActionArgs == 1 && actionArgTypes[0].equals(Type.INT_TYPE)) {
                            this.push(line);
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }

                    @Override
                    protected void onBeforeLine(int line) {
                        if ((line == this.onLine || this.onLine == -1) && where == Where.BEFORE) {
                            this.callOnLine(line);
                        }
                    }

                    @Override
                    protected void onAfterLine(int line) {
                        if ((line == this.onLine || this.onLine == -1) && where == Where.AFTER) {
                            this.callOnLine(line);
                        }
                    }
                };
            }
            case NEW: {
                return new ObjectAllocInstrumentor(mv, access, name, desc){

                    @Override
                    protected void onObjectNew(String desc) {
                        String extName = desc.replace('/', '.');
                        if (Instrumentor.this.matches(loc.getClazz(), extName)) {
                            switch (numActionArgs) {
                                case 0: {
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                    break;
                                }
                                case 1: {
                                    if (!TypeUtils.isString(actionArgTypes[0])) break;
                                    this.visitLdcInsn(extName);
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                }
                            }
                        }
                    }
                };
            }
            case NEWARRAY: {
                return new ArrayAllocInstrumentor(mv, access, name, desc){

                    @Override
                    protected void onBeforeArrayNew(String desc, int dims) {
                        if (numActionArgs == 0 && where == Where.BEFORE) {
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }

                    @Override
                    protected void onAfterArrayNew(String desc, int dims) {
                        if (where == Where.AFTER && numActionArgs == 1 && TypeUtils.isCompatible(actionArgTypes[0], Type.getType(desc))) {
                            this.dup();
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }
                };
            }
            case RETURN: {
                return new MethodReturnInstrumentor(mv, access, name, desc){

                    private void callAction(int retOpCode) {
                        ValidationResult vr = Instrumentor.this.validateArguments(om, this.isStatic(), this.getReturnType(), actionArgTypes, this.getArgumentTypes());
                        switch (vr) {
                            case INVALID: {
                                return;
                            }
                            case ANYTYPE: {
                                int returnIndex = this.backupReturnValue();
                                int i = 0;
                                while (i < actionArgTypes.length) {
                                    if (i == om.getSelfParameter()) {
                                        this.loadThis();
                                        continue;
                                    }
                                    if (i == om.getReturnParameter()) {
                                        if (returnIndex == -1) continue;
                                        this.loadLocal(this.getReturnType(), returnIndex);
                                        continue;
                                    }
                                    this.loadArgumentArray();
                                }
                                Instrumentor.this.invokeBTraceAction(this, om);
                                this.loadLocal(this.getReturnType(), returnIndex);
                                break;
                            }
                            case MATCH: {
                                int returnIndex = this.backupReturnValue();
                                int argIndex = this.isStatic() ? 0 : 1;
                                for (int argCnt = 0; argCnt < actionArgTypes.length; ++argCnt) {
                                    if (argCnt == om.getSelfParameter()) {
                                        this.loadThis();
                                        continue;
                                    }
                                    if (argCnt == om.getReturnParameter()) {
                                        if (returnIndex == -1) continue;
                                        this.loadLocal(this.getReturnType(), returnIndex);
                                        continue;
                                    }
                                    Type t = actionArgTypes[argCnt];
                                    this.loadLocal(t, argIndex);
                                    argIndex += t.getSize();
                                }
                                Instrumentor.this.invokeBTraceAction(this, om);
                                this.loadLocal(this.getReturnType(), returnIndex);
                            }
                        }
                    }

                    private int backupReturnValue() {
                        Type type = this.getReturnType();
                        if (type == Type.VOID_TYPE) {
                            return -1;
                        }
                        int varIndex = lvs.newLocal(type);
                        this.storeLocal(type, varIndex);
                        return varIndex;
                    }

                    @Override
                    protected void onMethodReturn(int opcode) {
                        if (numActionArgs == 0) {
                            Instrumentor.this.invokeBTraceAction(this, om);
                        } else {
                            this.callAction(opcode);
                        }
                    }
                };
            }
            case SYNC_ENTRY: {
                return new SynchronizedInstrumentor(this.className, mv, access, name, desc){

                    private void callAction() {
                        switch (numActionArgs) {
                            case 0: {
                                Instrumentor.this.invokeBTraceAction(this, om);
                                break;
                            }
                            case 1: {
                                if (!TypeUtils.isObjectOrAnyType(actionArgTypes[0])) break;
                                this.dup();
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                        }
                    }

                    @Override
                    protected void onBeforeSyncEntry() {
                        if (where == Where.BEFORE) {
                            this.callAction();
                        }
                    }

                    @Override
                    protected void onAfterSyncEntry() {
                        if (where == Where.AFTER) {
                            this.callAction();
                        }
                    }

                    @Override
                    protected void onBeforeSyncExit() {
                    }

                    @Override
                    protected void onAfterSyncExit() {
                    }
                };
            }
            case SYNC_EXIT: {
                return new SynchronizedInstrumentor(this.className, mv, access, name, desc){

                    private void callAction() {
                        switch (numActionArgs) {
                            case 0: {
                                Instrumentor.this.invokeBTraceAction(this, om);
                                break;
                            }
                            case 1: {
                                if (!TypeUtils.isObjectOrAnyType(actionArgTypes[0])) break;
                                this.dup();
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                        }
                    }

                    @Override
                    protected void onBeforeSyncEntry() {
                    }

                    @Override
                    protected void onAfterSyncEntry() {
                    }

                    @Override
                    protected void onBeforeSyncExit() {
                        if (where == Where.BEFORE) {
                            this.callAction();
                        }
                    }

                    @Override
                    protected void onAfterSyncExit() {
                        if (where == Where.AFTER) {
                            this.callAction();
                        }
                    }
                };
            }
            case THROW: {
                return new ThrowInstrumentor(mv, access, name, desc){

                    @Override
                    protected void onThrow() {
                        switch (numActionArgs) {
                            case 0: {
                                Instrumentor.this.invokeBTraceAction(this, om);
                                break;
                            }
                            case 1: {
                                if (!TypeUtils.isThrowable(actionArgTypes[0])) break;
                                this.dup();
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                        }
                    }
                };
            }
        }
        return mv;
    }

    private CallValidationResult validateCall(String selfClassName, String instanceClassName, OnMethod om, Type[] calledMethodArgs, Type returnType, Type[] actionArgTypes, int numActionArgs) {
        int extraArgCount = (om.getReturnParameter() > -1 ? 1 : 0) + (om.getCalledMethodParameter() > -1 ? 1 : 0) + (om.getSelfParameter() > -1 ? 1 : 0) + (om.getCalledInstanceParameter() > -1 ? 1 : 0);
        boolean extraArgsValid = true;
        int anyTypeIndex = -1;
        if (calledMethodArgs.length + extraArgCount == numActionArgs) {
            Type[] tmp = new Type[numActionArgs - extraArgCount];
            int counter = 0;
            for (int i = 0; i < numActionArgs; ++i) {
                if (om.getCalledMethodParameter() == i) {
                    extraArgsValid &= TypeUtils.isString(actionArgTypes[i]);
                    continue;
                }
                if (om.getSelfParameter() == i) {
                    extraArgsValid &= TypeUtils.isObject(actionArgTypes[i]) || TypeUtils.isCompatible(actionArgTypes[i], Type.getObjectType(selfClassName));
                    continue;
                }
                if (om.getCalledInstanceParameter() == i) {
                    extraArgsValid &= TypeUtils.isObject(actionArgTypes[i]) || TypeUtils.isCompatible(actionArgTypes[i], Type.getObjectType(instanceClassName));
                    continue;
                }
                if (returnType != null && om.getReturnParameter() == i) {
                    extraArgsValid &= TypeUtils.isCompatible(actionArgTypes[i], returnType);
                    continue;
                }
                if (anyTypeIndex > -1) {
                    extraArgsValid = false;
                    break;
                }
                if (TypeUtils.isAnyTypeArray(actionArgTypes[i])) {
                    anyTypeIndex = i;
                }
                tmp[counter++] = actionArgTypes[i];
            }
            return new CallValidationResult(extraArgsValid && (anyTypeIndex > -1 || TypeUtils.isCompatible(tmp, calledMethodArgs)), anyTypeIndex > -1);
        }
        return new CallValidationResult(false, false);
    }

    @Override
    public void visitEnd() {
        int size = this.applicableOnMethods.size();
        ArrayList<MethodCopier.MethodInfo> mi = new ArrayList<MethodCopier.MethodInfo>(size);
        for (OnMethod om : this.calledOnMethods) {
            mi.add(new MethodCopier.MethodInfo(om.getTargetName(), om.getTargetDescriptor(), this.getActionMethodName(om.getTargetName()), 10));
        }
        MethodCopier copier = new MethodCopier(this.btraceClass, this.cv, mi){

            @Override
            protected MethodVisitor addMethod(int access, String name, String desc, String signature, String[] exceptions) {
                desc = desc.replace(Constants.ANYTYPE_DESC, Constants.OBJECT_DESC);
                if (signature != null) {
                    signature = signature.replace(Constants.ANYTYPE_DESC, Constants.OBJECT_DESC);
                }
                return super.addMethod(access, name, desc, signature, exceptions);
            }
        };
        copier.visitEnd();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: java com.sun.btrace.runtime.Instrumentor <btrace-class> <target-class>]");
            System.exit(1);
        }
        String className = args[0].replace('.', '/') + ".class";
        FileInputStream fis = new FileInputStream(className);
        byte[] buf = new byte[(int)new File(className).length()];
        fis.read(buf);
        fis.close();
        ClassWriter writer = InstrumentUtils.newClassWriter();
        Verifier verifier = new Verifier(new Preprocessor(writer));
        InstrumentUtils.accept(new ClassReader(buf), verifier);
        buf = writer.toByteArray();
        FileOutputStream fos = new FileOutputStream(className);
        fos.write(buf);
        fos.close();
        String targetClass = args[1].replace('.', '/') + ".class";
        fis = new FileInputStream(targetClass);
        writer = InstrumentUtils.newClassWriter();
        ClassReader reader = new ClassReader(fis);
        InstrumentUtils.accept(reader, new Instrumentor(null, verifier.getClassName(), buf, verifier.getOnMethods(), (ClassVisitor)writer));
        fos = new FileOutputStream(targetClass);
        fos.write(writer.toByteArray());
    }

    private String getActionMethodName(String name) {
        return "$btrace$" + this.btraceClassName.replace('/', '$') + "$" + name;
    }

    private void invokeBTraceAction(MethodInstrumentor mv, OnMethod om) {
        mv.invokeStatic(this.className, this.getActionMethodName(om.getTargetName()), om.getTargetDescriptor().replace(Constants.ANYTYPE_DESC, Constants.OBJECT_DESC));
        this.calledOnMethods.add(om);
    }

    private boolean matches(String pattern, String input) {
        if (pattern.length() == 0) {
            return false;
        }
        if (pattern.charAt(0) == '/' && Constants.REGEX_SPECIFIER.matcher(pattern).matches()) {
            return input.matches(pattern.substring(1, pattern.length() - 1));
        }
        return pattern.equals(input);
    }

    private boolean typeMatches(String decl, String desc) {
        if (decl.isEmpty()) {
            return true;
        }
        String d = TypeUtils.declarationToDescriptor(decl);
        Type[] args1 = Type.getArgumentTypes(d);
        Type[] args2 = Type.getArgumentTypes(desc);
        return TypeUtils.isCompatible(args1, args2);
    }

    private static boolean isInArray(String[] candidates, String given) {
        for (String c : candidates) {
            if (!c.equals(given)) continue;
            return true;
        }
        return false;
    }

    private ValidationResult validateArguments(OnMethod om, boolean staticFlag, Type returnType, Type[] actionArgTypes, Type[] methodArgTypes) {
        int specialArgsCount = 0;
        if (om.getSelfParameter() != -1) {
            if (staticFlag) {
                return ValidationResult.INVALID;
            }
            if (!TypeUtils.isObject(actionArgTypes[om.getSelfParameter()]) && !TypeUtils.isCompatible(actionArgTypes[om.getSelfParameter()], Type.getObjectType(this.className))) {
                return ValidationResult.INVALID;
            }
            ++specialArgsCount;
        }
        if (om.getReturnParameter() != -1) {
            if (!TypeUtils.isCompatible(actionArgTypes[om.getReturnParameter()], returnType) || returnType == null) {
                return ValidationResult.INVALID;
            }
            ++specialArgsCount;
        }
        if (om.getCalledMethodParameter() != -1) {
            if (!TypeUtils.isCompatible(actionArgTypes[om.getCalledMethodParameter()], Type.getType(String.class))) {
                return ValidationResult.INVALID;
            }
            ++specialArgsCount;
        }
        if (om.getCalledInstanceParameter() != -1) {
            if (!TypeUtils.isObject(actionArgTypes[om.getCalledInstanceParameter()])) {
                return ValidationResult.INVALID;
            }
            ++specialArgsCount;
        }
        Type[] cleansedArgArray = new Type[actionArgTypes.length - specialArgsCount];
        int counter = 0;
        for (int argIndex = 0; argIndex < actionArgTypes.length; ++argIndex) {
            if (argIndex == om.getSelfParameter() || argIndex == om.getReturnParameter() || argIndex == om.getCalledInstanceParameter() || argIndex == om.getCalledMethodParameter()) continue;
            cleansedArgArray[counter++] = actionArgTypes[argIndex];
        }
        if (cleansedArgArray.length == 1 && TypeUtils.isAnyTypeArray(cleansedArgArray[0])) {
            return ValidationResult.ANYTYPE;
        }
        if (cleansedArgArray.length > 0 && !TypeUtils.isCompatible(cleansedArgArray, methodArgTypes)) {
            return ValidationResult.INVALID;
        }
        return ValidationResult.MATCH;
    }

    private static class CallValidationResult {
        public final boolean callValid;
        public final boolean usesAnytype;

        public CallValidationResult(boolean callValid, boolean usesAnytype) {
            this.callValid = callValid;
            this.usesAnytype = usesAnytype;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CallValidationResult other = (CallValidationResult)obj;
            if (this.callValid != other.callValid) {
                return false;
            }
            return this.usesAnytype == other.usesAnytype;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this.callValid ? 1 : 0);
            hash = 79 * hash + (this.usesAnytype ? 1 : 0);
            return hash;
        }
    }

    private static enum ValidationResult {
        INVALID,
        MATCH,
        ANYTYPE;

    }
}

