/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.agent;

import com.sun.btrace.BTraceRuntime;
import com.sun.btrace.agent.Client;
import com.sun.btrace.agent.FileClient;
import com.sun.btrace.agent.ProbeDescriptorLoader;
import com.sun.btrace.agent.RemoteClient;
import com.sun.btrace.runtime.OnMethod;
import com.sun.btrace.runtime.OnProbe;
import com.sun.btrace.runtime.ProbeDescriptor;
import com.sun.btrace.util.Messages;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.JarFile;

public final class Main {
    private static volatile Map<String, String> argMap;
    private static volatile Instrumentation inst;
    private static volatile boolean debugMode;
    private static volatile boolean unsafeMode;
    private static volatile boolean dumpClasses;
    private static volatile String dumpDir;
    private static volatile String probeDescPath;
    private static final ExecutorService serializedExecutor;
    public static final int BTRACE_DEFAULT_PORT = 2020;

    public static void premain(String args, Instrumentation inst) {
        Main.main(args, inst);
    }

    public static void agentmain(String args, Instrumentation inst) {
        Main.main(args, inst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void main(String args, Instrumentation inst) {
        String tmp;
        boolean noServer;
        String systemClassPath;
        String bootClassPath;
        if (Main.inst != null) {
            return;
        }
        Main.inst = inst;
        if (Main.isDebug()) {
            Main.debugPrint("parsing command line arguments");
        }
        Main.parseArgs(args);
        if (Main.isDebug()) {
            Main.debugPrint("parsed command line arguments");
        }
        if ((bootClassPath = argMap.get("bootClassPath")) != null) {
            if (Main.isDebug()) {
                Main.debugPrint("Bootstrap ClassPath: " + bootClassPath);
            }
            StringTokenizer tokenizer = new StringTokenizer(bootClassPath, File.pathSeparator);
            try {
                while (tokenizer.hasMoreTokens()) {
                    String path = tokenizer.nextToken();
                    inst.appendToBootstrapClassLoaderSearch(new JarFile(new File(path)));
                }
            }
            catch (IOException ex) {
                Main.debugPrint("adding to boot classpath failed!");
                Main.debugPrint(ex);
                return;
            }
        }
        if ((systemClassPath = argMap.get("systemClassPath")) != null) {
            if (Main.isDebug()) {
                Main.debugPrint("System ClassPath: " + systemClassPath);
            }
            StringTokenizer tokenizer = new StringTokenizer(systemClassPath, File.pathSeparator);
            try {
                while (tokenizer.hasMoreTokens()) {
                    String path = tokenizer.nextToken();
                    inst.appendToSystemClassLoaderSearch(new JarFile(new File(path)));
                }
            }
            catch (IOException ex) {
                Main.debugPrint("adding to boot classpath failed!");
                Main.debugPrint(ex);
                return;
            }
        }
        boolean bl = noServer = (tmp = argMap.get("noServer")) != null && !"false".equals(tmp);
        if (noServer) {
            if (Main.isDebug()) {
                Main.debugPrint("noServer is true, server not started");
            }
            return;
        }
        Thread agentThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BTraceRuntime.enter();
                try {
                    Main.startServer();
                }
                finally {
                    BTraceRuntime.leave();
                }
            }
        });
        BTraceRuntime.enter();
        try {
            agentThread.setDaemon(true);
            if (Main.isDebug()) {
                Main.debugPrint("starting agent thread");
            }
            agentThread.start();
        }
        finally {
            BTraceRuntime.leave();
        }
    }

    private static void usage() {
        System.out.println(Messages.get("btrace.agent.usage"));
        System.exit(0);
    }

    private static void parseArgs(String args) {
        block27: {
            boolean traceToStdOut;
            if (args == null) {
                args = "";
            }
            String[] pairs = args.split(",");
            argMap = new HashMap<String, String>();
            for (String s : pairs) {
                String key;
                int i = s.indexOf(61);
                String value = "";
                if (i != -1) {
                    key = s.substring(0, i).trim();
                    if (i + 1 < s.length()) {
                        value = s.substring(i + 1).trim();
                    }
                } else {
                    key = s;
                }
                argMap.put(key, value);
            }
            String p = argMap.get("help");
            if (p != null) {
                Main.usage();
            }
            boolean bl = debugMode = (p = argMap.get("debug")) != null && !"false".equals(p);
            if (Main.isDebug()) {
                Main.debugPrint("debugMode is " + debugMode);
            }
            p = argMap.get("unsafe");
            unsafeMode = "true".equals(p);
            if (Main.isDebug()) {
                Main.debugPrint("unsafeMode is " + unsafeMode);
            }
            boolean bl2 = dumpClasses = (p = argMap.get("dumpClasses")) != null && !"false".equals(p);
            if (Main.isDebug()) {
                Main.debugPrint("dumpClasses is " + dumpClasses);
            }
            if (dumpClasses) {
                dumpDir = argMap.get("dumpDir");
                if (dumpDir == null) {
                    dumpDir = ".";
                }
                if (Main.isDebug()) {
                    Main.debugPrint("dumpDir is " + dumpDir);
                }
            }
            boolean bl3 = traceToStdOut = (p = argMap.get("stdout")) != null && !"false".equals(p);
            if (Main.isDebug()) {
                Main.debugPrint("stdout is " + traceToStdOut);
            }
            if ((probeDescPath = argMap.get("probeDescPath")) == null) {
                probeDescPath = ".";
            }
            if (Main.isDebug()) {
                Main.debugPrint("probe descriptor path is " + probeDescPath);
            }
            ProbeDescriptorLoader.init(probeDescPath);
            p = argMap.get("script");
            if (p != null) {
                if (Main.isDebug()) {
                    Main.debugPrint("initial script is " + p);
                }
                try {
                    if (!p.endsWith(".class")) {
                        if (Main.isDebug()) {
                            Main.debugPrint("script should be a pre-compiled .class file");
                        }
                        return;
                    }
                    File traceScript = new File(p);
                    if (!traceScript.exists()) {
                        if (Main.isDebug()) {
                            Main.debugPrint("script " + traceScript + " does not exist!");
                        }
                        return;
                    }
                    PrintWriter traceWriter = null;
                    traceWriter = traceToStdOut ? new PrintWriter(System.out) : new PrintWriter(new BufferedWriter(new FileWriter(new File(p + ".btrace"))));
                    FileClient client = new FileClient(inst, traceScript, traceWriter);
                    Main.handleNewClient(client);
                }
                catch (RuntimeException re) {
                    if (Main.isDebug()) {
                        Main.debugPrint(re);
                    }
                }
                catch (IOException ioexp) {
                    if (Main.isDebug()) {
                        Main.debugPrint(ioexp);
                    }
                }
                catch (UnmodifiableClassException uce) {
                    if (!Main.isDebug()) break block27;
                    Main.debugPrint(uce);
                }
            }
        }
    }

    public static void handleFlashLightClient(byte[] code, PrintWriter traceWriter) {
        block6: {
            try {
                FileClient fc = new FileClient(inst, code, traceWriter);
                fc.setFlashlightClient(true);
                Main.handleNewClient(fc);
            }
            catch (RuntimeException re) {
                if (Main.isDebug()) {
                    Main.debugPrint(re);
                }
            }
            catch (IOException ioexp) {
                if (Main.isDebug()) {
                    Main.debugPrint(ioexp);
                }
            }
            catch (UnmodifiableClassException uce) {
                if (!Main.isDebug()) break block6;
                Main.debugPrint(uce);
            }
        }
    }

    public static void handleFlashLightClient(byte[] code) {
        block2: {
            try {
                String twn = new String("flashlighttrace" + new Date().getTime());
                PrintWriter traceWriter = null;
                traceWriter = new PrintWriter(new BufferedWriter(new FileWriter(new File(twn + ".btrace"))));
                Main.handleFlashLightClient(code, traceWriter);
            }
            catch (IOException ioexp) {
                if (!Main.isDebug()) break block2;
                Main.debugPrint(ioexp);
            }
        }
    }

    private static void startServer() {
        ServerSocket ss;
        int port = 2020;
        String p = argMap.get("port");
        if (p != null) {
            try {
                port = Integer.parseInt(p);
            }
            catch (NumberFormatException exp) {
                Main.error("invalid port assuming default..");
            }
        }
        try {
            if (Main.isDebug()) {
                Main.debugPrint("starting server at " + port);
            }
            System.setProperty("btrace.port", String.valueOf(port));
            ss = new ServerSocket(port);
        }
        catch (IOException ioexp) {
            ioexp.printStackTrace();
            return;
        }
        while (true) {
            try {
                while (true) {
                    if (Main.isDebug()) {
                        Main.debugPrint("waiting for clients");
                    }
                    Socket sock = ss.accept();
                    if (Main.isDebug()) {
                        Main.debugPrint("client accepted " + sock);
                    }
                    RemoteClient client = new RemoteClient(inst, sock);
                    Main.handleNewClient(client);
                }
            }
            catch (RuntimeException re) {
                if (!Main.isDebug()) continue;
                Main.debugPrint(re);
                continue;
            }
            catch (IOException ioexp) {
                if (!Main.isDebug()) continue;
                Main.debugPrint(ioexp);
                continue;
            }
            catch (UnmodifiableClassException uce) {
                if (!Main.isDebug()) continue;
                Main.debugPrint(uce);
                continue;
            }
            break;
        }
    }

    private static void handleNewClient(Client client) throws UnmodifiableClassException, IOException {
        if (Main.isDebug()) {
            Main.debugPrint("new Client created " + client);
        }
        if (client.shouldAddTransformer()) {
            Class[] classes = inst.getAllLoadedClasses();
            ArrayList<Class> list = new ArrayList<Class>();
            if (Main.isDebug()) {
                Main.debugPrint("filtering loaded classes");
            }
            for (Class c : classes) {
                if (!inst.isModifiableClass(c) || !client.isCandidate(c)) continue;
                if (Main.isDebug()) {
                    Main.debugPrint("candidate " + c + " added");
                }
                list.add(c);
            }
            list.trimToSize();
            int size = list.size();
            if (Main.isDebug()) {
                Main.debugPrint("added as ClassFileTransformer");
            }
            inst.addTransformer(client, true);
            if (size > 0) {
                classes = new Class[size];
                list.toArray(classes);
                if (Main.isDebug()) {
                    Main.debugPrint("calling retransformClasses");
                }
                inst.retransformClasses(classes);
                client.skipRetransforms();
                if (Main.isDebug()) {
                    Main.debugPrint("finished retransformClasses");
                }
            }
        }
    }

    private static void error(String msg) {
        System.err.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dumpClass(String btraceClassName, String targetClassName, byte[] code) {
        if (dumpClasses) {
            try {
                targetClassName = targetClassName.replace(".", File.separator).replace("/", File.separator);
                int index = targetClassName.lastIndexOf(File.separatorChar);
                StringBuilder buf = new StringBuilder();
                if (!dumpDir.equals(".")) {
                    buf.append(dumpDir);
                    buf.append(File.separatorChar);
                }
                String dir = buf.toString();
                if (index != -1) {
                    dir = dir + targetClassName.substring(0, index);
                }
                new File(dir).mkdirs();
                String file = index != -1 ? targetClassName.substring(index + 1) : targetClassName;
                file = file + ".class";
                File out = new File(dir, file);
                FileOutputStream fos = new FileOutputStream(out);
                try {
                    fos.write(code);
                }
                finally {
                    fos.close();
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    static List<OnMethod> mapOnProbes(List<OnProbe> onProbes) {
        ArrayList<OnMethod> res = new ArrayList<OnMethod>();
        for (OnProbe op : onProbes) {
            ProbeDescriptor probeDesc;
            String ns = op.getNamespace();
            if (Main.isDebug()) {
                Main.debugPrint("about to load probe descriptor for " + ns);
            }
            if ((probeDesc = ProbeDescriptorLoader.load(ns)) == null) {
                if (!Main.isDebug()) continue;
                Main.debugPrint("failed to find probe descriptor for " + ns);
                continue;
            }
            OnProbe foundProbe = probeDesc.findProbe(op.getName());
            if (foundProbe == null) {
                if (!Main.isDebug()) continue;
                Main.debugPrint("no probe mappings for " + op.getName());
                continue;
            }
            if (Main.isDebug()) {
                Main.debugPrint("found probe mappings for " + op.getName());
            }
            Collection<OnMethod> omColl = foundProbe.getOnMethods();
            for (OnMethod om : omColl) {
                OnMethod omn = new OnMethod();
                omn.copyFrom(om);
                omn.setTargetName(op.getTargetName());
                omn.setTargetDescriptor(op.getTargetDescriptor());
                res.add(omn);
            }
        }
        return res;
    }

    static boolean isDebug() {
        return debugMode;
    }

    static boolean isUnsafe() {
        return unsafeMode;
    }

    static void debugPrint(String msg) {
        System.out.println("btrace DEBUG: " + msg);
    }

    static void debugPrint(Throwable th) {
        System.out.println("btrace DEBUG: " + th);
        th.printStackTrace();
    }

    static {
        serializedExecutor = Executors.newSingleThreadExecutor();
    }
}

