/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchContext;
import ghidra.feature.vt.gui.provider.onetomany.VTMatchOneToManyContext;
import ghidra.feature.vt.gui.task.AcceptMatchTask;
import ghidra.util.HelpLocation;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class AcceptMatchAction
extends DockingAction {
    private static final String MENU_GROUP = "A_VT_Edit_1";
    private final VTController controller;

    public AcceptMatchAction(VTController controller) {
        super("Accept", VTPlugin.OWNER);
        this.controller = controller;
        ImageIcon icon = ResourceManager.loadImage((String)"images/flag.png");
        this.setToolBarData(new ToolBarData((Icon)icon, MENU_GROUP));
        this.setPopupMenuData(new MenuData(new String[]{"Accept"}, (Icon)icon, MENU_GROUP));
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Accept_Match"));
    }

    public void actionPerformed(ActionContext context) {
        List<VTMatch> selectedMatches;
        if (context instanceof VTMatchContext) {
            matchContext = (VTMatchContext)context;
            selectedMatches = matchContext.getSelectedMatches();
        } else if (context instanceof VTMatchOneToManyContext) {
            matchContext = (VTMatchOneToManyContext)context;
            selectedMatches = matchContext.getSelectedMatches();
        } else {
            return;
        }
        AcceptMatchTask task = new AcceptMatchTask(this.controller, selectedMatches);
        this.controller.runVTTask(task);
    }

    public boolean isEnabledForContext(ActionContext context) {
        List<VTMatch> selectedMatches;
        if (context instanceof VTMatchContext) {
            VTMatchContext matchContext = (VTMatchContext)context;
            selectedMatches = matchContext.getSelectedMatches();
        } else if (context instanceof VTMatchOneToManyContext) {
            VTMatchOneToManyContext matchContext = (VTMatchOneToManyContext)context;
            selectedMatches = matchContext.getSelectedMatches();
        } else {
            selectedMatches = new ArrayList<VTMatch>();
        }
        return selectedMatches.size() > 0;
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }
}

