/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.pty.local;

import agent.gdb.pty.PtySession;
import agent.gdb.pty.windows.Handle;
import com.sun.jna.LastErrorException;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.ptr.IntByReference;
import ghidra.util.Msg;

public class LocalWindowsNativeProcessPtySession
implements PtySession {
    private final Handle processHandle;

    public LocalWindowsNativeProcessPtySession(int pid, int tid, Handle processHandle, Handle threadHandle) {
        this.processHandle = processHandle;
        Msg.info((Object)this, (Object)("local Windows Pty session. PID = " + pid));
    }

    @Override
    public int waitExited() throws InterruptedException {
        while (true) {
            switch (Kernel32.INSTANCE.WaitForSingleObject(this.processHandle.getNative(), -1)) {
                case 0: 
                case 128: {
                    IntByReference lpExitCode = new IntByReference();
                    Kernel32.INSTANCE.GetExitCodeProcess(this.processHandle.getNative(), lpExitCode);
                    if (lpExitCode.getValue() != 259) {
                        return lpExitCode.getValue();
                    }
                }
                case 258: {
                    throw new AssertionError();
                }
                case -1: {
                    throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
                }
            }
        }
    }

    @Override
    public void destroyForcibly() {
        if (!Kernel32.INSTANCE.TerminateProcess(this.processHandle.getNative(), 1)) {
            int error = Kernel32.INSTANCE.GetLastError();
            switch (error) {
                case 5: {
                    return;
                }
            }
            throw new LastErrorException(error);
        }
    }
}

