/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbRegister;
import agent.gdb.manager.impl.cmd.GdbStateChangeRecord;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetStack;
import agent.gdb.model.impl.GdbModelTargetStackFrame;
import agent.gdb.model.impl.GdbModelTargetStackFrameRegister;
import agent.gdb.model.impl.GdbModelTargetThread;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.error.DebuggerRegisterAccessException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.ConversionUtils;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakValueHashMap;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="RegisterValueContainer", elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class GdbModelTargetStackFrameRegisterContainer
extends DefaultTargetObject<GdbModelTargetStackFrameRegister, GdbModelTargetStackFrame>
implements TargetRegisterContainer,
TargetRegisterBank {
    public static final String NAME = "Registers";
    protected final GdbModelImpl impl;
    protected final GdbModelTargetStackFrame frame;
    protected final GdbModelTargetThread thread;
    private Map<String, byte[]> regValues = new HashMap<String, byte[]>();
    protected final Map<Integer, GdbModelTargetStackFrameRegister> registersByNumber = new WeakValueHashMap();
    protected final Set<GdbRegister> allRegisters = new LinkedHashSet<GdbRegister>();

    public GdbModelTargetStackFrameRegisterContainer(GdbModelTargetStackFrame frame) {
        super((AbstractDebuggerObjectModel)frame.impl, (TargetObject)frame, NAME, "StackFrameRegisterContainer");
        this.impl = frame.impl;
        this.frame = frame;
        this.thread = frame.thread;
        this.changeAttributes(List.of(), List.of(), Map.of("_descriptions", this), "Initialized");
    }

    public GdbModelTargetStackFrameRegisterContainer getDescriptions() {
        return this;
    }

    protected CompletableFuture<Map<String, GdbModelTargetStackFrameRegister>> ensureRegisterDescriptions() {
        if (this.elements.isEmpty()) {
            return this.populateRegisterDescriptions().thenApply(__ -> this.elements);
        }
        return CompletableFuture.completedFuture(this.elements);
    }

    protected CompletableFuture<Void> populateRegisterDescriptions() {
        return this.thread.thread.listRegisters().thenAccept(regs -> {
            List registers;
            if (!this.valid) {
                return;
            }
            GdbModelTargetStackFrameRegisterContainer gdbModelTargetStackFrameRegisterContainer = this;
            synchronized (gdbModelTargetStackFrameRegisterContainer) {
                if (regs.size() != this.registersByNumber.size()) {
                    this.allRegisters.clear();
                    this.registersByNumber.clear();
                }
                this.allRegisters.addAll((Collection<GdbRegister>)regs);
                registers = regs.stream().map(this::getTargetRegister).collect(Collectors.toList());
            }
            this.setElements(registers, Map.of(), "Refreshed");
        });
    }

    protected CompletableFuture<Map<String, byte[]>> updateRegisterValues(Set<GdbRegister> toRead) {
        return this.frame.frame.readRegisters(toRead).thenApply(vals -> {
            LinkedHashMap<String, byte[]> result = new LinkedHashMap<String, byte[]>();
            for (Map.Entry ent : vals.entrySet()) {
                GdbRegister reg = (GdbRegister)ent.getKey();
                String regName = reg.getName();
                BigInteger val = (BigInteger)ent.getValue();
                if (val == null) {
                    Msg.warn((Object)((Object)this), (Object)("Register " + regName + " value came back null."));
                    continue;
                }
                byte[] bytes = ConversionUtils.bigIntegerToBytes((int)reg.getSize(), (BigInteger)val);
                result.put(regName, bytes);
                ((GdbModelTargetStackFrameRegister)((Object)((Object)this.elements.get(regName)))).stateChanged(bytes);
            }
            this.regValues = result;
            ((DebuggerModelListener)this.listeners.fire).registersUpdated((TargetObject)this, result);
            return result;
        });
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return ((CompletableFuture)this.ensureRegisterDescriptions().thenCompose(regs -> {
            if (!regs.isEmpty()) {
                return this.updateRegisterValues(this.allRegisters);
            }
            return AsyncUtils.nil();
        })).thenApply(__ -> null);
    }

    protected synchronized GdbModelTargetStackFrameRegister getTargetRegister(GdbRegister register) {
        return this.registersByNumber.computeIfAbsent(register.getNumber(), n -> new GdbModelTargetStackFrameRegister(this, register));
    }

    public CompletableFuture<? extends Map<String, byte[]>> readRegistersNamed(Collection<String> names) {
        return this.model.gateFuture((CompletableFuture)this.ensureRegisterDescriptions().thenCompose(regs -> {
            LinkedHashSet<GdbRegister> toRead = new LinkedHashSet<GdbRegister>();
            for (String regname : names) {
                GdbModelTargetStackFrameRegister reg = (GdbModelTargetStackFrameRegister)((Object)((Object)regs.get(regname)));
                if (reg == null) {
                    throw new DebuggerRegisterAccessException("No such register: " + regname);
                }
                toRead.add(reg.register);
            }
            return this.updateRegisterValues(toRead);
        }));
    }

    public Map<String, byte[]> getCachedRegisters() {
        return this.regValues;
    }

    public CompletableFuture<Void> writeRegistersNamed(Map<String, byte[]> values) {
        LinkedHashMap toWrite = new LinkedHashMap();
        return this.model.gateFuture((CompletableFuture)((CompletableFuture)((CompletableFuture)this.ensureRegisterDescriptions().thenCompose(regs -> {
            for (Map.Entry ent : values.entrySet()) {
                String regname = (String)ent.getKey();
                GdbModelTargetStackFrameRegister reg = (GdbModelTargetStackFrameRegister)((Object)((Object)regs.get(regname)));
                if (reg == null) {
                    throw new DebuggerRegisterAccessException("No such register: " + regname);
                }
                BigInteger val = new BigInteger(1, (byte[])ent.getValue());
                toWrite.put(reg.register, val);
            }
            return this.frame.frame.writeRegisters(toWrite);
        })).thenCompose(__ -> this.updateRegisterValues(toWrite.keySet()))).thenCompose(__ -> ((GdbModelTargetStack)this.frame.getParent()).fetchElements(true))).thenApply(__ -> null);
    }

    public CompletableFuture<Void> stateChanged(GdbStateChangeRecord sco) {
        return this.requestElements(false).exceptionally(ex -> {
            if (!this.valid) {
                Msg.info((Object)((Object)this), (Object)("Ignoring error when refreshing now-invalid thread registers: " + ex));
            } else {
                this.impl.reportError((Object)this, "Trouble updating registers on state change", (Throwable)ex);
            }
            return null;
        });
    }
}

