/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.gadp.impl;

import agent.gdb.gadp.GdbGadpServer;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.pty.PtyFactory;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.gadp.server.AbstractGadpServer;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;

public class GdbGadpServerImpl
implements GdbGadpServer {
    protected final GdbModelImpl model = new GdbModelImpl(PtyFactory.local());
    protected final GadpSide server;

    public GdbGadpServerImpl(SocketAddress addr) throws IOException {
        this.server = new GadpSide(this.model, addr);
    }

    @Override
    public CompletableFuture<Void> startGDB(String gdbCmd, String[] args) {
        return this.model.startGDB(gdbCmd, args).thenCompose(__ -> this.server.launchAsyncService());
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.server.getLocalAddress();
    }

    @Override
    public void consoleLoop() throws IOException {
        this.model.consoleLoop();
    }

    @Override
    public void terminate() throws IOException {
        this.model.terminate();
        this.server.terminate();
    }

    @Override
    public void setExitOnClosed(boolean exitOnClosed) {
        this.server.setExitOnClosed(exitOnClosed);
    }

    public class GadpSide
    extends AbstractGadpServer {
        public GadpSide(GdbModelImpl model, SocketAddress addr) throws IOException {
            super((DebuggerObjectModel)model, addr);
        }
    }
}

