/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.info;

import ghidra.bitpatterns.info.ContextRegisterFilter;
import ghidra.bitpatterns.info.FileBitPatternInfoReader;
import ghidra.bitpatterns.info.FunctionBitPatternInfo;
import ghidra.bitpatterns.info.PatternType;
import ghidra.util.xml.XmlUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class InstructionSequence {
    static final String XML_ELEMENT_NAME = "InstructionSequence";
    private String[] instructions;
    private Integer[] sizes;
    private String[] commaSeparatedOperands;

    public InstructionSequence() {
    }

    public InstructionSequence(int length) {
        this.instructions = new String[length];
        this.sizes = new Integer[length];
        this.commaSeparatedOperands = new String[length];
    }

    public String getCompleteDisassembly(boolean inOrder) {
        return this.getDisassembly(this.instructions.length, inOrder);
    }

    public String getDisassembly(int numInstructions, boolean inOrder) {
        StringBuilder sb = new StringBuilder();
        if (this.instructions == null || numInstructions <= 0) {
            return null;
        }
        if (numInstructions > this.instructions.length) {
            throw new IllegalArgumentException("Too many instructions requested!");
        }
        for (int currentInst = 0; currentInst < numInstructions; ++currentInst) {
            StringBuilder current = new StringBuilder();
            current.append(" ");
            current.append(this.instructions[currentInst]);
            current.append(":");
            current.append(this.sizes[currentInst]);
            current.append("(");
            if (this.commaSeparatedOperands[currentInst] != null) {
                current.append(this.commaSeparatedOperands[currentInst]);
            }
            current.append(")");
            current.append(" ");
            if (inOrder) {
                sb.append((CharSequence)current);
                continue;
            }
            sb.insert(0, current);
        }
        return sb.toString();
    }

    public String[] getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String[] instructions) {
        this.instructions = instructions;
    }

    public Integer[] getSizes() {
        return this.sizes;
    }

    public void setSizes(Integer[] sizes) {
        this.sizes = sizes;
    }

    public String[] getCommaSeparatedOperands() {
        return this.commaSeparatedOperands;
    }

    public void setCommaSeparatedOperands(String[] commaSeparatedOperands) {
        this.commaSeparatedOperands = commaSeparatedOperands;
    }

    public int hashCode() {
        int hashcode = 17;
        hashcode = 31 * hashcode + Arrays.hashCode(this.instructions);
        hashcode = 31 * hashcode + Arrays.hashCode((Object[])this.sizes);
        if (this.commaSeparatedOperands != null) {
            hashcode = 31 * hashcode + Arrays.hashCode(this.commaSeparatedOperands);
        }
        return hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstructionSequence other = (InstructionSequence)obj;
        if (!Arrays.equals(this.instructions, other.getInstructions())) {
            return false;
        }
        if (!Arrays.equals((Object[])this.sizes, (Object[])other.getSizes())) {
            return false;
        }
        if (this.commaSeparatedOperands == null) {
            if (other.getCommaSeparatedOperands() != null) {
                return false;
            }
            if (other.getCommaSeparatedOperands() == null) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.instructions == null) {
            sb.append("null instructions\n");
        } else {
            int size = this.instructions.length;
            for (int i = 0; i < size; ++i) {
                sb.append(this.instructions[i]);
                sb.append(":");
                sb.append(this.sizes[i]);
                sb.append(" (");
                sb.append(this.commaSeparatedOperands[i]);
                sb.append(")");
                if (i == size - 1) continue;
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public static List<InstructionSequence> getInstSeqs(FileBitPatternInfoReader fsReader, PatternType type, ContextRegisterFilter regFilter) {
        ArrayList<InstructionSequence> instSeqs = new ArrayList<InstructionSequence>();
        block5: for (FunctionBitPatternInfo fInfo : fsReader.getFInfoList()) {
            if (regFilter != null && !regFilter.allows(fInfo.getContextRegisters())) continue;
            switch (type) {
                case FIRST: {
                    InstructionSequence currentSeq = fInfo.getFirstInst();
                    if (currentSeq.getInstructions()[0] == null || fInfo.getFirstBytes() == null) continue block5;
                    instSeqs.add(currentSeq);
                    break;
                }
                case PRE: {
                    InstructionSequence currentSeq = fInfo.getPreInst();
                    if (currentSeq.getInstructions()[0] == null || fInfo.getPreBytes() == null) continue block5;
                    instSeqs.add(currentSeq);
                    break;
                }
                case RETURN: {
                    List<InstructionSequence> currentSeqs = fInfo.getReturnInst();
                    List<String> currentBytes = fInfo.getReturnBytes();
                    if (currentSeqs.size() != currentBytes.size()) continue block5;
                    int numSeqs = currentSeqs.size();
                    for (int i = 0; i < numSeqs; ++i) {
                        if (currentSeqs.get(i).getInstructions()[0] == null || currentBytes.get(i).getBytes() == null) continue;
                        instSeqs.add(currentSeqs.get(i));
                    }
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("unsupported instruction type: " + type.name());
                }
            }
        }
        return instSeqs;
    }

    public Element toXml() {
        return this.toXml(XML_ELEMENT_NAME);
    }

    public Element toXml(String elementName) {
        Element result = new Element(elementName);
        Element instructionsListEle = new Element("instructions");
        result.addContent((Content)instructionsListEle);
        if (this.instructions != null) {
            for (String s : this.instructions) {
                Element x = new Element("instruction");
                instructionsListEle.addContent((Content)x);
                if (s == null) continue;
                x.setAttribute("value", s);
            }
        }
        Element sizesListEle = new Element("sizes");
        result.addContent((Content)sizesListEle);
        if (this.sizes != null) {
            for (Integer s : this.sizes) {
                Element x = new Element("size");
                sizesListEle.addContent((Content)x);
                if (s == null) continue;
                XmlUtilities.setIntAttr((Element)x, (String)"value", (int)s);
            }
        }
        Element csoListEle = new Element("commaSeparatedOperands");
        result.addContent((Content)csoListEle);
        if (this.commaSeparatedOperands != null) {
            for (String s : this.commaSeparatedOperands) {
                Element x = new Element("operands");
                csoListEle.addContent((Content)x);
                if (s == null) continue;
                x.setAttribute("value", s);
            }
        }
        return result;
    }

    public static InstructionSequence fromXml(Element element) {
        if (element == null) {
            return null;
        }
        ArrayList<Object> instructionsList = new ArrayList<Object>();
        Element instructionsListEle = element.getChild("instructions");
        if (instructionsListEle != null) {
            for (Element instEle : XmlUtilities.getChildren((Element)instructionsListEle, (String)"instruction")) {
                String val = instEle.getAttributeValue("value");
                instructionsList.add(val);
            }
        }
        ArrayList<Integer> sizesList = new ArrayList<Integer>();
        Element sizesListEle = element.getChild("sizes");
        if (sizesListEle != null) {
            for (Element sizeEle : XmlUtilities.getChildren((Element)sizesListEle, (String)"size")) {
                String val = sizeEle.getAttributeValue("value");
                sizesList.add(val != null ? Integer.valueOf(XmlUtilities.parseInt((String)val)) : null);
            }
        }
        ArrayList<String> csoList = new ArrayList<String>();
        Element csoListEle = element.getChild("commaSeparatedOperands");
        if (csoListEle != null) {
            for (Element csoEle : XmlUtilities.getChildren((Element)csoListEle, (String)"operands")) {
                String val = csoEle.getAttributeValue("value");
                csoList.add(val);
            }
        }
        InstructionSequence result = new InstructionSequence();
        result.setInstructions(instructionsList.toArray(new String[instructionsList.size()]));
        result.setCommaSeparatedOperands(csoList.toArray(new String[csoList.size()]));
        result.setSizes(sizesList.toArray(new Integer[sizesList.size()]));
        return result;
    }
}

