/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.DBRecord;
import db.Field;
import db.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class SparseRecord
extends DBRecord {
    SparseRecord(Schema schema, Field key) {
        super(schema, key);
    }

    @Override
    int computeLength() {
        int len = 1;
        Field[] fields = this.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (this.schema.isSparseColumn(i)) {
                if (f.isNull()) continue;
                len += f.length() + 1;
                continue;
            }
            len += f.length();
        }
        return len;
    }

    @Override
    public void write(Buffer buf, int offset) throws IOException {
        ArrayList<Integer> sparseFieldIndexes = new ArrayList<Integer>();
        Field[] fields = this.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (this.schema.isSparseColumn(i)) {
                if (fields[i].isNull()) continue;
                sparseFieldIndexes.add(i);
                continue;
            }
            offset = fields[i].write(buf, offset);
        }
        buf.putByte(offset++, (byte)sparseFieldIndexes.size());
        Iterator iterator = sparseFieldIndexes.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Field f = fields[i];
            if (f.isNull()) continue;
            buf.putByte(offset++, (byte)i);
            offset = f.write(buf, offset);
        }
        this.dirty = false;
    }

    @Override
    public void read(Buffer buf, int offset) throws IOException {
        Field[] fields = this.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (this.schema.isSparseColumn(i)) {
                f.setNull();
                continue;
            }
            offset = f.read(buf, offset);
        }
        int sparseFieldCount = buf.getByte(offset++);
        for (int i = 0; i < sparseFieldCount; ++i) {
            byte index = buf.getByte(offset++);
            offset = fields[index].read(buf, offset);
        }
        this.dirty = false;
    }

    private boolean changeInSparsePrimitiveStorage(int colIndex) {
        if (!this.schema.isSparseColumn(colIndex)) {
            return false;
        }
        return this.getField(colIndex).isNull();
    }

    private boolean changeInSparseStorage(int colIndex, byte[] newValue) {
        if (!this.schema.isSparseColumn(colIndex)) {
            return false;
        }
        boolean oldIsNull = this.getField(colIndex).isNull();
        boolean newIsNull = newValue == null;
        return oldIsNull != newIsNull;
    }

    private boolean changeInSparseNullStorage(int colIndex) {
        if (!this.schema.isSparseColumn(colIndex)) {
            return false;
        }
        return !this.getField(colIndex).isNull();
    }

    @Override
    public void setField(int colIndex, Field value) {
        if (value == null) {
            if (!this.schema.isSparseColumn(colIndex)) {
                throw new IllegalArgumentException("null value supported for sparse column only");
            }
            value = this.getField(colIndex).newField();
            value.setNull();
        }
        super.setField(colIndex, value);
    }

    @Override
    public void setLongValue(int colIndex, long value) {
        if (this.changeInSparsePrimitiveStorage(colIndex)) {
            this.invalidateLength();
        }
        super.setLongValue(colIndex, value);
    }

    @Override
    public void setIntValue(int colIndex, int value) {
        if (this.changeInSparsePrimitiveStorage(colIndex)) {
            this.invalidateLength();
        }
        super.setIntValue(colIndex, value);
    }

    @Override
    public void setShortValue(int colIndex, short value) {
        if (this.changeInSparsePrimitiveStorage(colIndex)) {
            this.invalidateLength();
        }
        super.setShortValue(colIndex, value);
    }

    @Override
    public void setByteValue(int colIndex, byte value) {
        if (this.changeInSparsePrimitiveStorage(colIndex)) {
            this.invalidateLength();
        }
        super.setByteValue(colIndex, value);
    }

    @Override
    public void setBooleanValue(int colIndex, boolean value) {
        if (this.changeInSparsePrimitiveStorage(colIndex)) {
            this.invalidateLength();
        }
        super.setBooleanValue(colIndex, value);
    }

    @Override
    public void setBinaryData(int colIndex, byte[] bytes) {
        if (this.changeInSparseStorage(colIndex, bytes)) {
            this.invalidateLength();
        }
        super.setBinaryData(colIndex, bytes);
    }

    @Override
    public void setNull(int colIndex) {
        if (this.changeInSparseNullStorage(colIndex)) {
            this.invalidateLength();
        }
        super.setNull(colIndex);
    }
}

