/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BinaryField;
import db.Buffer;
import db.Field;
import db.FixedField;
import db.buffers.DataBuffer;
import generic.util.UnsignedDataUtils;
import ghidra.util.BigEndianDataConverter;
import java.io.IOException;

public class FixedField10
extends FixedField {
    public static final FixedField10 ZERO_VALUE;
    public static FixedField10 MIN_VALUE;
    public static FixedField10 MAX_VALUE;
    public static final FixedField10 INSTANCE;
    private short lo2;
    private long hi8;

    public FixedField10() {
        super(null, false);
    }

    public FixedField10(byte[] data) {
        this(data, false);
    }

    public FixedField10(byte[] data, boolean immutable) {
        super(data, immutable);
        if (data != null) {
            if (data.length != 10) {
                throw new IllegalArgumentException("Invalid FixedField10 data length");
            }
            this.updatePrimitiveValue(data);
        }
    }

    FixedField10(long hi8, short lo2, boolean immutable) {
        super(null, immutable);
        this.hi8 = hi8;
        this.lo2 = lo2;
    }

    @Override
    public int compareTo(Field o) {
        if (!(o instanceof FixedField10)) {
            throw new UnsupportedOperationException("may only compare similar Field types");
        }
        FixedField10 f = (FixedField10)o;
        if (this.hi8 != f.hi8) {
            return UnsignedDataUtils.unsignedLessThan((long)this.hi8, (long)f.hi8) ? -1 : 1;
        }
        if (this.lo2 != f.lo2) {
            return UnsignedDataUtils.unsignedLessThan((short)this.lo2, (short)f.lo2) ? -1 : 1;
        }
        return 0;
    }

    @Override
    int compareTo(DataBuffer buffer, int offset) {
        long otherHi8 = buffer.getLong(offset);
        if (this.hi8 != otherHi8) {
            return UnsignedDataUtils.unsignedLessThan((long)this.hi8, (long)otherHi8) ? -1 : 1;
        }
        short otherLo2 = buffer.getShort(offset + 8);
        if (this.lo2 != otherLo2) {
            return UnsignedDataUtils.unsignedLessThan((short)this.lo2, (short)otherLo2) ? -1 : 1;
        }
        return 0;
    }

    @Override
    public FixedField copyField() {
        if (this.isNull()) {
            FixedField10 copy = new FixedField10();
            copy.setNull();
            return copy;
        }
        return new FixedField10(this.hi8, this.lo2, false);
    }

    @Override
    public FixedField newField() {
        return new FixedField10();
    }

    @Override
    FixedField getMinValue() {
        return MIN_VALUE;
    }

    @Override
    FixedField getMaxValue() {
        return MAX_VALUE;
    }

    @Override
    public byte[] getBinaryData() {
        if (this.data != null) {
            return this.data;
        }
        this.data = new byte[10];
        BigEndianDataConverter.INSTANCE.putLong(this.data, 0, this.hi8);
        BigEndianDataConverter.INSTANCE.putShort(this.data, 8, this.lo2);
        return this.data;
    }

    @Override
    public void setBinaryData(byte[] d) {
        if (d == null) {
            this.setNull();
            return;
        }
        if (d.length != 10) {
            throw new IllegalArgumentException("Invalid FixedField10 data length");
        }
        this.updatingValue();
        this.data = d;
        this.updatePrimitiveValue(d);
    }

    void updatePrimitiveValue(byte[] d) {
        this.hi8 = BigEndianDataConverter.INSTANCE.getLong(d, 0);
        this.lo2 = BigEndianDataConverter.INSTANCE.getShort(d, 8);
    }

    @Override
    void setNull() {
        super.setNull();
        this.data = null;
        this.hi8 = 0L;
        this.lo2 = 0;
    }

    @Override
    byte getFieldType() {
        return 7;
    }

    @Override
    int write(Buffer buf, int offset) throws IOException {
        if (this.data != null) {
            return buf.put(offset, this.data);
        }
        offset = buf.putLong(offset, this.hi8);
        return buf.putShort(offset, this.lo2);
    }

    @Override
    int read(Buffer buf, int offset) throws IOException {
        this.updatingValue();
        this.data = null;
        this.hi8 = buf.getLong(offset);
        this.lo2 = buf.getShort(offset + 8);
        return offset + 10;
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        return 10;
    }

    @Override
    int length() {
        return 10;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = (int)(this.hi8 ^ this.hi8 >>> 32);
        result = 31 * result + this.lo2;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FixedField10)) {
            return false;
        }
        FixedField10 other = (FixedField10)obj;
        if (this.hi8 != other.hi8) {
            return false;
        }
        return this.lo2 == other.lo2;
    }

    @Override
    public String getValueAsString() {
        return "{" + BinaryField.getValueAsString(this.getBinaryData()) + "}";
    }

    static {
        MIN_VALUE = ZERO_VALUE = new FixedField10(0L, 0, true);
        MAX_VALUE = new FixedField10(-1L, -1, true);
        INSTANCE = ZERO_VALUE;
    }
}

