/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.NotFoundException;

public class SPARC_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 2 || elf.e_machine() == 18 || elf.e_machine() == 43;
    }

    public void relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (elf.e_machine() != 2 && elf.e_machine() != 18) {
            return;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int type = relocation.getType();
        if (type == 0) {
            return;
        }
        int symbolIndex = relocation.getSymbolIndex();
        long addend = relocation.getAddend();
        long offset = (int)relocationAddress.getOffset();
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        String symbolName = elfRelocationContext.getSymbolName(symbolIndex);
        long symbolValue = elfRelocationContext.getSymbolValue(sym);
        int oldValue = memory.getInt(relocationAddress);
        int newValue = 0;
        switch (type) {
            case 6: {
                newValue = (int)(symbolValue + addend - offset);
                memory.setInt(relocationAddress, oldValue | newValue);
                break;
            }
            case 7: {
                newValue = (int)(symbolValue + addend - offset) >>> 2;
                memory.setInt(relocationAddress, oldValue | newValue);
                break;
            }
            case 9: {
                newValue = (int)symbolValue + (int)addend >>> 10;
                memory.setInt(relocationAddress, oldValue | newValue);
                break;
            }
            case 12: {
                newValue = (int)symbolValue + (int)addend & 0x3FF;
                memory.setInt(relocationAddress, oldValue | newValue);
                break;
            }
            case 3: 
            case 21: {
                newValue = (int)symbolValue + (int)addend;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 20: {
                newValue = (int)symbolValue;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 22: {
                newValue = (int)elf.getImageBase() + (int)addend;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 23: {
                newValue = (int)symbolValue + (int)addend;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 19: {
                SPARC_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_SPARC_COPY", (String)symbolName, (long)symbolIndex, (String)"Runtime copy not supported", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            default: {
                SPARC_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
            }
        }
    }
}

