/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel;

import agent.dbgmodel.dbgmodel.err.DbgModelRuntimeException;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import ghidra.util.Msg;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;

public abstract class DbgModelUtil {
    public static final WinDef.ULONG DEBUG_ANY_ID = new WinDef.ULONG(-1L);

    private DbgModelUtil() {
    }

    public static <I> I tryPreferredInterfaces(Class<I> cls, Map<Guid.REFIID, ? extends Class<?>> preferred, InterfaceSupplier supplier) {
        PointerByReference ppClient = new PointerByReference();
        for (Map.Entry<Guid.REFIID, Class<?>> ent : preferred.entrySet()) {
            try {
                COMUtils.checkRC((WinNT.HRESULT)supplier.get(ent.getKey(), ppClient));
                if (ppClient.getValue() == null) continue;
                Object impl = ent.getValue().getConstructor(Pointer.class).newInstance(ppClient.getValue());
                Method instanceFor = cls.getMethod("instanceFor", ent.getValue());
                Object instance = instanceFor.invoke(null, impl);
                return (I)instance;
            }
            catch (COMException e) {
                Msg.debug(DbgModelUtil.class, (Object)(e + " (" + ent.getValue() + ")"));
            }
            catch (Exception e) {
                throw new AssertionError("INTERNAL: Unexpected exception", e);
            }
        }
        throw new DbgModelRuntimeException("None of the preferred interfaces are supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Unknown, U> U lazyWeakCache(Map<Pointer, U> cache, T unk, Function<T, U> forNew) {
        Map<Pointer, U> map = cache;
        synchronized (map) {
            U present = cache.get(unk.getPointer());
            if (present != null) {
                unk.Release();
                return present;
            }
            U absent = forNew.apply(unk);
            cache.put(unk.getPointer(), absent);
            return absent;
        }
    }

    public static void dbgline() {
        System.out.println(new Exception().getStackTrace()[1]);
        System.out.flush();
    }

    public static interface InterfaceSupplier {
        public WinNT.HRESULT get(Guid.REFIID var1, PointerByReference var2);
    }
}

