/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target;

import ghidra.dbg.DebuggerTargetObjectIface;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;

@DebuggerTargetObjectIface(value="BreakpointLocation")
public interface TargetBreakpointLocation
extends TargetObject {
    public static final String RANGE_ATTRIBUTE_NAME = "_range";
    public static final String SPEC_ATTRIBUTE_NAME = "_spec";

    @TargetAttributeType(name="_range", hidden=true)
    default public AddressRange getRange() {
        return this.getTypedAttributeNowByName(RANGE_ATTRIBUTE_NAME, AddressRange.class, null);
    }

    @Deprecated(forRemoval=true, since="10.2")
    default public Address getAddress() {
        return this.getRange().getMinAddress();
    }

    @Deprecated(forRemoval=true, since="10.2")
    default public Integer getLength() {
        AddressRange range = this.getRange();
        return range == null ? null : Integer.valueOf((int)range.getLength());
    }

    @Deprecated(forRemoval=true, since="10.2")
    default public int getLengthOrDefault(int fallback) {
        Integer length = this.getLength();
        return length == null ? 1 : length;
    }

    @TargetAttributeType(name="_spec", required=true, hidden=true)
    default public TargetBreakpointSpec getSpecification() {
        return this.getTypedAttributeNowByName(SPEC_ATTRIBUTE_NAME, TargetBreakpointSpec.class, null);
    }
}

