/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg;

import ghidra.async.AsyncFence;
import ghidra.async.AsyncReference;
import ghidra.async.AsyncUtils;
import ghidra.dbg.AnnotatedDebuggerAttributeListener;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetAccessConditioned;
import ghidra.dbg.target.TargetActiveScope;
import ghidra.dbg.target.TargetAggregate;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.PathUtils;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public final class DebugModelConventions
extends Enum<DebugModelConventions> {
    private static final /* synthetic */ DebugModelConventions[] $VALUES;

    public static DebugModelConventions[] values() {
        return (DebugModelConventions[])$VALUES.clone();
    }

    public static DebugModelConventions valueOf(String name) {
        return Enum.valueOf(DebugModelConventions.class, name);
    }

    protected static CompletableFuture<Void> runNotInSwing(Object originator, Runnable runnable, String cbName) {
        if (Swing.isSwingThread()) {
            return CompletableFuture.runAsync(runnable).exceptionally(e -> {
                Msg.error((Object)originator, (Object)("Error in " + cbName), (Throwable)e);
                return null;
            });
        }
        try {
            runnable.run();
        }
        catch (Throwable e2) {
            Msg.error((Object)originator, (Object)("Error in " + cbName), (Throwable)e2);
        }
        return AsyncUtils.NIL;
    }

    @Deprecated(forRemoval=true)
    public static <T extends TargetObject> CompletableFuture<T> findSuitable(Class<T> iface, TargetObject seed) {
        if (iface.isAssignableFrom(seed.getClass())) {
            return CompletableFuture.completedFuture((TargetObject)iface.cast(seed));
        }
        if (seed instanceof TargetAggregate) {
            return DebugModelConventions.findInAggregate(iface, seed).thenCompose(agg -> {
                if (agg.size() == 1) {
                    return CompletableFuture.completedFuture((TargetObject)agg.iterator().next());
                }
                return DebugModelConventions.findParentSuitable(iface, seed);
            });
        }
        return DebugModelConventions.findParentSuitable(iface, seed);
    }

    public static <T extends TargetObject> CompletableFuture<T> suitable(Class<T> iface, TargetObject seed) {
        List<String> path = seed.getModel().getRootSchema().searchForSuitable(iface, seed.getPath());
        if (path == null) {
            return null;
        }
        return seed.getModel().fetchModelObject(path).thenApply(obj -> (TargetObject)iface.cast(obj));
    }

    public static <T extends TargetObject> T ancestor(Class<T> iface, TargetObject seed) {
        List<String> path = seed.getModel().getRootSchema().searchForAncestor(iface, seed.getPath());
        if (path == null) {
            return null;
        }
        return (T)((TargetObject)iface.cast(seed.getModel().getModelObject(path)));
    }

    private static <T extends TargetObject> CompletableFuture<T> findParentSuitable(Class<T> iface, TargetObject obj) {
        TargetObject parent = obj.getParent();
        if (parent == null) {
            return AsyncUtils.nil();
        }
        return DebugModelConventions.findSuitable(iface, parent);
    }

    public static <T extends TargetObject> CompletableFuture<Collection<T>> findInAggregate(Class<T> iface, TargetObject seed) {
        return DebugModelConventions.findInAggregate(iface, Set.of(seed));
    }

    public static <T extends TargetObject> CompletableFuture<Collection<T>> findInAggregate(Class<T> iface, Collection<? extends TargetObject> seeds) {
        if (seeds.isEmpty()) {
            return CompletableFuture.completedFuture(Set.of());
        }
        Set result = seeds.stream().filter(obj -> iface.isAssignableFrom(obj.getClass())).map(obj -> (TargetObject)iface.cast(obj)).collect(Collectors.toSet());
        if (!result.isEmpty()) {
            return CompletableFuture.completedFuture(result);
        }
        AsyncFence fence = new AsyncFence();
        HashSet nextLevel = new HashSet();
        for (TargetObject targetObject : seeds) {
            if (!(targetObject instanceof TargetAggregate)) continue;
            fence.include((CompletableFuture)targetObject.fetchAttributes().thenAccept(attributes -> {
                Set set = nextLevel;
                synchronized (set) {
                    for (Map.Entry ent : attributes.entrySet()) {
                        Object val = ent.getValue();
                        if (!(val instanceof TargetObject)) continue;
                        TargetObject obj = (TargetObject)val;
                        if (PathUtils.isLink(seed.getPath(), (String)ent.getKey(), obj.getPath())) continue;
                        nextLevel.add(obj);
                    }
                }
            }));
        }
        return fence.ready().thenCompose(__ -> DebugModelConventions.findInAggregate(iface, nextLevel));
    }

    public static <T extends TargetObject> CompletableFuture<T> nearestAncestor(final Class<T> iface, TargetObject successor) {
        return new AncestorTraversal<T>(successor){

            @Override
            protected AncestorTraversal.Result check(TargetObject obj) {
                if (iface.isAssignableFrom(obj.getClass())) {
                    return AncestorTraversal.Result.FOUND;
                }
                return AncestorTraversal.Result.CONTINUE;
            }

            @Override
            protected T finish(TargetObject obj) {
                return (TargetObject)iface.cast(obj);
            }
        }.start();
    }

    public static <T extends TargetObject> CompletableFuture<Collection<T>> collectAncestors(TargetObject seed, Class<T> iface) {
        DebuggerObjectModel model = seed.getModel();
        ArrayList result = new ArrayList(seed.getPath().size() + 1);
        AsyncFence fence = new AsyncFence();
        List<String> path = seed.getPath();
        while (path != null) {
            fence.include((CompletableFuture)model.fetchModelObject(path).thenAccept(obj -> {
                if (iface.isAssignableFrom(obj.getClass())) {
                    result.add((TargetObject)iface.cast(obj));
                }
            }));
            path = PathUtils.parent(path);
        }
        return fence.ready().thenApply(__ -> {
            result.sort(Comparator.comparing(o -> o.getPath().size()));
            return result;
        });
    }

    @Deprecated(forRemoval=true)
    public static <T extends TargetObject> CompletableFuture<Collection<T>> collectSuccessors(TargetObject seed, Class<T> iface) {
        TreeSet<TargetObject> result = new TreeSet<TargetObject>(Comparator.comparing(TargetObject::getPath, PathUtils.PathComparator.KEYED));
        AsyncFence fence = new AsyncFence();
        fence.include((CompletableFuture)seed.fetchElements().thenCompose(elements -> {
            AsyncFence elemFence = new AsyncFence();
            Collection collection = result;
            synchronized (collection) {
                for (TargetObject e : elements.values()) {
                    if (iface.isInstance(e)) {
                        result.add((TargetObject)iface.cast(e));
                        continue;
                    }
                    elemFence.include((CompletableFuture)DebugModelConventions.collectSuccessors(e, iface).thenAccept(sub -> {
                        Collection collection = result;
                        synchronized (collection) {
                            result.addAll((Collection<TargetObject>)sub);
                        }
                    }));
                }
            }
            return elemFence.ready();
        }));
        fence.include((CompletableFuture)seed.fetchAttributes().thenCompose(attributes -> {
            AsyncFence attrFence = new AsyncFence();
            Collection collection = result;
            synchronized (collection) {
                for (Map.Entry ent : attributes.entrySet()) {
                    Object val = ent.getValue();
                    if (!(val instanceof TargetObject)) continue;
                    TargetObject a = (TargetObject)val;
                    if (PathUtils.isLink(seed.getPath(), (String)ent.getKey(), a.getPath())) continue;
                    if (iface.isInstance(a)) {
                        result.add((TargetObject)iface.cast(a));
                        continue;
                    }
                    attrFence.include((CompletableFuture)DebugModelConventions.collectSuccessors(a, iface).thenAccept(sub -> {
                        Collection collection = result;
                        synchronized (collection) {
                            result.addAll((Collection<TargetObject>)sub);
                        }
                    }));
                }
            }
            return attrFence.ready();
        }));
        return fence.ready().thenApply(__ -> result);
    }

    public static CompletableFuture<TargetThread> findThread(TargetObject successor) {
        return new AncestorTraversal<TargetThread>(successor){

            @Override
            protected AncestorTraversal.Result check(TargetObject obj) {
                if (obj.isRoot()) {
                    return AncestorTraversal.Result.TERMINATE;
                }
                if (obj instanceof TargetThread) {
                    return AncestorTraversal.Result.FOUND;
                }
                return AncestorTraversal.Result.CONTINUE;
            }

            @Override
            protected TargetThread finish(TargetObject obj) {
                return (TargetThread)obj;
            }
        }.start();
    }

    public static boolean isProcessAlive(TargetProcess process) {
        if (!process.isValid()) {
            return false;
        }
        if (!(process instanceof TargetExecutionStateful)) {
            return true;
        }
        TargetExecutionStateful exe = (TargetExecutionStateful)((Object)process);
        TargetExecutionStateful.TargetExecutionState state = exe.getExecutionState();
        if (state == null) {
            Msg.trace(null, (Object)("null state for " + exe));
            return false;
        }
        return state.isAlive();
    }

    public static TargetProcess liveProcessOrNull(TargetObject target) {
        if (!(target instanceof TargetProcess)) {
            return null;
        }
        TargetProcess process = (TargetProcess)target;
        return DebugModelConventions.isProcessAlive(process) ? process : null;
    }

    @Deprecated
    public static CompletableFuture<AllRequiredAccess> trackAccessibility(TargetObject obj) {
        CompletableFuture<Collection<TargetAccessConditioned>> collectAncestors = DebugModelConventions.collectAncestors(obj, TargetAccessConditioned.class);
        return collectAncestors.thenApply(AllRequiredAccess::new);
    }

    public static CompletableFuture<Void> requestActivation(TargetObject obj) {
        CompletableFuture<TargetActiveScope> futureActivator = DebugModelConventions.findSuitable(TargetActiveScope.class, obj);
        return futureActivator.thenCompose(activator -> {
            if (activator == null) {
                return AsyncUtils.NIL;
            }
            return activator.requestActivation(obj);
        });
    }

    public static CompletableFuture<Void> requestFocus(TargetObject obj) {
        CompletableFuture<TargetFocusScope> futureScope = DebugModelConventions.findSuitable(TargetFocusScope.class, obj);
        return futureScope.thenCompose(scope -> {
            if (scope == null) {
                return AsyncUtils.NIL;
            }
            return scope.requestFocus(obj);
        });
    }

    private static /* synthetic */ DebugModelConventions[] $values() {
        return new DebugModelConventions[0];
    }

    static {
        $VALUES = DebugModelConventions.$values();
    }

    public static abstract class AncestorTraversal<T>
    extends CompletableFuture<T> {
        protected TargetObject cur;

        public AncestorTraversal(TargetObject successor) {
            this.cur = successor;
        }

        protected abstract Result check(TargetObject var1);

        protected abstract T finish(TargetObject var1);

        public AncestorTraversal<T> start() {
            try {
                this.next(this.cur);
            }
            catch (Throwable ex) {
                this.completeExceptionally(ex);
            }
            return this;
        }

        protected void next(TargetObject ancestor) {
            this.cur = ancestor;
            if (this.cur == null) {
                this.complete(null);
                return;
            }
            switch (this.check(this.cur)) {
                case FOUND: {
                    this.complete(this.finish(this.cur));
                    return;
                }
                case CONTINUE: {
                    this.next(this.cur.getParent());
                    return;
                }
                case TERMINATE: {
                    this.complete(null);
                    return;
                }
            }
        }

        protected Void exc(Throwable ex) {
            this.completeExceptionally(ex);
            return null;
        }

        public static enum Result {
            FOUND,
            CONTINUE,
            TERMINATE;

        }
    }

    public static class AsyncAccess
    extends AsyncAttribute<Boolean> {
        public AsyncAccess(TargetAccessConditioned ac) {
            super(ac, "_accessible");
        }
    }

    public static class AsyncState
    extends AsyncAttribute<TargetExecutionStateful.TargetExecutionState> {
        public AsyncState(TargetExecutionStateful stateful) {
            super(stateful, "_state");
        }
    }

    public static class AsyncAttribute<T>
    extends AsyncReference<T, Void>
    implements DebuggerModelListener {
        private final TargetObject obj;
        private final String name;

        public AsyncAttribute(TargetObject obj, String name) {
            this.name = name;
            this.obj = obj;
            obj.addListener(this);
            this.set(obj.getCachedAttribute(name), null);
            obj.fetchAttribute(name).exceptionally(ex -> {
                Msg.error((Object)this, (Object)("Could not get initial value of " + name + " for " + obj), (Throwable)ex);
                return null;
            });
        }

        @Override
        public void attributesChanged(TargetObject parent, Collection<String> removed, Map<String, ?> added) {
            if (added.containsKey(this.name)) {
                this.set(added.get(this.name), null);
            } else if (removed.contains(this.name)) {
                this.set(null, null);
            }
        }

        public void dispose() {
            this.dispose((Throwable)((Object)new AssertionError((Object)"disposed")));
        }

        public void dispose(Throwable reason) {
            super.dispose(reason);
            this.obj.removeListener(this);
        }
    }

    @Deprecated(forRemoval=true)
    public static class AllRequiredAccess
    extends AsyncReference<Boolean, Void> {
        protected final List<ListenerForAccess> listeners;
        protected final AsyncFence initFence = new AsyncFence();

        public AllRequiredAccess(Collection<? extends TargetAccessConditioned> allReq) {
            Msg.debug((Object)((Object)this), (Object)("Listening for access on: " + allReq));
            this.listeners = allReq.stream().map(x$0 -> new ListenerForAccess((TargetAccessConditioned)x$0)).collect(Collectors.toList());
            this.set(this.getAllAccessibility(), null);
        }

        public boolean getAllAccessibility() {
            return this.listeners.stream().allMatch(l -> l.accessible);
        }

        protected class ListenerForAccess
        extends AnnotatedDebuggerAttributeListener {
            protected final TargetAccessConditioned access;
            private boolean accessible;

            public ListenerForAccess(TargetAccessConditioned access) {
                super(MethodHandles.lookup());
                this.access = access;
                this.access.addListener(this);
                this.accessible = access.isAccessible();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_accessible")
            public void accessibilityChanged(TargetObject object, boolean accessibility) {
                AllRequiredAccess allRequiredAccess = AllRequiredAccess.this;
                synchronized (allRequiredAccess) {
                    this.accessible = accessibility;
                    if (AllRequiredAccess.this.listeners != null) {
                        AllRequiredAccess.this.set(AllRequiredAccess.this.getAllAccessibility(), null);
                    }
                }
            }
        }
    }

    public static abstract class SubTreeListenerAdapter
    extends AnnotatedDebuggerAttributeListener {
        protected boolean disposed = false;
        protected final NavigableMap<List<String>, TargetObject> objects = new TreeMap<List<String>, TargetObject>(PathUtils.PathComparator.KEYED);

        public SubTreeListenerAdapter() {
            super(MethodHandles.lookup());
        }

        protected abstract void objectRemoved(TargetObject var1);

        protected abstract void objectAdded(TargetObject var1);

        protected abstract boolean checkDescend(TargetObject var1);

        @Override
        public void invalidated(TargetObject object, TargetObject branch, String reason) {
            DebugModelConventions.runNotInSwing(this, () -> this.doInvalidated(object, reason), "invalidated");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doInvalidated(TargetObject object, String reason) {
            ArrayList<TargetObject> removed = new ArrayList<TargetObject>();
            NavigableMap<List<String>, TargetObject> navigableMap = this.objects;
            synchronized (navigableMap) {
                Map.Entry<List<String>, TargetObject> ent;
                if (this.disposed) {
                    return;
                }
                List<String> path = object.getPath();
                while ((ent = this.objects.ceilingEntry(path)) != null && PathUtils.isAncestor(path, ent.getKey())) {
                    this.objects.remove(ent.getKey());
                    TargetObject succ = ent.getValue();
                    succ.removeListener(this);
                    removed.add(succ);
                }
            }
            for (TargetObject r : removed) {
                this.objectRemovedSafe(r);
            }
        }

        private void objectRemovedSafe(TargetObject removed) {
            try {
                this.objectRemoved(removed);
            }
            catch (Throwable t) {
                Msg.error((Object)this, (Object)"Error in callback", (Throwable)t);
            }
        }

        private void objectAddedSafe(TargetObject obj) {
            try {
                this.objectAdded(obj);
            }
            catch (Throwable t) {
                Msg.error((Object)this, (Object)"Error in callback", (Throwable)t);
            }
        }

        private void considerObj(TargetObject obj) {
            if (!this.checkDescend(obj)) {
                return;
            }
            CompletableFuture.runAsync(() -> this.addListenerAndConsiderSuccessors(obj)).exceptionally(ex -> {
                Msg.error((Object)this, (Object)("Could add to object: " + obj), (Throwable)ex);
                return null;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void considerElements(TargetObject parent, Map<String, ? extends TargetObject> elements) {
            NavigableMap<List<String>, TargetObject> navigableMap = this.objects;
            synchronized (navigableMap) {
                if (this.disposed) {
                    return;
                }
                if (!this.objects.containsKey(parent.getPath())) {
                    return;
                }
            }
            for (TargetObject targetObject : elements.values()) {
                this.considerObj(targetObject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void considerAttributes(TargetObject obj, Map<String, ?> attributes) {
            NavigableMap<List<String>, TargetObject> navigableMap = this.objects;
            synchronized (navigableMap) {
                if (this.disposed) {
                    return;
                }
                if (!this.objects.containsKey(obj.getPath())) {
                    return;
                }
            }
            for (Map.Entry entry : attributes.entrySet()) {
                String name = (String)entry.getKey();
                Object val = entry.getValue();
                if (!(val instanceof TargetObject)) continue;
                TargetObject a = (TargetObject)val;
                if (PathUtils.isLink(obj.getPath(), name, a.getPath())) continue;
                this.considerObj(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addListener(TargetObject obj) {
            if (obj == null) {
                return false;
            }
            obj.addListener(this);
            NavigableMap<List<String>, TargetObject> navigableMap = this.objects;
            synchronized (navigableMap) {
                if (this.objects.put(obj.getPath(), obj) == obj) {
                    return false;
                }
            }
            this.objectAddedSafe(obj);
            return true;
        }

        public boolean addListenerAndConsiderSuccessors(TargetObject obj) {
            boolean result = this.addListener(obj);
            if (result && this.checkDescend(obj)) {
                ((CompletableFuture)obj.fetchElements().thenAcceptAsync(elems -> this.considerElements(obj, (Map<String, ? extends TargetObject>)elems))).exceptionally(ex -> {
                    Msg.error((Object)this, (Object)("Could not fetch elements of obj: " + obj), (Throwable)ex);
                    return null;
                });
                ((CompletableFuture)obj.fetchAttributes().thenAcceptAsync(attrs -> this.considerAttributes(obj, (Map<String, ?>)attrs))).exceptionally(ex -> {
                    Msg.error((Object)this, (Object)("Could not fetch attributes of obj: " + obj), (Throwable)ex);
                    return null;
                });
            }
            return result;
        }

        @Override
        public void elementsChanged(TargetObject parent, Collection<String> removed, Map<String, ? extends TargetObject> added) {
            DebugModelConventions.runNotInSwing(this, () -> this.doElementsChanged(parent, removed, added), "elementsChanged");
        }

        private void doElementsChanged(TargetObject parent, Collection<String> removed, Map<String, ? extends TargetObject> added) {
            if (this.checkDescend(parent)) {
                this.considerElements(parent, added);
            }
        }

        @Override
        public void attributesChanged(TargetObject parent, Collection<String> removed, Map<String, ?> added) {
            DebugModelConventions.runNotInSwing(this, () -> this.doAttributesChanged(parent, removed, added), "attributesChanged");
        }

        private void doAttributesChanged(TargetObject parent, Collection<String> removed, Map<String, ?> added) {
            if (this.checkDescend(parent)) {
                this.considerAttributes(parent, added);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            NavigableMap<List<String>, TargetObject> navigableMap = this.objects;
            synchronized (navigableMap) {
                this.disposed = true;
                Iterator it = this.objects.values().iterator();
                while (it.hasNext()) {
                    TargetObject obj = (TargetObject)it.next();
                    obj.removeListener(this);
                    it.remove();
                }
            }
        }
    }
}

