/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.extend;

import ghidra.app.util.bin.format.MemoryLoadable;
import ghidra.app.util.bin.format.elf.ElfDynamicTable;
import ghidra.app.util.bin.format.elf.ElfDynamicType;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfProgramHeader;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.extend.ElfExtension;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class PowerPC_ElfExtension
extends ElfExtension {
    public static String GOT_THUNK_NAME = "get_pc_thunk_lr";
    private static int BLRL_INSTRUCTION = 1317011489;
    public static final ElfDynamicType DT_PPC_GOT = new ElfDynamicType(0x70000000, "DT_PPC_GOT", "Specify the value of _GLOBAL_OFFSET_TABLE_", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_PPC_OPT = new ElfDynamicType(0x70000001, "DT_PPC_OPT", "Specify that tls descriptors should be optimized", ElfDynamicType.ElfDynamicValueType.VALUE);
    private static final int EF_PPC_EMB = Integer.MIN_VALUE;
    private static final int EF_PPC_RELOCATABLE = 65536;
    private static final int EF_PPC_RELOCATABLE_LIB = 32768;
    private static final int PF_PPC_VLE = 0x10000000;
    private static final int SHF_PPC_VLE = 0x10000000;

    public boolean canHandle(ElfHeader elf) {
        return elf.e_machine() == 20 && elf.is32Bit();
    }

    public boolean canHandle(ElfLoadHelper elfLoadHelper) {
        Language language = elfLoadHelper.getProgram().getLanguage();
        return this.canHandle(elfLoadHelper.getElfHeader()) && "PowerPC".equals(language.getProcessor().toString()) && language.getLanguageDescription().getSize() == 32;
    }

    public String getDataTypeSuffix() {
        return "_PPC";
    }

    public void processElf(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        if (!this.canHandle(elfLoadHelper)) {
            return;
        }
        this.processPpcVleSections(elfLoadHelper, monitor);
    }

    public void processGotPlt(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        this.processDynamicPpcGotEntry(elfLoadHelper);
        super.processGotPlt(elfLoadHelper, monitor);
        this.markupGotBLRL(elfLoadHelper, monitor);
    }

    private void processDynamicPpcGotEntry(ElfLoadHelper elfLoadHelper) {
        ElfHeader elfHeader = elfLoadHelper.getElfHeader();
        ElfDynamicTable dynamicTable = elfHeader.getDynamicTable();
        if (dynamicTable == null || !dynamicTable.containsDynamicValue(DT_PPC_GOT)) {
            return;
        }
        try {
            Address gotAddr = elfLoadHelper.getDefaultAddress(dynamicTable.getDynamicValue(DT_PPC_GOT));
            Program program = elfLoadHelper.getProgram();
            Memory memory = program.getMemory();
            try {
                int dynamicOffset = memory.getInt(gotAddr) + (int)elfLoadHelper.getImageBaseWordAdjustmentOffset();
                elfLoadHelper.addFakeRelocTableEntry(gotAddr, 4);
                memory.setInt(gotAddr, dynamicOffset);
            }
            catch (AddressOverflowException | MemoryAccessException e) {
                elfLoadHelper.log(e);
            }
        }
        catch (NotFoundException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private boolean gotThunkCallFixupExists(Program program) {
        for (String fixupName : program.getCompilerSpec().getPcodeInjectLibrary().getCallFixupNames()) {
            if (!GOT_THUNK_NAME.equals(fixupName)) continue;
            return true;
        }
        return false;
    }

    private void markupGotBLRL(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        MemoryBlock[] blocks;
        Program program = elfLoadHelper.getProgram();
        Memory memory = program.getMemory();
        Listing listing = program.getListing();
        boolean applyCallFixup = this.gotThunkCallFixupExists(program);
        Disassembler disassembler = Disassembler.getDisassembler((Program)program, (TaskMonitor)monitor, null);
        for (MemoryBlock block : blocks = memory.getBlocks()) {
            Address blrlAddr;
            monitor.checkCanceled();
            MemoryBlock gotBlock = block;
            if (!gotBlock.getName().startsWith(".got") || !gotBlock.isExecute() || (blrlAddr = this.findBLRL(gotBlock, memory.isBigEndian())) == null) continue;
            listing.clearCodeUnits(blrlAddr, gotBlock.getEnd(), false);
            Address blrlEndAddr = blrlAddr.add(3L);
            AddressSet range = new AddressSet(blrlAddr, blrlEndAddr);
            disassembler.disassemble(blrlAddr, (AddressSetView)range);
            try {
                Instruction blrlInstr = listing.getInstructionAt(blrlAddr);
                if (blrlInstr == null) {
                    elfLoadHelper.log("Failed to generate blrl instruction within " + gotBlock.getName());
                    continue;
                }
                blrlInstr.setFlowOverride(FlowOverride.RETURN);
                Function f = listing.createFunction(GOT_THUNK_NAME + gotBlock.getName(), blrlAddr, (AddressSetView)range, SourceType.IMPORTED);
                if (!applyCallFixup) continue;
                f.setCallFixup(GOT_THUNK_NAME);
            }
            catch (OverlappingFunctionException | InvalidInputException throwable) {
                // empty catch block
            }
        }
    }

    private Address findBLRL(MemoryBlock block, boolean bigEndian) {
        BigEndianDataConverter conv = bigEndian ? BigEndianDataConverter.INSTANCE : LittleEndianDataConverter.INSTANCE;
        Address start = block.getStart();
        Address addr = block.getEnd();
        byte[] bytes = new byte[4];
        addr = addr.getNewAddress(addr.getOffset() & 0xFFFFFFFFFFFFFFFCL);
        try {
            while (addr.compareTo((Object)start) > 0) {
                if (block.getBytes(addr, bytes) == 4) {
                    int val = conv.getInt(bytes);
                    if (val == BLRL_INSTRUCTION) {
                        return addr;
                    }
                    if (val != 0) {
                        return null;
                    }
                }
                addr = addr.subtractNoWrap(4L);
            }
        }
        catch (AddressOverflowException | MemoryAccessException throwable) {
            // empty catch block
        }
        return null;
    }

    private void processPpcVleSections(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        Program program = elfLoadHelper.getProgram();
        LanguageID langID = program.getLanguageID();
        if (langID.toString().indexOf(":VLE") < 0) {
            return;
        }
        Register vleContextReg = program.getRegister("vle");
        if (vleContextReg == null || !vleContextReg.isProcessorContext()) {
            elfLoadHelper.log("ERROR: failed to locate 'vle' context register field");
            return;
        }
        monitor.setMessage("Checking for VLE sections...");
        RegisterValue enableVLE = new RegisterValue(vleContextReg, BigInteger.ONE);
        ElfHeader elf = elfLoadHelper.getElfHeader();
        if (elf.getSectionHeaderCount() != 0) {
            for (ElfSectionHeader section : elf.getSections(1)) {
                monitor.checkCanceled();
                if ((section.getFlags() & 0x10000000L) == 0L) continue;
                this.enableVLE((MemoryLoadable)section, enableVLE, elfLoadHelper);
            }
        } else {
            for (ElfProgramHeader segment : elf.getProgramHeaders(1)) {
                monitor.checkCanceled();
                if ((segment.getFlags() & 0x10000000) == 0) continue;
                this.enableVLE((MemoryLoadable)segment, enableVLE, elfLoadHelper);
            }
        }
    }

    private void enableVLE(MemoryLoadable header, RegisterValue enableVLE, ElfLoadHelper elfLoadHelper) {
        Address loadAddress = elfLoadHelper.findLoadAddress(header, 0L);
        if (loadAddress == null) {
            elfLoadHelper.log("Failed to locate VLE load section/segment");
            return;
        }
        Program program = elfLoadHelper.getProgram();
        MemoryBlock block = program.getMemory().getBlock(loadAddress);
        if (block != null) {
            elfLoadHelper.log("Marked block " + block.getName() + " as VLE");
            try {
                program.getProgramContext().setRegisterValue(block.getStart(), block.getEnd(), enableVLE);
            }
            catch (ContextChangeException e) {
                elfLoadHelper.log("ERROR: failed to set 'vle' context due to conflict: " + e.getMessage());
            }
        }
    }
}

