/*
 * Decompiled with CFR 0.152.
 */
package help;

import ghidra.util.Msg;
import ghidra.util.bean.GGlassPane;
import help.GHelpHTMLEditorKit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.help.DefaultHelpBroker;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.JHelpContentViewer;
import javax.help.WindowPresentation;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import resources.ResourceManager;

public class GHelpBroker
extends DefaultHelpBroker {
    private static final ImageIcon ZOOM_OUT_ICON = ResourceManager.loadImage((String)"images/list-remove.png");
    private static final ImageIcon ZOOM_IN_ICON = ResourceManager.loadImage((String)"images/list-add.png");
    private Dimension windowSize = new Dimension(1100, 700);
    protected JEditorPane htmlEditorPane;
    private Window activationWindow;

    public GHelpBroker(HelpSet hs) {
        super(hs);
    }

    public void setCurrentURL(URL URL2) {
        HelpModel model = this.getCustomHelpModel();
        if (model != null) {
            model.setCurrentURL(URL2, this.getHistoryName(URL2), null);
        } else {
            super.setCurrentURL(URL2);
        }
    }

    protected List<Image> getApplicationIcons() {
        return null;
    }

    protected HelpModel getCustomHelpModel() {
        return null;
    }

    protected void reloadHelpPage(URL url) {
        this.clearContentViewer();
        this.showNavigationAid(url);
        try {
            this.htmlEditorPane.setPage(url);
        }
        catch (IOException e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected error loading help page: " + url), (Throwable)e);
        }
    }

    protected void showNavigationAid(URL url) {
    }

    private void clearContentViewer() {
        this.htmlEditorPane.getDocument().putProperty("stream", null);
    }

    private JEditorPane getHTMLEditorPane(JHelpContentViewer contentViewer) {
        Component[] components = contentViewer.getComponents();
        JScrollPane scrollPane = (JScrollPane)components[0];
        JViewport viewport = scrollPane.getViewport();
        return (JEditorPane)viewport.getView();
    }

    public void setDisplayed(boolean b) {
        if (!b) {
            super.setDisplayed(b);
            return;
        }
        this.initializeScreenDevice();
        WindowPresentation windowPresentation = this.getWindowPresentation();
        this.updateWindowSize(windowPresentation);
        super.setDisplayed(b);
        this.initializeUIWindowPresentation(windowPresentation);
    }

    private void initializeScreenDevice() {
        if (this.isInitialized()) {
            return;
        }
        if (this.activationWindow == null) {
            return;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        GraphicsConfiguration config = this.activationWindow.getGraphicsConfiguration();
        GraphicsDevice parentDevice = config.getDevice();
        for (int i = 0; i < gs.length; ++i) {
            if (gs[i] != parentDevice) continue;
            this.setScreen(i);
        }
    }

    private void initializeUIWindowPresentation(WindowPresentation windowPresentation) {
        Window helpWindow = windowPresentation.getHelpWindow();
        Container contentPane = null;
        if (helpWindow instanceof JFrame) {
            JFrame frame = (JFrame)helpWindow;
            this.installRootPane(frame);
            List<Image> icons = this.getApplicationIcons();
            if (icons != null) {
                frame.setIconImages(icons);
            }
            contentPane = frame.getContentPane();
        } else if (helpWindow instanceof JDialog) {
            JDialog dialog = (JDialog)helpWindow;
            this.installRootPane(dialog);
            contentPane = dialog.getContentPane();
        }
        this.initializeUIComponents(contentPane);
    }

    private boolean isInitialized() {
        return this.htmlEditorPane != null;
    }

    private void initializeUIComponents(Container contentPane) {
        if (this.isInitialized()) {
            return;
        }
        Component[] components = contentPane.getComponents();
        JHelp jHelp = (JHelp)components[0];
        this.addCustomToolbarItems(jHelp);
        JHelpContentViewer contentViewer = jHelp.getContentViewer();
        this.htmlEditorPane = this.getHTMLEditorPane(contentViewer);
        HelpModel helpModel = this.getCustomHelpModel();
        this.installHelpSearcher(jHelp, helpModel);
        if (helpModel != null) {
            this.installHelpSearcher(jHelp, helpModel);
        }
        this.installActions(jHelp);
    }

    protected void installHelpSearcher(JHelp jHelp, HelpModel helpModel) {
    }

    protected void addCustomToolbarItems(JHelp jHelp) {
        for (Component component : jHelp.getComponents()) {
            if (!(component instanceof JToolBar)) continue;
            JToolBar toolbar = (JToolBar)component;
            toolbar.addSeparator();
            ImageIcon zoomOutIcon = ResourceManager.getScaledIcon((Icon)ZOOM_OUT_ICON, (int)24, (int)24);
            JButton zoomOutBtn = new JButton(zoomOutIcon);
            zoomOutBtn.setToolTipText("Zoom out");
            zoomOutBtn.addActionListener(e -> {
                GHelpHTMLEditorKit.zoomOut();
                this.reloadHelpPage(this.getCurrentURL());
            });
            toolbar.add(zoomOutBtn);
            ImageIcon zoomInIcon = ResourceManager.getScaledIcon((Icon)ZOOM_IN_ICON, (int)24, (int)24);
            JButton zoomInBtn = new JButton(zoomInIcon);
            zoomInBtn.setToolTipText("Zoom in");
            zoomInBtn.addActionListener(e -> {
                GHelpHTMLEditorKit.zoomIn();
                this.reloadHelpPage(this.getCurrentURL());
            });
            toolbar.add(zoomInBtn);
            break;
        }
    }

    protected void installActions(JHelp help) {
    }

    private String getHistoryName(URL URL2) {
        String ref;
        Object text = URL2.getFile();
        int index = ((String)text).lastIndexOf(47);
        if (index != -1) {
            text = ((String)text).substring(index + 1);
        }
        if ((ref = URL2.getRef()) != null) {
            text = (String)text + " - " + ref;
        }
        return text;
    }

    private void installRootPane(JFrame frame) {
        Component oldGlassPane = frame.getGlassPane();
        if (!(oldGlassPane instanceof GGlassPane)) {
            GGlassPane gGlassPane = new GGlassPane();
            frame.setGlassPane((Component)gGlassPane);
            gGlassPane.setVisible(true);
        }
    }

    private void installRootPane(JDialog dialog) {
        Component oldGlassPane = dialog.getGlassPane();
        if (!(oldGlassPane instanceof GGlassPane)) {
            GGlassPane gGlassPane = new GGlassPane();
            dialog.setGlassPane((Component)gGlassPane);
            gGlassPane.setVisible(true);
        }
    }

    private void updateWindowSize(WindowPresentation presentation) {
        if (this.windowSize == null) {
            return;
        }
        presentation.createHelpWindow();
        presentation.setSize(this.windowSize);
    }

    public void setActivationWindow(Window window) {
        WindowPresentation windowPresentation = this.getWindowPresentation();
        Window helpWindow = windowPresentation.getHelpWindow();
        if (helpWindow == null) {
            this.activationWindow = window;
            super.setActivationWindow(window);
            return;
        }
        this.windowSize = helpWindow.getSize();
        boolean wasModal = this.isModalWindow(helpWindow);
        boolean willBeModal = this.isModalWindow(window);
        if (!wasModal && willBeModal) {
            helpWindow.setVisible(false);
        }
        super.setActivationWindow(window);
    }

    private boolean isModalWindow(Window window) {
        Dialog dialog;
        return window instanceof Dialog && (dialog = (Dialog)window).isModal();
    }
}

