/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.hfsexplorer.Util;

public class JournalInfoBlock {
    public static final int kJIJournalInFSMask = 1;
    public static final int kJIJournalOnOtherDeviceMask = 2;
    public static final int kJIJournalNeedInitMask = 4;
    private final byte[] flags = new byte[4];
    private final byte[] deviceSignature = new byte[32];
    private final byte[] offset = new byte[8];
    private final byte[] size = new byte[8];
    private final byte[] reserved = new byte[128];

    public JournalInfoBlock(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.flags, 0, 4);
        System.arraycopy(data, offset + 4, this.deviceSignature, 0, 32);
        System.arraycopy(data, offset + 36, this.offset, 0, 8);
        System.arraycopy(data, offset + 44, this.size, 0, 8);
        System.arraycopy(data, offset + 52, this.reserved, 0, 128);
    }

    public static int length() {
        return 180;
    }

    public int getFlags() {
        return Util.readIntBE(this.flags);
    }

    public int[] getDeviceSignature() {
        return Util.readIntArrayBE(this.deviceSignature);
    }

    public long getOffset() {
        return Util.readLongBE(this.offset);
    }

    public long getSize() {
        return Util.readLongBE(this.size);
    }

    public int[] getReserved() {
        return Util.readIntArrayBE(this.reserved);
    }

    public static int getStructSize() {
        return 180;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " flags: " + this.getFlags());
        ps.println(prefix + " deviceSignature: " + this.getDeviceSignature());
        ps.println(prefix + " offset: " + this.getOffset());
        ps.println(prefix + " size: " + this.getSize());
        ps.println(prefix + " reserved: " + this.getReserved());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "JournalInfoBlock:");
        this.printFields(ps, prefix);
    }
}

