/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.edge;

import com.google.common.base.Function;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import java.awt.BasicStroke;
import java.awt.Stroke;

public class VisualGraphEdgeStrokeTransformer<V extends VisualVertex, E extends VisualEdge<V>>
implements Function<E, Stroke> {
    private static final Stroke BASIC_STROKE = new BasicStroke(1.0f);
    private final Stroke HEAVY_STROKE;
    private final PickedInfo<E> pickedInfo;

    public VisualGraphEdgeStrokeTransformer(PickedInfo<E> pickedInfo, int pickedStrokeSize) {
        this.HEAVY_STROKE = new BasicStroke(pickedStrokeSize);
        this.pickedInfo = pickedInfo;
    }

    public Stroke apply(E e) {
        if (this.pickedInfo.isPicked(e)) {
            return this.HEAVY_STROKE;
        }
        return BASIC_STROKE;
    }
}

