/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.jung;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;

public class JungDirectedGraph<V, E extends GEdge<V>>
extends DirectedSparseGraph<V, E>
implements GDirectedGraph<V, E> {
    @Override
    public void addEdge(E e) {
        super.addEdge(e, e.getStart(), e.getEnd());
    }

    @Override
    public void removeVertices(Iterable<V> toRemove) {
        toRemove.forEach(v -> super.removeVertex(v));
    }

    @Override
    public void removeEdges(Iterable<E> toRemove) {
        toRemove.forEach(e -> super.removeEdge(e));
    }

    @Override
    public boolean containsEdge(V from, V to) {
        return this.findEdge(from, to) != null;
    }

    @Override
    public GDirectedGraph<V, E> emptyCopy() {
        JungDirectedGraph<V, E> newGraph = new JungDirectedGraph<V, E>();
        return newGraph;
    }

    @Override
    public GDirectedGraph<V, E> copy() {
        JungDirectedGraph<V, E> newGraph = new JungDirectedGraph<V, E>();
        for (Object v : this.vertices.keySet()) {
            newGraph.addVertex(v);
        }
        for (GEdge e : this.edges.keySet()) {
            newGraph.addEdge(e);
        }
        return newGraph;
    }

    @Override
    public boolean isEmpty() {
        return this.getVertexCount() == 0;
    }
}

