/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.DynamicHash;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.SymbolEntry;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class DynamicEntry
extends SymbolEntry {
    private long hash;

    public DynamicEntry(HighSymbol sym) {
        super(sym);
    }

    public DynamicEntry(HighSymbol sym, Address addr, long h) {
        super(sym);
        this.pcaddr = addr;
        this.hash = h;
    }

    public long getHash() {
        return this.hash;
    }

    @Override
    public void decode(Decoder decoder) throws DecoderException {
        int addrel = decoder.openElement(ElementId.ELEM_HASH);
        this.hash = decoder.readUnsignedInteger(AttributeId.ATTRIB_VAL);
        decoder.closeElement(addrel);
        this.decodeRangeList(decoder);
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_HASH);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_VAL, this.hash);
        encoder.closeElement(ElementId.ELEM_HASH);
        this.encodeRangelist(encoder);
    }

    @Override
    public VariableStorage getStorage() {
        Program program = this.symbol.getProgram();
        try {
            return new VariableStorage(program, AddressSpace.HASH_SPACE.getAddress(this.getHash()), this.getSize());
        }
        catch (InvalidInputException e) {
            throw new AssertException("Unexpected exception", (Throwable)e);
        }
    }

    public static DynamicEntry build(Varnode vn) {
        HighVariable highVariable = vn.getHigh();
        HighSymbol highSymbol = highVariable.getSymbol();
        HighFunction highFunction = highSymbol.getHighFunction();
        DynamicHash dynamicHash = new DynamicHash(vn, highFunction);
        DynamicEntry entry = new DynamicEntry(highSymbol, dynamicHash.getAddress(), dynamicHash.getHash());
        return entry;
    }

    @Override
    public int getSize() {
        return this.symbol.type.getLength();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isVolatile() {
        return false;
    }
}

