/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.DynamicVariableStorage;
import ghidra.program.model.lang.ParamEntry;
import ghidra.program.model.lang.ParamListRegisterOut;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.util.exception.InvalidInputException;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;

public class ParamListStandardOut
extends ParamListRegisterOut {
    @Override
    public void assignMap(Program prog, DataType[] proto, ArrayList<VariableStorage> res, boolean addAutoParams) {
        int[] status = new int[this.numgroup];
        for (int i = 0; i < this.numgroup; ++i) {
            status[i] = 0;
        }
        VariableStorage store = this.assignAddress(prog, proto[0], status, false, false);
        if (!store.isUnassignedStorage()) {
            res.add(store);
            return;
        }
        Pointer pointer = prog.getDataTypeManager().getPointer(proto[0]);
        store = this.assignAddress(prog, pointer, status, false, false);
        try {
            if (store.isValid()) {
                store = new DynamicVariableStorage(prog, true, store.getVarnodes());
                res.add(store);
            }
            if (addAutoParams) {
                res.add(VariableStorage.UNASSIGNED_STORAGE);
            }
        }
        catch (InvalidInputException e) {
            store = VariableStorage.UNASSIGNED_STORAGE;
            res.add(store);
        }
    }

    @Override
    public void restoreXml(XmlPullParser parser, CompilerSpec cspec) throws XmlParseException {
        super.restoreXml(parser, cspec);
        for (int i = 1; i < this.entry.length; ++i) {
            for (int j = 0; j < i; ++j) {
                ParamEntry.orderWithinGroup(this.entry[j], this.entry[i]);
            }
        }
    }
}

