/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.InstructionContext;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Mask;
import ghidra.program.model.lang.ParserContext;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.UnknownContextException;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.PatchEncoder;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOverride;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import java.io.IOException;
import java.util.ArrayList;

public interface InstructionPrototype {
    public static final int INVALID_DEPTH_CHANGE = 0x1000000;

    public ParserContext getParserContext(MemBuffer var1, ProcessorContextView var2) throws MemoryAccessException;

    public ParserContext getPseudoParserContext(Address var1, MemBuffer var2, ProcessorContextView var3) throws InsufficientBytesException, UnknownInstructionException, UnknownContextException, MemoryAccessException;

    public boolean hasDelaySlots();

    public boolean hasCrossBuildDependency();

    public String getMnemonic(InstructionContext var1);

    public int getLength();

    public Mask getInstructionMask();

    public Mask getOperandValueMask(int var1);

    public FlowType getFlowType(InstructionContext var1);

    public int getDelaySlotDepth(InstructionContext var1);

    public int getDelaySlotByteCount();

    public boolean isInDelaySlot();

    public int getNumOperands();

    public int getOpType(int var1, InstructionContext var2);

    public Address getFallThrough(InstructionContext var1);

    public int getFallThroughOffset(InstructionContext var1);

    public Address[] getFlows(InstructionContext var1);

    public String getSeparator(int var1, InstructionContext var2);

    public ArrayList<Object> getOpRepresentationList(int var1, InstructionContext var2);

    public Address getAddress(int var1, InstructionContext var2);

    public Scalar getScalar(int var1, InstructionContext var2);

    public Register getRegister(int var1, InstructionContext var2);

    public Object[] getOpObjects(int var1, InstructionContext var2);

    public RefType getOperandRefType(int var1, InstructionContext var2, PcodeOverride var3);

    public boolean hasDelimeter(int var1);

    public Object[] getInputObjects(InstructionContext var1);

    public Object[] getResultObjects(InstructionContext var1);

    public PcodeOp[] getPcode(InstructionContext var1, PcodeOverride var2);

    public void getPcodePacked(PatchEncoder var1, InstructionContext var2, PcodeOverride var3) throws IOException;

    public PcodeOp[] getPcode(InstructionContext var1, int var2);

    public Language getLanguage();
}

