/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.CategoryPath;

public class DataTypePath {
    private final CategoryPath categoryPath;
    private final String dataTypeName;

    public DataTypePath(String categoryPath, String dataTypeName) {
        this(new CategoryPath(categoryPath), dataTypeName);
    }

    public DataTypePath(CategoryPath categoryPath, String dataTypeName) {
        if (dataTypeName == null || categoryPath == null) {
            throw new IllegalArgumentException("null not allowed for categoryPath or datatypeName");
        }
        this.categoryPath = categoryPath;
        this.dataTypeName = dataTypeName;
    }

    public CategoryPath getCategoryPath() {
        return this.categoryPath;
    }

    public boolean isAncestor(CategoryPath otherCategoryPath) {
        return this.categoryPath.isAncestorOrSelf(otherCategoryPath);
    }

    public String getDataTypeName() {
        return this.dataTypeName;
    }

    public String getPath() {
        StringBuffer buf = new StringBuffer(this.categoryPath.getPath());
        if (buf.charAt(buf.length() - 1) != '/') {
            buf.append('/');
        }
        buf.append(this.dataTypeName);
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.categoryPath.hashCode();
        result = 31 * result + this.dataTypeName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataTypePath other = (DataTypePath)obj;
        if (!this.categoryPath.equals(other.categoryPath)) {
            return false;
        }
        return this.dataTypeName.equals(other.dataTypeName);
    }

    public String toString() {
        return this.getPath();
    }
}

