/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.AlignedStructurePacker;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.InternalDataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureInternal;
import ghidra.util.exception.DuplicateNameException;
import java.util.ArrayList;
import java.util.List;
import javax.help.UnsupportedOperationException;

public class AlignedStructureInspector
extends AlignedStructurePacker {
    private AlignedStructureInspector(StructureInternal structure) {
        super(structure, AlignedStructureInspector.getComponentWrappers(structure));
    }

    private static List<ReadOnlyComponentWrapper> getComponentWrappers(Structure structure) {
        ArrayList<ReadOnlyComponentWrapper> list = new ArrayList<ReadOnlyComponentWrapper>();
        for (DataTypeComponent c : structure.getDefinedComponents()) {
            list.add(new ReadOnlyComponentWrapper(c));
        }
        return list;
    }

    public static AlignedStructurePacker.StructurePackResult packComponents(StructureInternal structure) {
        AlignedStructureInspector packer = new AlignedStructureInspector(structure);
        return packer.pack();
    }

    private static class ReadOnlyComponentWrapper
    implements InternalDataTypeComponent {
        private final DataTypeComponent component;
        private int ordinal;
        private int offset;
        private int length;
        private DataType dataType;

        ReadOnlyComponentWrapper(DataTypeComponent component) {
            this.component = component;
            this.ordinal = component.getOrdinal();
            this.offset = component.getOffset();
            this.length = component.getLength();
            this.dataType = component.getDataType();
        }

        @Override
        public void update(int ord, int off, int len) {
            this.ordinal = ord;
            this.offset = off;
            this.length = len;
        }

        @Override
        public DataType getDataType() {
            return this.dataType;
        }

        @Override
        public DataType getParent() {
            return this.component.getParent();
        }

        @Override
        public boolean isBitFieldComponent() {
            return this.component.isBitFieldComponent();
        }

        @Override
        public boolean isZeroBitFieldComponent() {
            return this.component.isZeroBitFieldComponent();
        }

        @Override
        public int getOrdinal() {
            return this.ordinal;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getEndOffset() {
            return this.offset + this.length - 1;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public String getComment() {
            return this.component.getComment();
        }

        @Override
        public Settings getDefaultSettings() {
            return this.component.getDefaultSettings();
        }

        @Override
        public void setComment(String comment) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFieldName() {
            return this.component.getFieldName();
        }

        @Override
        public void setFieldName(String fieldName) throws DuplicateNameException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDefaultFieldName() {
            if (this.isZeroBitFieldComponent()) {
                return "";
            }
            return "field_0x" + Integer.toHexString(this.getOffset());
        }

        @Override
        public boolean isEquivalent(DataTypeComponent dtc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDataType(DataType dataType) {
            this.dataType = dataType;
        }
    }
}

