/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.oldfunction;

import db.DBHandle;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.oldfunction.OldFunctionManager;
import ghidra.program.database.util.SharedRangeMapDB;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.datastruct.IndexRange;
import ghidra.util.datastruct.IndexRangeIterator;

class OldFunctionMapDB {
    private AddressMap addrMap;
    private SharedRangeMapDB rangeMap;

    OldFunctionMapDB(DBHandle dbHandle, OldFunctionManager fnMgr, AddressMap addrMap) {
        this.addrMap = addrMap;
        this.rangeMap = new SharedRangeMapDB(dbHandle, "Functions", fnMgr, false);
    }

    synchronized void dispose() {
        if (this.rangeMap != null) {
            this.rangeMap.dispose();
            this.rangeMap = null;
        }
    }

    synchronized AddressSetView getBody(long functionKey) {
        AddressSet body = new AddressSet();
        IndexRangeIterator iter = this.rangeMap.getValueRangeIterator(functionKey);
        while (iter.hasNext()) {
            IndexRange range = iter.next();
            body.addRange(this.addrMap.decodeAddress(range.getStart()), this.addrMap.decodeAddress(range.getEnd()));
        }
        return body;
    }
}

