/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.map;

import db.DBHandle;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressMapDBAdapter;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.KeyRange;
import ghidra.program.model.address.OldGenericNamespaceAddress;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.LanguageTranslator;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class AddressMapDB
implements AddressMap {
    static final int ADDR_TYPE_SIZE = 4;
    private static final long ADDR_TYPE_SHIFT = 60L;
    private static final int ADDR_TYPE_MASK = 15;
    static final int ADDR_OFFSET_SIZE = 32;
    private static final long MAX_OFFSET = 0xFFFFFFFFL;
    static final long ADDR_OFFSET_MASK = 0xFFFFFFFFL;
    static final long BASE_MASK = -4294967296L;
    private static final int HASH_OFFSET_SIZE = AddressSpace.HASH_SPACE.getSize();
    private static final long HASH_OFFSET_MASK = (1L << HASH_OFFSET_SIZE) - 1L;
    private static final int ID_SIZE = 28;
    private static final int ID_MASK = 0xFFFFFFF;
    private static final int OLD_ADDRESS_KEY_TYPE = 0;
    private static final int ABSOLUTE_ADDR_TYPE = 1;
    private static final int RELOCATABLE_ADDR_TYPE = 2;
    private static final int REGISTER_ADDR_TYPE = 3;
    private static final int STACK_ADDR_TYPE = 4;
    private static final int EXTERNAL_ADDR_TYPE = 5;
    private static final int VARIABLE_ADDR_TYPE = 6;
    private static final int HASH_ADDR_TYPE = 7;
    private static final int NO_ADDR_TYPE = 15;
    private static final long RELOCATABLE_ADDR_TYPE_LONG = 0x2000000000000000L;
    private static final long ABSOLUTE_ADDR_TYPE_LONG = 0x1000000000000000L;
    private static final long REGISTER_ADDR_TYPE_LONG = 0x3000000000000000L;
    private static final long STACK_ADDR_TYPE_LONG = 0x4000000000000000L;
    private static final long EXTERNAL_ADDR_TYPE_LONG = 0x5000000000000000L;
    private static final long VARIABLE_ADDR_TYPE_LONG = 0x6000000000000000L;
    private static final long HASH_ADDR_TYPE_LONG = 0x7000000000000000L;
    private AddressFactory addrFactory;
    private boolean readOnly;
    private AddressMap oldAddrMap;
    private boolean useOldAddrMap = false;
    private AddressSpace defaultAddrSpace;
    private AddressMapDBAdapter adapter;
    private Address[] baseAddrs;
    private Address[] sortedBaseStartAddrs;
    private Address[] sortedBaseEndAddrs;
    private List<KeyRange> allKeyRanges;
    private HashMap<Address, Integer> addrToIndexMap = new HashMap();
    private Address lastBaseAddress;
    private int lastIndex;
    private long baseImageOffset;
    private List<AddressRange> segmentedRanges;
    private static final long EXT_FROM_ADDRESS_LONG = -2L;
    private static final int INDEX_CREATE = 0;
    private static final int INDEX_MATCH = 1;
    private static final int INDEX_MATCH_OR_NEXT = 2;
    private static final int INDEX_MATCH_OR_PREVIOUS = 3;
    private Comparator<Address> normalizingAddressComparator = new Comparator<Address>(){

        @Override
        public int compare(Address normalizedAddr, Address addr) {
            AddressSpace space = addr.getAddressSpace();
            int comp = normalizedAddr.getAddressSpace().compareTo(space);
            if (comp == 0) {
                long otherOffset = addr.getOffset() - AddressMapDB.this.baseImageOffset;
                long offset = normalizedAddr.getOffset();
                return Long.compareUnsigned(offset, otherOffset);
            }
            return comp;
        }
    };
    private Comparator<Object> addressInsertionKeyRangeComparator = new Comparator<Object>(){

        @Override
        public int compare(Object keyRangeObj, Object addrObj) {
            KeyRange range = (KeyRange)keyRangeObj;
            Address addr = (Address)addrObj;
            Address min = AddressMapDB.this.decodeAddress(range.minKey);
            if (min.compareTo(addr) > 0) {
                return 1;
            }
            Address max = AddressMapDB.this.decodeAddress(range.maxKey);
            if (max.compareTo(addr) < 0) {
                return -1;
            }
            return 0;
        }
    };
    private static Comparator<Object> ADDRESS_RANGE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            AddressRange range = (AddressRange)o1;
            Address addr = (Address)o2;
            if (range.contains(addr)) {
                return 0;
            }
            return range.getMinAddress().compareTo(addr);
        }
    };

    public AddressMapDB(DBHandle handle, int openMode, AddressFactory factory, long baseImageOffset, TaskMonitor monitor) throws IOException, VersionException {
        this.readOnly = openMode == 2;
        this.addrFactory = factory;
        this.baseImageOffset = baseImageOffset;
        this.defaultAddrSpace = this.addrFactory.getDefaultAddressSpace();
        this.adapter = AddressMapDBAdapter.getAdapter(handle, openMode, this.addrFactory, monitor);
        this.oldAddrMap = this.adapter.oldAddrMap != null ? this.adapter.oldAddrMap : this;
        this.useOldAddrMap = openMode == 2 && this.oldAddrMap != this;
        this.baseAddrs = this.adapter.getBaseAddresses(false);
        this.init(true);
    }

    public synchronized void memoryMapChanged(MemoryMapDB mem) {
        if (!(this.addrFactory.getDefaultAddressSpace() instanceof SegmentedAddressSpace)) {
            this.segmentedRanges = null;
            return;
        }
        MemoryBlock[] blocks = mem.getBlocks();
        this.segmentedRanges = new ArrayList<AddressRange>(blocks.length);
        for (MemoryBlock block : blocks) {
            this.segmentedRanges.add(new AddressRangeImpl(block.getStart(), block.getEnd()));
        }
    }

    private void init(boolean rebuildAddrToIndexMap) {
        int i;
        this.allKeyRanges = null;
        this.sortedBaseEndAddrs = new Address[this.baseAddrs.length];
        this.sortedBaseStartAddrs = new Address[this.baseAddrs.length];
        System.arraycopy(this.baseAddrs, 0, this.sortedBaseStartAddrs, 0, this.baseAddrs.length);
        Arrays.sort(this.sortedBaseStartAddrs);
        for (i = 0; i < this.sortedBaseStartAddrs.length; ++i) {
            long max = this.sortedBaseStartAddrs[i].getAddressSpace().getMaxAddress().getOffset();
            max = max < 0L ? 0xFFFFFFFFL : Math.min(max, 0xFFFFFFFFL);
            long off = this.sortedBaseStartAddrs[i].getOffset() | max;
            this.sortedBaseEndAddrs[i] = this.sortedBaseStartAddrs[i].getAddressSpace().getAddressInThisSpaceOnly(off);
        }
        if (rebuildAddrToIndexMap) {
            this.addrToIndexMap.clear();
            for (i = 0; i < this.baseAddrs.length; ++i) {
                this.addrToIndexMap.put(this.baseAddrs[i], i);
            }
        }
    }

    public synchronized void invalidateCache() throws IOException {
        this.lastBaseAddress = null;
        if (!this.readOnly) {
            this.baseAddrs = this.adapter.getBaseAddresses(true);
            this.init(true);
        }
    }

    @Override
    public AddressMap getOldAddressMap() {
        return this.useOldAddrMap ? this : this.oldAddrMap;
    }

    @Override
    public boolean isUpgraded() {
        return this.getOldAddressMap() != this;
    }

    @Override
    public synchronized long getKey(Address addr, boolean create) {
        if (this.useOldAddrMap) {
            return this.oldAddrMap.getKey(addr, create);
        }
        try {
            return this.encodeRelative(addr, false, create ? 0 : 1);
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
    }

    private boolean isInDefaultAddressSpace(Address addr) {
        return addr.getAddressSpace().equals(this.defaultAddrSpace);
    }

    private long getNormalizedOffset(Address addr) {
        long offset = addr.getOffset() - this.baseImageOffset;
        long maxOffset = addr.getAddressSpace().getMaxAddress().getOffset();
        if (maxOffset > 0L && offset < 0L) {
            return offset + maxOffset + 1L;
        }
        return offset;
    }

    @Override
    public synchronized long getAbsoluteEncoding(Address addr, boolean create) {
        if (this.useOldAddrMap) {
            return this.oldAddrMap.getAbsoluteEncoding(addr, create);
        }
        return this.encodeAbsolute(addr, create ? 0 : 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long encodeAbsolute(Address addr, int indexOperation) {
        if (addr instanceof OldGenericNamespaceAddress) {
            return this.encodeOldNamespaceAddr((OldGenericNamespaceAddress)addr);
        }
        switch (addr.getAddressSpace().getType()) {
            case 14: {
                if (addr.isHashAddress()) {
                    return 0x7000000000000000L | addr.getOffset();
                }
            }
            case 1: 
            case 2: 
            case 7: 
            case 13: {
                long offset;
                int baseIndex = this.getBaseAddressIndex(addr, false, indexOperation);
                if (baseIndex < 0) {
                    if (baseIndex == Integer.MIN_VALUE) {
                        return -1L;
                    }
                    baseIndex = -baseIndex - 1;
                    if (indexOperation == 3) {
                        offset = 0xFFFFFFFFL;
                        return 0x1000000000000000L | (long)baseIndex << 32 | offset;
                    } else {
                        if (indexOperation != 2) throw new AssertException("unexpected negative base index");
                        offset = 0L;
                    }
                    return 0x1000000000000000L | (long)baseIndex << 32 | offset;
                } else {
                    offset = addr.getOffset() & 0xFFFFFFFFL;
                }
                return 0x1000000000000000L | (long)baseIndex << 32 | offset;
            }
            case 11: {
                return 0x6000000000000000L | addr.getOffset() & 0xFFFFFFFFL;
            }
            case 4: {
                return 0x3000000000000000L | addr.getOffset() & 0xFFFFFFFFL;
            }
            case 5: {
                return 0x4000000000000000L | addr.getOffset() & 0xFFFFFFFFL;
            }
            case 10: {
                return 0x5000000000000000L | addr.getOffset() & 0xFFFFFFFFL;
            }
            case 15: {
                if (addr != Address.EXT_FROM_ADDRESS) return -1L;
                return -2L;
            }
        }
        throw new IllegalArgumentException("Address type can not be encoded");
    }

    private int getBaseAddressIndex(Address addr, boolean normalize, int indexOperation) {
        int nextIndex;
        Address base;
        int search;
        long normalizedOffset = normalize ? this.getNormalizedOffset(addr) : addr.getOffset();
        long normalizedBaseOffset = normalizedOffset & 0xFFFFFFFF00000000L;
        AddressSpace space = addr.getAddressSpace();
        Address tBase = space.getAddressInThisSpaceOnly(normalizedBaseOffset);
        if (tBase.equals(this.lastBaseAddress)) {
            return this.lastIndex;
        }
        Integer tIndex = this.addrToIndexMap.get(tBase);
        if (tIndex != null) {
            this.lastBaseAddress = tBase;
            this.lastIndex = tIndex;
            return tIndex;
        }
        if (indexOperation == 1) {
            return Integer.MIN_VALUE;
        }
        int n = search = normalize ? Arrays.binarySearch(this.sortedBaseStartAddrs, addr, this.normalizingAddressComparator) : Arrays.binarySearch(this.sortedBaseStartAddrs, addr);
        if (search < 0) {
            search = -search - 2;
        }
        if (search >= 0 && (base = this.sortedBaseStartAddrs[search]).hasSameAddressSpace(addr) && normalizedBaseOffset == base.getOffset()) {
            int index = this.addrToIndexMap.get(base);
            return index;
        }
        if (indexOperation == 3 && search >= 0) {
            base = this.sortedBaseStartAddrs[search];
            int index = this.addrToIndexMap.get(base);
            return -index - 1;
        }
        if (indexOperation == 2 && (nextIndex = search + 1) < this.sortedBaseStartAddrs.length) {
            Address base2 = this.sortedBaseStartAddrs[nextIndex];
            int index = this.addrToIndexMap.get(base2);
            return -index - 1;
        }
        if (indexOperation != 0) {
            return Integer.MIN_VALUE;
        }
        this.checkAddressSpace(addr.getAddressSpace());
        int index = this.baseAddrs.length;
        if (this.readOnly) {
            Address[] newBaseAddrs = new Address[this.baseAddrs.length + 1];
            System.arraycopy(this.baseAddrs, 0, newBaseAddrs, 0, this.baseAddrs.length);
            newBaseAddrs[index] = addr.getAddressSpace().getAddressInThisSpaceOnly(normalizedBaseOffset);
            this.baseAddrs = newBaseAddrs;
        } else {
            this.baseAddrs = this.adapter.addBaseAddress(addr, normalizedBaseOffset);
            if (this.baseAddrs.length == 101) {
                Msg.warn((Object)this, (Object)"More than 100 address segments have been created!", null);
            }
        }
        this.addrToIndexMap.put(this.baseAddrs[index], index);
        this.init(false);
        return index;
    }

    void checkAddressSpace(AddressSpace addrSpace) {
        AddressSpace[] spaces;
        for (AddressSpace space : spaces = this.addrFactory.getPhysicalSpaces()) {
            if (!addrSpace.equals(space)) continue;
            return;
        }
        if (addrSpace.getPhysicalSpace() != AddressSpace.OTHER_SPACE) {
            throw new IllegalArgumentException("Address space not found in program");
        }
    }

    @Override
    public synchronized Address decodeAddress(long value) {
        return this.decodeAddress(value, true);
    }

    public synchronized Address decodeAddress(long value, boolean useMemorySegmentation) {
        Address addr;
        try {
            addr = this.decode(value);
            if (useMemorySegmentation) {
                addr = this.normalize(addr);
            }
        }
        catch (AddressOutOfBoundsException e) {
            addr = Address.NO_ADDRESS;
        }
        return addr;
    }

    private Address normalize(Address addr) {
        if (this.segmentedRanges == null || !(addr instanceof SegmentedAddress)) {
            return addr;
        }
        int index = Collections.binarySearch(this.segmentedRanges, addr, ADDRESS_RANGE_COMPARATOR);
        if (index >= 0) {
            SegmentedAddress segAddr = (SegmentedAddress)addr;
            int seg = ((SegmentedAddress)this.segmentedRanges.get(index).getMinAddress()).getSegment();
            return segAddr.normalize(seg);
        }
        return addr;
    }

    private Address decode(long value) {
        if (this.useOldAddrMap) {
            return this.oldAddrMap.decodeAddress(value);
        }
        int type = (int)(value >> 60 & 0xFL);
        switch (type) {
            case 0: {
                return this.addrFactory.oldGetAddressFromLong(value);
            }
            case 1: {
                int baseIndex = (int)(value >> 32 & 0xFFFFFFFL);
                long offset = value & 0xFFFFFFFFL;
                try {
                    return this.baseAddrs[baseIndex].add(offset);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    throw e;
                }
            }
            case 2: {
                int baseIndex = (int)(value >> 32 & 0xFFFFFFFL);
                long offset = value & 0xFFFFFFFFL;
                if (baseIndex >= this.baseAddrs.length) {
                    return Address.NO_ADDRESS;
                }
                Address base = this.baseAddrs[baseIndex];
                if (base.getAddressSpace().equals(this.defaultAddrSpace)) {
                    offset += this.baseImageOffset;
                }
                return this.baseAddrs[baseIndex].addWrapSpace(offset);
            }
            case 6: {
                long offset = value & 0xFFFFFFFFL;
                return AddressSpace.VARIABLE_SPACE.getAddress(offset);
            }
            case 3: {
                int nameSpaceID = (int)(value >> 32 & 0xFFFFFFFL);
                long offset = value & 0xFFFFFFFFL;
                if ((long)nameSpaceID != 0L) {
                    return new OldGenericNamespaceAddress(this.addrFactory.getRegisterSpace(), offset, nameSpaceID);
                }
                return this.addrFactory.getRegisterSpace().getAddress(offset);
            }
            case 4: {
                int nameSpaceID = (int)(value >> 32 & 0xFFFFFFFL);
                long offset = (int)(value & 0xFFFFFFFFL);
                AddressSpace stackSpace = this.addrFactory.getStackSpace();
                if ((long)nameSpaceID != 0L) {
                    try {
                        return new OldGenericNamespaceAddress(stackSpace, offset, nameSpaceID);
                    }
                    catch (AddressOutOfBoundsException e) {
                        return new OldGenericNamespaceAddress(stackSpace, this.truncateStackOffset(offset, stackSpace), nameSpaceID);
                    }
                }
                try {
                    return stackSpace.getAddress(offset);
                }
                catch (AddressOutOfBoundsException e) {
                    return stackSpace.getAddress(this.truncateStackOffset(offset, stackSpace));
                }
            }
            case 5: {
                int nameSpaceID = (int)(value >> 32 & 0xFFFFFFFL);
                long offset = value & 0xFFFFFFFFL;
                if ((long)nameSpaceID != 0L) {
                    return new OldGenericNamespaceAddress(AddressSpace.EXTERNAL_SPACE, offset, nameSpaceID);
                }
                return AddressSpace.EXTERNAL_SPACE.getAddress(offset);
            }
            case 7: {
                long offset = value & HASH_OFFSET_MASK;
                return AddressSpace.HASH_SPACE.getAddress(offset);
            }
            case 15: {
                if (value == -2L) {
                    return Address.EXT_FROM_ADDRESS;
                }
                return Address.NO_ADDRESS;
            }
        }
        throw new RuntimeException("Unsupported address type: " + type);
    }

    private long truncateStackOffset(long offset, AddressSpace stackSpace) {
        return offset < 0L ? stackSpace.getMinAddress().getOffset() : stackSpace.getMaxAddress().getOffset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long encodeRelative(Address addr, boolean addrIsNormalized, int indexOperation) {
        AddressSpace addressSpace = addr.getAddressSpace();
        int type = addressSpace.getType();
        switch (type) {
            case 14: {
                if (addr.isHashAddress()) {
                    return 0x7000000000000000L | addr.getOffset();
                }
            }
            case 1: 
            case 2: 
            case 7: 
            case 13: {
                long offset;
                boolean normalize = !addrIsNormalized && this.isInDefaultAddressSpace(addr);
                int baseIndex = this.getBaseAddressIndex(addr, normalize, indexOperation);
                if (baseIndex < 0) {
                    if (baseIndex == Integer.MIN_VALUE) {
                        return -1L;
                    }
                    baseIndex = -baseIndex - 1;
                    if (indexOperation == 3) {
                        offset = 0xFFFFFFFFL;
                        return 0x2000000000000000L | (long)baseIndex << 32 | offset & 0xFFFFFFFFL;
                    } else {
                        if (indexOperation != 2) throw new AssertException("unexpected negative base index");
                        offset = 0L;
                    }
                    return 0x2000000000000000L | (long)baseIndex << 32 | offset & 0xFFFFFFFFL;
                } else {
                    offset = normalize ? this.getNormalizedOffset(addr) : addr.getOffset();
                }
                return 0x2000000000000000L | (long)baseIndex << 32 | offset & 0xFFFFFFFFL;
            }
        }
        return this.encodeAbsolute(addr, indexOperation);
    }

    private long encodeOldNamespaceAddr(OldGenericNamespaceAddress addr) {
        switch (addr.getAddressSpace().getType()) {
            case 5: {
                return 0x4000000000000000L | addr.getNamespaceID() << 32 | addr.getOffset() & 0xFFFFFFFFL;
            }
            case 4: {
                return 0x3000000000000000L | addr.getNamespaceID() << 32 | addr.getOffset() & 0xFFFFFFFFL;
            }
            case 10: {
                return 0x5000000000000000L | addr.getNamespaceID() << 32 | addr.getOffset() & 0xFFFFFFFFL;
            }
        }
        throw new IllegalArgumentException("Address can not be encoded");
    }

    @Override
    public AddressFactory getAddressFactory() {
        return this.addrFactory;
    }

    public void setImageBase(Address base) {
        if (this.useOldAddrMap) {
            throw new IllegalStateException();
        }
        if (base instanceof SegmentedAddress && ((SegmentedAddress)base).getSegmentOffset() != 0) {
            throw new IllegalArgumentException("Segmented base address must have a 0 segment offset");
        }
        this.baseImageOffset = base.getOffset();
    }

    @Override
    public int findKeyRange(List<KeyRange> keyRangeList, Address addr) {
        if (addr == null) {
            return -1;
        }
        return Collections.binarySearch(keyRangeList, addr, this.addressInsertionKeyRangeComparator);
    }

    @Override
    public List<KeyRange> getKeyRanges(Address start, Address end, boolean create) {
        return this.getKeyRanges(start, end, false, create);
    }

    @Override
    public List<KeyRange> getKeyRanges(AddressSetView set, boolean create) {
        return this.getKeyRanges(set, false, create);
    }

    @Override
    public synchronized List<KeyRange> getKeyRanges(Address start, Address end, boolean absolute, boolean create) {
        if (!start.hasSameAddressSpace(end)) {
            return this.getKeyRanges(this.addrFactory.getAddressSet(start, end), create);
        }
        if (this.useOldAddrMap) {
            return this.oldAddrMap.getKeyRanges(start, end, absolute);
        }
        ArrayList<KeyRange> keyRangeList = new ArrayList<KeyRange>();
        this.addKeyRanges(keyRangeList, start, end, absolute, create);
        return keyRangeList;
    }

    private AddressSetView getAllMemoryAndExternalAddresses() {
        AddressSet fullSet = new AddressSet();
        for (AddressSpace space : this.addrFactory.getAllAddressSpaces()) {
            if (!space.isMemorySpace() && !space.isExternalSpace()) continue;
            fullSet.addRange(space.getMinAddress(), space.getMaxAddress());
        }
        return fullSet;
    }

    @Override
    public synchronized List<KeyRange> getKeyRanges(AddressSetView set, boolean absolute, boolean create) {
        if (this.useOldAddrMap) {
            return this.oldAddrMap.getKeyRanges(set, absolute, create);
        }
        ArrayList<KeyRange> keyRangeList = new ArrayList<KeyRange>();
        if (set == null) {
            if (create) {
                throw new IllegalArgumentException("Restricted address set must be specified when iterating over address keys with create enabled");
            }
            if (!absolute) {
                if (this.allKeyRanges == null) {
                    this.getKeyRangesForAddressSet(this.getAllMemoryAndExternalAddresses(), false, false, keyRangeList);
                    this.allKeyRanges = keyRangeList;
                }
                return new ArrayList<KeyRange>(this.allKeyRanges);
            }
            set = this.getAllMemoryAndExternalAddresses();
        }
        this.getKeyRangesForAddressSet(set, absolute, create, keyRangeList);
        return keyRangeList;
    }

    private void getKeyRangesForAddressSet(AddressSetView set, boolean absolute, boolean create, ArrayList<KeyRange> keyRangeList) {
        AddressRangeIterator it = set.getAddressRanges();
        while (it.hasNext()) {
            AddressRange range = (AddressRange)it.next();
            this.addKeyRanges(keyRangeList, range.getMinAddress(), range.getMaxAddress(), absolute, create);
        }
    }

    private void createBaseSegments(Address minAddress, Address maxAddress, boolean absolute) {
        long maxBase;
        long minBase;
        if (!absolute && this.isInDefaultAddressSpace(minAddress)) {
            minBase = this.getNormalizedOffset(minAddress) & 0xFFFFFFFF00000000L;
            maxBase = this.getNormalizedOffset(maxAddress) & 0xFFFFFFFF00000000L;
        } else {
            minBase = minAddress.getOffset() & 0xFFFFFFFF00000000L;
            maxBase = maxAddress.getOffset() & 0xFFFFFFFF00000000L;
        }
        long minSegment = minBase >>> 32;
        long maxSegment = maxBase >>> 32;
        long numBases = minSegment <= maxSegment ? maxSegment - minSegment + 1L : maxSegment + (0x100000000L - minSegment) + 1L;
        if (numBases > 2L) {
            throw new UnsupportedOperationException("Can't create address bases for a range thatextends across more than two upper 32 bit segments!");
        }
        this.getBaseAddressIndex(minAddress.getNewAddress(minBase), false, 0);
        if (minBase != maxBase) {
            this.getBaseAddressIndex(minAddress.getNewAddress(maxBase), false, 0);
        }
    }

    private void addKeyRanges(List<KeyRange> keyRangeList, Address start, Address end, boolean absolute, boolean create) {
        if (start.isMemoryAddress()) {
            Address normalizedEnd;
            if (create) {
                this.createBaseSegments(start, end, absolute);
            }
            Address normalizedStart = absolute ? start : this.getShiftedAddr(start);
            Address address = normalizedEnd = absolute ? end : this.getShiftedAddr(end);
            if (normalizedStart.compareTo(normalizedEnd) > 0) {
                AddressSpace space = normalizedStart.getAddressSpace();
                this.addNormalizedRange(keyRangeList, normalizedStart, space.getMaxAddress(), absolute);
                this.addNormalizedRange(keyRangeList, space.getMinAddress(), normalizedEnd, absolute);
            } else {
                this.addNormalizedRange(keyRangeList, normalizedStart, normalizedEnd, absolute);
            }
        } else {
            long minKey = this.encodeRelative(start, false, 1);
            long maxKey = this.encodeRelative(end, false, 1);
            keyRangeList.add(new KeyRange(minKey, maxKey));
        }
    }

    private void addNormalizedRange(List<KeyRange> keyRangeList, Address normalizedStart, Address normalizedEnd, boolean absolute) {
        int index;
        long maxKey;
        long minKey;
        long l = minKey = absolute ? this.encodeAbsolute(normalizedStart, 1) : this.encodeRelative(normalizedStart, true, 1);
        if (minKey != -1L) {
            long l2 = maxKey = absolute ? this.encodeAbsolute(normalizedEnd, 1) : this.encodeRelative(normalizedEnd, true, 1);
            if (maxKey != -1L && (minKey & 0xFFFFFFFF00000000L) == (maxKey & 0xFFFFFFFF00000000L)) {
                keyRangeList.add(new KeyRange(minKey, maxKey));
                return;
            }
        }
        if ((index = Arrays.binarySearch(this.sortedBaseStartAddrs, normalizedStart)) < 0) {
            index = -index - 2;
        }
        if (index < 0) {
            ++index;
        }
        while (index < this.sortedBaseStartAddrs.length && normalizedEnd.compareTo(this.sortedBaseStartAddrs[index]) >= 0) {
            Address addr2;
            Address addr1 = this.max(normalizedStart, this.sortedBaseStartAddrs[index]);
            if (addr1.compareTo(addr2 = this.min(normalizedEnd, this.sortedBaseEndAddrs[index])) <= 0) {
                minKey = absolute ? this.encodeAbsolute(addr1, 2) : this.encodeRelative(addr1, true, 2);
                long l3 = maxKey = absolute ? this.encodeAbsolute(addr2, 3) : this.encodeRelative(addr2, true, 3);
                if (minKey != -1L && maxKey != -1L) {
                    keyRangeList.add(new KeyRange(minKey, maxKey));
                }
            }
            ++index;
        }
    }

    private Address min(Address a1, Address a2) {
        return a1.compareTo(a2) < 0 ? a1 : a2;
    }

    private Address max(Address a1, Address a2) {
        return a1.compareTo(a2) < 0 ? a2 : a1;
    }

    private Address getShiftedAddr(Address addr) {
        if (addr.getAddressSpace().equals(this.defaultAddrSpace)) {
            return addr.subtractWrapSpace(this.baseImageOffset);
        }
        return addr;
    }

    @Override
    public Address getImageBase() {
        if (this.defaultAddrSpace instanceof SegmentedAddressSpace) {
            return ((SegmentedAddressSpace)this.defaultAddrSpace).getAddress((int)(this.baseImageOffset >> 4), 0);
        }
        return this.defaultAddrSpace.getAddress(this.baseImageOffset);
    }

    public synchronized void setLanguage(Language newLanguage, AddressFactory addrFactory, LanguageTranslator translator) throws IOException {
        List<AddressMapDBAdapter.AddressMapEntry> entries = this.adapter.getEntries();
        ArrayList<AddressMapDBAdapter.AddressMapEntry> newEntries = new ArrayList<AddressMapDBAdapter.AddressMapEntry>();
        AddressFactory oldAddressFactory = this.addrFactory;
        this.addrFactory = addrFactory;
        this.defaultAddrSpace = addrFactory.getDefaultAddressSpace();
        this.adapter.clearAll();
        this.adapter.setAddressFactory(addrFactory);
        for (AddressMapDBAdapter.AddressMapEntry entry : entries) {
            if (entry.deleted) {
                newEntries.add(entry);
                continue;
            }
            AddressSpace oldSpace = oldAddressFactory.getAddressSpace(entry.name);
            if (oldSpace != null && oldSpace.isLoadedMemorySpace() && !oldSpace.isOverlaySpace()) {
                AddressSpace newSpace = translator.getNewAddressSpace(entry.name);
                if (newSpace != null && (entry.segment == 0 || newSpace.getSize() > 32)) {
                    entry.name = newSpace.getName();
                } else {
                    entry.deleted = true;
                }
            }
            newEntries.add(entry);
        }
        this.adapter.setEntries(newEntries);
        this.defaultAddrSpace = addrFactory.getDefaultAddressSpace();
        this.baseAddrs = this.adapter.getBaseAddresses(true);
        this.init(true);
    }

    public synchronized void renameOverlaySpace(String oldName, String newName) throws IOException {
        this.adapter.renameOverlaySpace(oldName, newName);
        this.invalidateCache();
    }

    public synchronized void deleteOverlaySpace(String name) throws IOException {
        this.adapter.deleteOverlaySpace(name);
        this.invalidateCache();
    }
}

