/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.RecordTranslator;
import db.Table;
import db.TranslatedRecordIterator;
import ghidra.program.database.data.FunctionDefinitionDBAdapter;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.util.UniversalID;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class FunctionDefinitionDBAdapterV0
extends FunctionDefinitionDBAdapter
implements RecordTranslator {
    static final int VERSION = 0;
    static final int V0_FUNCTION_DEF_NAME_COL = 0;
    static final int V0_FUNCTION_DEF_COMMENT_COL = 1;
    static final int V0_FUNCTION_DEF_CAT_ID_COL = 2;
    static final int V0_FUNCTION_DEF_RETURN_ID_COL = 3;
    static final int V0_FUNCTION_DEF_FLAGS_COL = 4;
    private Table table;

    public FunctionDefinitionDBAdapterV0(DBHandle handle) throws VersionException {
        this.table = handle.getTable("Function Definitions");
        if (this.table == null) {
            throw new VersionException("Missing Table: Function Definitions");
        }
        int version = this.table.getSchema().getVersion();
        if (version != 0) {
            String msg = "Expected version 0 for table Function Definitions but got " + this.table.getSchema().getVersion();
            if (version < 0) {
                throw new VersionException(msg, 1, true);
            }
            throw new VersionException(msg, 2, false);
        }
    }

    @Override
    public DBRecord createRecord(String name, String comments, long categoryID, long returnDtID, boolean hasVarArgs, GenericCallingConvention genericCallingConvention, long sourceArchiveID, long sourceDataTypeID, long lastChangeTime) throws IOException {
        throw new UnsupportedOperationException("Not allowed to update prior version #0 of Function Definitions table.");
    }

    @Override
    public DBRecord getRecord(long functionDefID) throws IOException {
        return this.translateRecord(this.table.getRecord(functionDefID));
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return new TranslatedRecordIterator(this.table.iterator(), (RecordTranslator)this);
    }

    @Override
    public void updateRecord(DBRecord record, boolean setLastChangeTime) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRecord(long functionDefID) throws IOException {
        return this.table.deleteRecord(functionDefID);
    }

    @Override
    protected void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Function Definitions");
    }

    @Override
    public Field[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 2);
    }

    @Override
    Field[] getRecordIdsForSourceArchive(long archiveID) throws IOException {
        return Field.EMPTY_ARRAY;
    }

    public DBRecord translateRecord(DBRecord oldRec) {
        if (oldRec == null) {
            return null;
        }
        DBRecord rec = FunctionDefinitionDBAdapter.FUN_DEF_SCHEMA.createRecord(oldRec.getKey());
        rec.setString(0, oldRec.getString(0));
        rec.setString(1, oldRec.getString(1));
        rec.setLongValue(2, oldRec.getLongValue(2));
        rec.setLongValue(3, oldRec.getLongValue(3));
        rec.setByteValue(4, oldRec.getByteValue(4));
        rec.setLongValue(5, 0L);
        rec.setLongValue(6, UniversalIdGenerator.nextID().getValue());
        rec.setLongValue(7, 0L);
        rec.setLongValue(8, 0L);
        return rec;
    }

    @Override
    DBRecord getRecordWithIDs(UniversalID sourceID, UniversalID datatypeID) throws IOException {
        return null;
    }
}

