/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.util.UnsignedDataUtils;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.pcoderaw.VarnodeData;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghsymbol.PatternlessSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import java.util.ArrayList;
import org.jdom.Element;

public class VarnodeSymbol
extends PatternlessSymbol {
    private VarnodeData fix = new VarnodeData();

    public VarnodeSymbol(Location location) {
        super(location);
    }

    public void markAsContext() {
    }

    public VarnodeData getFixedVarnode() {
        return this.fix;
    }

    @Override
    public int getSize() {
        return this.fix.size;
    }

    @Override
    public void collectLocalValues(ArrayList<Long> results) {
        if (this.fix.space.getType() == spacetype.IPTR_INTERNAL) {
            results.add(this.fix.offset);
        }
    }

    @Override
    public symbol_type getType() {
        return symbol_type.varnode_symbol;
    }

    public VarnodeSymbol(Location location, String nm, AddrSpace base, long offset, int size) {
        super(location, nm);
        boolean sizeError;
        int addrSize = base.getAddrSize();
        long maxByteOffset = ((long)base.getWordSize() << 8 * addrSize) - 1L;
        long endOffset = offset + (long)size - 1L;
        boolean bl = sizeError = size != 0 && UnsignedDataUtils.unsignedGreaterThan((long)offset, (long)endOffset);
        if (!sizeError && addrSize < 8) {
            sizeError = UnsignedDataUtils.unsignedGreaterThan((long)endOffset, (long)maxByteOffset);
        }
        if (sizeError) {
            throw new SleighError(nm + ":" + size + " @ " + base.getName() + ":" + String.format("0x%x", offset) + " extends beyond end of space (max offset is " + String.format("0x%x", maxByteOffset) + ")", location);
        }
        this.fix.space = base;
        this.fix.offset = offset;
        this.fix.size = size;
    }

    @Override
    public VarnodeTpl getVarnode() {
        return new VarnodeTpl(this.location, new ConstTpl(this.fix.space), new ConstTpl(ConstTpl.const_type.real, this.fix.offset), new ConstTpl(ConstTpl.const_type.real, this.fix.size));
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<varnode_sym");
        this.saveSleighSymbolXmlHeader(s);
        s.append(" space=\"").append(this.fix.space.getName()).append("\"");
        s.append(" offset=\"0x").append(Long.toHexString(this.fix.offset)).append("\"");
        s.append(" size=\"").print(this.fix.size);
        s.append("\"");
        s.append(">\n");
        super.saveXml(s);
        s.append("</varnode_sym>\n");
    }

    @Override
    public void saveXmlHeader(PrintStream s) {
        s.append("<varnode_sym_head");
        this.saveSleighSymbolXmlHeader(s);
        s.append("/>\n");
    }

    @Override
    public void restoreXml(Element el, SleighBase trans) {
        this.fix.space = trans.getSpaceByName(el.getAttributeValue("space"));
        this.fix.offset = XmlUtils.decodeUnknownLong(el.getAttributeValue("offset"));
        this.fix.size = XmlUtils.decodeUnknownInt(el.getAttributeValue("size"));
    }
}

