/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.emulator;

import ghidra.app.emulator.MemoryAccessFilter;
import ghidra.pcode.memstate.MemoryState;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;

class FilteredMemoryState
extends MemoryState {
    private MemoryAccessFilter filter;
    private boolean filterEnabled = true;

    FilteredMemoryState(Language lang) {
        super(lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChunk(byte[] res, AddressSpace spc, long off, int size, boolean stopOnUnintialized) {
        int readLen = super.getChunk(res, spc, off, size, stopOnUnintialized);
        if (this.filterEnabled && this.filter != null) {
            this.filterEnabled = false;
            try {
                this.filter.filterRead(spc, off, readLen, res);
            }
            finally {
                this.filterEnabled = true;
            }
        }
        return readLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChunk(byte[] res, AddressSpace spc, long off, int size) {
        super.setChunk(res, spc, off, size);
        if (this.filterEnabled && this.filter != null) {
            this.filterEnabled = false;
            try {
                this.filter.filterWrite(spc, off, size, res);
            }
            finally {
                this.filterEnabled = true;
            }
        }
    }

    MemoryAccessFilter setFilter(MemoryAccessFilter filter) {
        MemoryAccessFilter oldFilter = this.filter;
        this.filter = filter;
        return oldFilter;
    }
}

