/*
 * Decompiled with CFR 0.152.
 */
package ghidra.docking.settings;

import ghidra.docking.settings.Settings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;

public interface SettingsDefinition {
    public static SettingsDefinition[] concat(SettingsDefinition[] settings, SettingsDefinition ... additional) {
        if (additional == null) {
            return settings;
        }
        if (settings == null) {
            return additional;
        }
        ArrayList<SettingsDefinition> list = new ArrayList<SettingsDefinition>();
        list.addAll(Arrays.asList(settings));
        for (SettingsDefinition def : additional) {
            if (list.contains(def)) continue;
            list.add(def);
        }
        return list.toArray(new SettingsDefinition[list.size()]);
    }

    public static SettingsDefinition[] filterSettingsDefinitions(SettingsDefinition[] definitions, Predicate<SettingsDefinition> filter) {
        ArrayList<SettingsDefinition> list = new ArrayList<SettingsDefinition>();
        for (SettingsDefinition def : definitions) {
            if (!filter.test(def)) continue;
            list.add(def);
        }
        SettingsDefinition[] defs = new SettingsDefinition[list.size()];
        return list.toArray(defs);
    }

    public boolean hasValue(Settings var1);

    public String getValueString(Settings var1);

    public String getName();

    public String getStorageKey();

    public String getDescription();

    public void clear(Settings var1);

    public void copySetting(Settings var1, Settings var2);

    public boolean hasSameValue(Settings var1, Settings var2);
}

